# This script/batch file sets all the envrironment variables required by other batch files and 
# scripts inorder to run the examples, test programs and the SwisSQL - Console application. This
# script/batch file will be invoked by every other script in the SwisSQL - Console distribution so that
# envrionment variables are properly set before running an application. This ensures that users
# have to change the envrironment settings in only one location.

# set the Java home directory
javahome=jre

# Set classpath to Oracle JDBC Driver
oraclejdbc=~/JDBC/classes12.zip

#Set classpath to MSSQL-Server JDBC Driver
mssqlserverjdbc=~/JDBC/mssqlserver.jar:~/JDBC/msbase.jar:~/JDBC/msutil.jar

# Set classpath to PostgreSQL JDBC Driver
postgresqljdbc=~/JDBC/jdbc7.0-1.2.jar

# Set classpath to MySQL JDBC Driver
mysqljdbc=~/JDBC/mm.mysql-2.0.8-bin.jar

# Set classpath to IBM DB2 JDBC Driver
db2jdbc=~/JDBC/db2java.zip

# Set classpath to Informix JDBC Driver
ifxjdbc=~/JDBC/ifxjdbc.jar

# Set classpath to Sybase JDBC Driver
sybjdbc=~/JDBC/jconn2d.jar

# Set classpath to TimesTen JDBC Driver
timestenjdbc=~/JDBC/classes13.jar:~/JDBC/classes14.jar

#Set the home directory of the SwisSQL - Console distribution
SwisSQLHome=.

# set classpath to the SwisSQL Jar files and the database JDBC drivers.
CLASSPATH=$SwisSQLHome/lib:$SwisSQLHome/lib/nb-editor.jar:$SwisSQLHome/lib/SwisSQLAPI.jar:$SwisSQLHome/lib/SwisSQLJDBC.jar:$SwisSQLHome/lib/SwisSQLConsole.jar:$SwisSQLHome/lib/AbsoluteLayout.jar:$oraclejdbc:$mssqlserverjdbc:$postgresqljdbc:$mysqljdbc:$db2jdbc:$ifxjdbc:$sybjdbc:$timestenjdbc:$CLASSPATH

export CLASSPATH
export javahome

