/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.fold;

import org.netbeans.editor.fold.spi.AbstractFold;
import org.netbeans.lib.editor.fold.GapObjectArray;

public class FoldChildren
extends GapObjectArray {
    private static final int INITIAL_INDEX_GAP_LENGTH = 0x3FFFFFFF;
    private int indexGapLength = 0x3FFFFFFF;

    public int getFoldCount() {
        return this.getItemCount();
    }

    public AbstractFold getFold(int index) {
        return (AbstractFold)this.getItem(index);
    }

    public int getFoldIndex(AbstractFold fold) {
        int index = this.getFoldIndexNoCheck(fold);
        if (index >= this.getFoldCount() || this.getFold(index) != fold) {
            index = -1;
        }
        return index;
    }

    public int getFoldIndex(int offset) {
        int foldCount = this.getFoldCount();
        int low = 0;
        int high = foldCount - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            AbstractFold midFold = this.getFold(mid);
            int midFoldEndOffset = midFold.getEndOffset();
            if (midFoldEndOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midFoldEndOffset > offset) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
            break;
        }
        return low;
    }

    private int getFoldIndexNoCheck(AbstractFold fold) {
        return this.getTranslatedFoldIndex(fold.getRawIndex());
    }

    public void replace(int index, int length, AbstractFold[] folds) {
        int insertLength = folds.length;
        if (length == 0) {
            if (this.getFoldCount() == 0) {
                this.ensureCapacity(insertLength);
            }
        } else {
            int endIndex = index + length;
            this.moveIndexGap(endIndex);
            this.indexGapLength += length;
            this.remove(index, length, null);
        }
        if (insertLength > 0) {
            if (length == 0) {
                this.moveIndexGap(index);
            }
            this.indexGapLength -= insertLength;
            for (int i = 0; i < insertLength; ++i) {
                folds[i].setRawIndex(index + i);
            }
            this.insertAll(index, folds);
        }
    }

    private int getTranslatedFoldIndex(int rawIndex) {
        if (rawIndex >= this.indexGapLength) {
            rawIndex -= this.indexGapLength;
        }
        return rawIndex;
    }

    private void moveIndexGap(int index) {
        AbstractFold fold;
        int rawIndex;
        int gapLen = this.indexGapLength;
        int belowIndex = index;
        boolean updated = false;
        while (--belowIndex >= 0 && (rawIndex = (fold = this.getFold(belowIndex)).getRawIndex()) >= gapLen) {
            fold.setRawIndex(rawIndex - gapLen);
            updated = true;
        }
        if (!updated) {
            AbstractFold fold2;
            int rawIndex2;
            int foldCount = this.getFoldCount();
            while (index < foldCount && (rawIndex2 = (fold2 = this.getFold(index++)).getRawIndex()) < gapLen) {
                fold2.setRawIndex(rawIndex2 + gapLen);
            }
        }
    }
}

