/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.fold.api;

import org.netbeans.editor.fold.api.Fold;
import org.netbeans.lib.editor.fold.FoldUtilitiesImpl;

public class FoldStateChange {
    private static final int COLLAPSED_CHANGED_BIT = 1;
    private static final int END_OFFSET_CHANGED_BIT = 2;
    private static final int DESCRIPTION_CHANGED_BIT = 4;
    protected static final int LAST_USED_STATE_CHANGE_BIT = 4;
    private Fold fold;
    private int stateChangeBits;
    private int originalEndOffset = -1;

    public FoldStateChange(Fold fold) {
        this.fold = fold;
    }

    public Fold getFold() {
        return this.fold;
    }

    public boolean isCollapsedChanged() {
        return (this.stateChangeBits & 1) != 0;
    }

    public boolean isEndOffsetChanged() {
        return (this.stateChangeBits & 2) != 0;
    }

    public int getOriginalEndOffset() {
        return this.originalEndOffset;
    }

    public boolean isDescriptionChanged() {
        return (this.stateChangeBits & 4) != 0;
    }

    protected void collapsedChanged() {
        this.stateChangeBits |= 1;
    }

    protected void endOffsetChanged(int originalEndOffset) {
        this.stateChangeBits |= 2;
        this.originalEndOffset = originalEndOffset;
    }

    protected void descriptionChanged() {
        this.stateChangeBits |= 4;
    }

    protected void orStateChangeBits(int bits) {
        this.stateChangeBits |= bits;
    }

    protected final int getStateChangeBits() {
        return this.stateChangeBits;
    }

    public String toString() {
        return FoldUtilitiesImpl.foldStateChangeToString(this);
    }
}

