/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.java.JavaFormatSupport;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaFormatter
extends ExtFormatter {
    public JavaFormatter(Class kitClass) {
        super(kitClass);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JavaSyntax;
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        int[] ret = null;
        BaseDocument doc = Utilities.getDocument(target);
        int dotPos = target.getCaret().getDot();
        if (doc != null) {
            if ("e".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite(doc, dotPos);
                    if (fnw >= 0 && fnw + 4 == dotPos && "else".equals(doc.getText(fnw, 4))) {
                        ret = new int[]{fnw, fnw + 4};
                    }
                }
                catch (BadLocationException e) {}
            } else if (":".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite(doc, dotPos);
                    if (fnw >= 0 && fnw + 4 <= doc.getLength() && "case".equals(doc.getText(fnw, 4))) {
                        ret = new int[]{fnw, fnw + 4};
                    } else if (fnw >= 0 & fnw + 7 <= doc.getLength() && "default".equals(doc.getText(fnw, 7))) {
                        ret = new int[]{fnw, fnw + 7};
                    }
                }
                catch (BadLocationException e) {}
            } else {
                ret = super.getReformatBlock(target, typedText);
            }
        }
        return ret;
    }

    protected void initFormatLayers() {
        this.addFormatLayer(new StripEndWhitespaceLayer());
        this.addFormatLayer(new JavaLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter fw) {
        return new JavaFormatSupport(fw);
    }

    public class JavaLayer
    extends AbstractFormatLayer {
        public JavaLayer() {
            super("java-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new JavaFormatSupport(fw);
        }

        public void format(FormatWriter fw) {
            block6: {
                try {
                    JavaFormatSupport jfs = (JavaFormatSupport)this.createFormatSupport(fw);
                    FormatTokenPosition pos = jfs.getFormatStartPosition();
                    if (jfs.isIndentOnly()) {
                        jfs.indentLine(pos);
                        break block6;
                    }
                    while (pos != null) {
                        jfs.indentLine(pos);
                        this.formatLine(jfs, pos);
                        FormatTokenPosition pos2 = jfs.findLineEnd(pos);
                        if (pos2 != null && pos2.getToken() != null && (pos = jfs.getNextPosition(pos2, Position.Bias.Forward)) != pos2 && pos != null && pos.getToken() != null) {
                            FormatTokenPosition fnw = jfs.findLineFirstNonWhitespace(pos);
                            if (fnw != null) {
                                pos = fnw;
                                continue;
                            }
                            pos = jfs.findLineStart(pos);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        protected void formatLine(JavaFormatSupport jfs, FormatTokenPosition pos) {
            block7: for (TokenItem token = jfs.findLineStart(pos).getToken(); token != null; token = token.getNext()) {
                if (token.getTokenContextPath() != jfs.getTokenContextPath()) continue;
                switch (token.getTokenID().getNumericID()) {
                    case 57: {
                        FormatTokenPosition ftp;
                        FormatTokenPosition endOfPreviousLine;
                        FormatTokenPosition lbracePos;
                        if (jfs.isIndentOnly()) continue block7;
                        if (jfs.getFormatNewlineBeforeBrace()) {
                            lbracePos = jfs.getPosition(token, 0);
                            FormatTokenPosition imp = jfs.findImportant(lbracePos, null, true, true);
                            if (imp == null || imp.getToken().getTokenContextPath() != jfs.getTokenContextPath()) continue block7;
                            switch (imp.getToken().getTokenID().getNumericID()) {
                                case 7: 
                                case 8: {
                                    continue block7;
                                }
                            }
                            FormatTokenPosition next = jfs.findImportant(lbracePos, null, true, false);
                            if (next != null && next.getToken() != null && next.getToken().getTokenID() == JavaTokenContext.RBRACE || !jfs.canInsertToken(token)) continue block7;
                            jfs.insertToken(token, jfs.getValidWhitespaceTokenID(), jfs.getValidWhitespaceTokenContextPath(), "\n");
                            jfs.removeLineEndWhitespace(imp);
                            jfs.indentLine(lbracePos);
                            continue block7;
                        }
                        lbracePos = jfs.getPosition(token, 0);
                        if (jfs.findNonWhitespace(lbracePos, null, true, true) != null || jfs.getNextPosition(lbracePos) != null && jfs.findImportant(jfs.getNextPosition(lbracePos), null, true, false) != null || (endOfPreviousLine = jfs.getPreviousPosition(ftp = jfs.findLineStart(lbracePos))) == null || endOfPreviousLine.getToken().getTokenID() != JavaTokenContext.WHITESPACE) continue block7;
                        ftp = jfs.findLineStart(endOfPreviousLine);
                        if ((ftp = jfs.findImportant(lbracePos, ftp, false, true)) == null || (ftp = jfs.findNonWhitespace(endOfPreviousLine, null, true, true)).getToken().getTokenID() == JavaTokenContext.LINE_COMMENT || ftp.getToken().getTokenID() == JavaTokenContext.LBRACE) continue block7;
                        boolean remove = true;
                        while (remove) {
                            if (token.getPrevious() == endOfPreviousLine.getToken()) {
                                remove = false;
                            }
                            if (!jfs.canRemoveToken(token.getPrevious())) break;
                            jfs.removeToken(token.getPrevious());
                        }
                        if (!jfs.canInsertToken(token)) continue block7;
                        jfs.insertSpaces(token, 1);
                        continue block7;
                    }
                    case 53: {
                        TokenItem prevprevToken;
                        TokenItem prevToken;
                        if (jfs.getFormatSpaceBeforeParenthesis()) {
                            prevToken = token.getPrevious();
                            if (prevToken == null || prevToken.getTokenID() != JavaTokenContext.IDENTIFIER && prevToken.getTokenID() != JavaTokenContext.THIS && prevToken.getTokenID() != JavaTokenContext.SUPER || !jfs.canInsertToken(token)) continue block7;
                            jfs.insertToken(token, jfs.getWhitespaceTokenID(), jfs.getWhitespaceTokenContextPath(), " ");
                            continue block7;
                        }
                        prevToken = token.getPrevious();
                        if (prevToken == null || prevToken.getTokenID() != JavaTokenContext.WHITESPACE || prevToken.getImage().length() != 1 || (prevprevToken = prevToken.getPrevious()) == null || prevprevToken.getTokenID() != JavaTokenContext.IDENTIFIER && prevprevToken.getTokenID() != JavaTokenContext.THIS && prevprevToken.getTokenID() != JavaTokenContext.SUPER || !jfs.canRemoveToken(prevToken)) continue block7;
                        jfs.removeToken(prevToken);
                    }
                }
            }
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("java-strip-whitespace-at-line-end");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new JavaFormatSupport(fw);
        }

        public void format(FormatWriter fw) {
            JavaFormatSupport jfs = (JavaFormatSupport)this.createFormatSupport(fw);
            FormatTokenPosition pos = jfs.getFormatStartPosition();
            if (!jfs.isIndentOnly()) {
                while (pos.getToken() != null) {
                    FormatTokenPosition startPos = pos;
                    if ((pos = jfs.removeLineEndWhitespace(pos)).getToken() != null) {
                        pos = jfs.getNextPosition(pos);
                    }
                    if (!startPos.equals(pos)) continue;
                    break;
                }
            }
        }
    }
}

