/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.lang.ref.WeakReference;

public class WeakHashSet {
    Entry[] data;
    int count = 0;
    int treshold;
    float loadFactor;

    public WeakHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.treshold = (int)((float)capacity * loadFactor);
        this.data = new Entry[capacity];
    }

    public Object get(Object obj) {
        if (obj == null) {
            return null;
        }
        Entry[] tab = this.data;
        Entry prev = null;
        int hash = obj.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                Object value = e.value.get();
                if (value == null) {
                    --this.count;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                } else if (value.equals(obj)) {
                    return value;
                }
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public Object put(Object obj) {
        if (obj == null) {
            return null;
        }
        Entry[] tab = this.data;
        Entry prev = null;
        int hash = obj.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                Object value = e.value.get();
                if (value == null) {
                    --this.count;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                } else if (value.equals(obj)) {
                    return value;
                }
            }
            prev = e;
            e = e.next;
        }
        if (this.count >= this.treshold) {
            this.rehash();
            tab = this.data;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, obj, tab[index]);
        ++this.count;
        return obj;
    }

    private void rehash() {
        int oldCapacity = this.data.length;
        Entry[] oldMap = this.data;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.treshold = (int)((float)newCapacity * this.loadFactor);
        this.data = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    private static class Entry {
        int hash;
        WeakReference value;
        Entry next;

        Entry(int hash, Object value, Entry next) {
            this.hash = hash;
            this.value = new WeakReference<Object>(value);
            this.next = next;
        }
    }
}

