/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.io.IOException;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.openide.ErrorManager;

public class HTMLFormatter
extends ExtFormatter {
    static /* synthetic */ Class class$org$netbeans$editor$ext$html$HTMLSyntaxSupport;

    public HTMLFormatter(Class kitClass) {
        super(kitClass);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof HTMLSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer(new OutLineLayer());
    }

    public Writer reformat(BaseDocument doc, int startOffset, int endOffset, boolean indentOnly) throws BadLocationException, IOException {
        if (startOffset == endOffset) {
            return super.reformat(doc, startOffset, endOffset, indentOnly);
        }
        int pos = Utilities.getRowStart(doc, endOffset);
        TokenItem token = null;
        HTMLSyntaxSupport sup = (HTMLSyntaxSupport)doc.getSyntaxSupport().get(class$org$netbeans$editor$ext$html$HTMLSyntaxSupport == null ? (class$org$netbeans$editor$ext$html$HTMLSyntaxSupport = HTMLFormatter.class$("org.netbeans.editor.ext.html.HTMLSyntaxSupport")) : class$org$netbeans$editor$ext$html$HTMLSyntaxSupport);
        block2: do {
            try {
                int fnw = Utilities.getRowFirstNonWhite(doc, pos);
                if (fnw == -1) {
                    fnw = pos;
                }
                if ((token = sup.getTokenChain(fnw, fnw + 1)) == null || token.getTokenID().getNumericID() != 4 || !token.getTokenContextPath().contains(HTMLTokenContext.contextPath) || token.getImage().charAt(1) != '/') continue;
                String tag = token.getImage().substring(2).trim();
                int poss = -1;
                while (token != null) {
                    if (token.getTokenID().getNumericID() == 4 && token.getTokenContextPath().contains(HTMLTokenContext.contextPath)) {
                        if (token.getImage().substring(1).trim().equals(tag)) {
                            if (poss == 0) {
                                doc.remove(pos, fnw - pos);
                                fnw = Utilities.getRowFirstNonWhite(doc, token.getOffset());
                                poss = Utilities.getRowStart(doc, fnw);
                                doc.insertString(pos, doc.getText(poss, fnw - poss), null);
                                int tagIndentation = Utilities.getRowIndent(doc, pos);
                                if (indentOnly) continue block2;
                                int rowOffset = Utilities.getRowStart(doc, Utilities.getRowStart(doc, pos) - 1);
                                int indentation = Utilities.getRowIndent(doc, pos) + this.getShiftWidth();
                                int delta = 0;
                                while (rowOffset > poss) {
                                    int deltahelp = Utilities.getRowFirstNonWhite(doc, rowOffset);
                                    if (deltahelp > -1 && (token = sup.getTokenChain(deltahelp, deltahelp + 1)) != null && token.getTokenContextPath().contains(HTMLTokenContext.contextPath)) {
                                        this.changeRowIndent(doc, rowOffset, indentation);
                                        int htmlindent = Utilities.getRowIndent(doc, rowOffset);
                                        delta = delta + Utilities.getRowFirstNonWhite(doc, rowOffset) - deltahelp;
                                    }
                                    rowOffset = Utilities.getRowStart(doc, rowOffset - 1);
                                }
                                pos += delta;
                                continue block2;
                            }
                            --poss;
                        } else if (token.getImage().indexOf(tag) > -1) {
                            ++poss;
                        }
                    }
                    token = token.getPrevious();
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        } while ((pos = Utilities.getRowStart(doc, pos - 1)) > startOffset && pos > 0);
        return null;
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        int[] i = super.getReformatBlock(target, typedText);
        if (typedText.charAt(0) == '>') {
            BaseDocument doc = Utilities.getDocument(target);
            int dotPos = target.getCaret().getDot();
            HTMLSyntaxSupport sup = (HTMLSyntaxSupport)doc.getSyntaxSupport().get(class$org$netbeans$editor$ext$html$HTMLSyntaxSupport == null ? (class$org$netbeans$editor$ext$html$HTMLSyntaxSupport = HTMLFormatter.class$("org.netbeans.editor.ext.html.HTMLSyntaxSupport")) : class$org$netbeans$editor$ext$html$HTMLSyntaxSupport);
            try {
                TokenItem token = sup.getTokenChain(dotPos - 1, dotPos);
                int start = token.getOffset();
                if (token.getTokenID().getNumericID() == 4) {
                    while ((token = token.getPrevious()) != null && token.getTokenID().getNumericID() != 4) {
                    }
                    if (token.getImage().length() > 1 && token.getImage().charAt(1) == '/') {
                        String tag = token.getImage().substring(2).trim();
                        int poss = -1;
                        while (token != null) {
                            if (token.getTokenID().getNumericID() == 4) {
                                if (token.getImage().substring(1).trim().equals(tag)) {
                                    if (poss == 0) {
                                        int fnw = Utilities.getRowFirstNonWhite(doc, dotPos);
                                        return new int[]{fnw, dotPos};
                                    }
                                    --poss;
                                } else if (token.getImage().indexOf(tag) > -1) {
                                    ++poss;
                                }
                            }
                            token = token.getPrevious();
                        }
                    }
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
        return i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class OutLineLayer
    extends AbstractFormatLayer {
        public OutLineLayer() {
            super("html-out-line");
        }

        public void format(FormatWriter fw) {
            BaseDocument doc = (BaseDocument)fw.getDocument();
            int dotPos = fw.getOffset();
            if (doc != null && dotPos > 0) {
                try {
                    int firstNonEmptyRow = 0;
                    firstNonEmptyRow = Utilities.getFirstNonWhiteRow(doc, dotPos - 1, false);
                    if (firstNonEmptyRow == -1) {
                        return;
                    }
                    int rstart = Utilities.getRowStart(doc, firstNonEmptyRow);
                    int fNonWhite = Utilities.getFirstNonWhiteFwd(doc, rstart);
                    doc.insertString(dotPos, doc.getText(rstart, fNonWhite - rstart), null);
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify(16, (Throwable)e);
                }
            }
        }
    }
}

