/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.FindDialogPanel;

public class FindDialogSupport
extends WindowAdapter
implements ActionListener {
    private static Object dialogLock = new Object();
    private static boolean isReplaceDialog = false;
    private static JButton[] findButtons;
    private static FindPanel findPanel;
    private static Dialog findDialog;
    private Timer incSearchTimer;
    private int caretPosition;
    private static final String MNEMONIC_SUFFIX = "-mnemonic";
    private static final String A11Y_PREFIX = "ACSD_";
    private static FindDialogSupport singleton;

    public static FindDialogSupport getFindDialogSupport() {
        if (singleton == null) {
            singleton = new FindDialogSupport();
        }
        return singleton;
    }

    private FindDialogSupport() {
        int delay = SettingsUtil.getInteger(null, "find-inc-search-delay", 200);
        this.incSearchTimer = new Timer(delay, new WeakTimerListener(this));
        this.incSearchTimer.setRepeats(false);
    }

    private void createFindButtons() {
        if (findButtons == null) {
            findButtons = new JButton[]{new JButton(LocaleSupport.getString("find-button-find")), new JButton(LocaleSupport.getString("find-button-replace")), new JButton(LocaleSupport.getString("find-button-replace-all")), new JButton(LocaleSupport.getString("find-button-cancel"))};
            findButtons[1].setMnemonic(LocaleSupport.getChar("find-button-replace-mnemonic", 'R'));
            findButtons[2].setMnemonic(LocaleSupport.getChar("find-button-replace-all-mnemonic", 'A'));
            findButtons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-find"));
            findButtons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-replace"));
            findButtons[2].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-replace-all"));
            findButtons[3].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-cancel"));
        }
    }

    private void createFindPanel() {
        if (findPanel == null) {
            findPanel = new FindPanel();
        }
    }

    private Dialog createFindDialog(JPanel findPanel, JButton[] buttons, ActionListener l) {
        Dialog d = DialogSupport.createDialog(isReplaceDialog ? LocaleSupport.getString("replace-title") : LocaleSupport.getString("find-title"), findPanel, false, buttons, true, 0, 3, l);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFindDialogImpl(boolean isReplace) {
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null) {
                if (isReplaceDialog != isReplace) {
                    isReplaceDialog = isReplace;
                    findButtons[1].setVisible(isReplace);
                    findButtons[2].setVisible(isReplace);
                    findPanel.changeVisibility(isReplace);
                    findDialog.setTitle(isReplace ? LocaleSupport.getString("replace-title") : LocaleSupport.getString("find-title"));
                }
                findDialog.toFront();
            } else {
                isReplaceDialog = isReplace;
                this.createFindButtons();
                findButtons[1].setVisible(isReplace);
                findButtons[2].setVisible(isReplace);
                this.createFindPanel();
                findPanel.changeVisibility(isReplace);
                findDialog = this.createFindDialog(findPanel, findButtons, this);
                findDialog.addWindowListener(this);
                ((JDialog)findDialog).getRootPane().setFocusable(false);
            }
        }
        findDialog.pack();
        findPanel.init(isReplace);
        findDialog.setVisible(true);
        findPanel.showNotify();
        JTextComponent c = Utilities.getLastActiveComponent();
        if (c != null) {
            this.caretPosition = c.getCaret().getDot();
        }
    }

    public void windowActivated(WindowEvent evt) {
        this.incSearchTimer.start();
    }

    public void windowDeactivated(WindowEvent evt) {
        this.incSearchTimer.stop();
        FindSupport.getFindSupport().incSearchReset();
    }

    public void windowClosing(WindowEvent e) {
        this.hideDialog();
    }

    public void windowClosed(WindowEvent e) {
        this.incSearchTimer.stop();
        FindSupport.getFindSupport().incSearchReset();
        Utilities.returnFocus();
    }

    public void showFindDialog() {
        this.showFindDialogImpl(false);
    }

    public void showReplaceDialog() {
        this.showFindDialogImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideDialog() {
        Object object = dialogLock;
        synchronized (object) {
            findDialog.dispose();
            findDialog = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (findButtons == null) {
            return;
        }
        Object src = evt.getSource();
        FindSupport fSup = FindSupport.getFindSupport();
        if (src == findButtons[0]) {
            findPanel.updateFindHistory();
            fSup.putFindProperties(findPanel.getFindProps());
            fSup.find(null, false);
            if (!isReplaceDialog) {
                this.hideDialog();
            }
        } else if (src == findButtons[1]) {
            findPanel.updateFindHistory();
            findPanel.updateReplaceHistory();
            fSup.putFindProperties(findPanel.getFindProps());
            try {
                if (fSup.replace(null, false)) {
                    fSup.find(null, false);
                }
            }
            catch (GuardedException e) {
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (src == findButtons[2]) {
            findPanel.updateFindHistory();
            findPanel.updateReplaceHistory();
            fSup.putFindProperties(findPanel.getFindProps());
            fSup.replaceAll(null);
        } else if (src == findButtons[3]) {
            findPanel.getFindProps().putAll(fSup.getFindProperties());
            this.hideDialog();
            JTextComponent c = Utilities.getLastActiveComponent();
            if (c != null) {
                Caret caret = c.getCaret();
                if (caret instanceof BaseCaret) {
                    ((BaseCaret)caret).setDot(this.caretPosition, false);
                } else {
                    caret.setDot(this.caretPosition);
                }
            }
        } else if (src == this.incSearchTimer) {
            fSup.incSearch(findPanel.getFindProps());
        }
    }

    static {
        findDialog = null;
        singleton = null;
    }

    private class FindPanel
    extends FindDialogPanel
    implements ItemListener,
    KeyListener,
    ActionListener,
    FocusListener {
        private Map findProps = Collections.synchronizedMap(new HashMap(20));
        private Map objToProps = Collections.synchronizedMap(new HashMap(20));
        private Vector findHistory;
        private Vector replaceHistory;

        FindPanel() {
            this.objToProps.put(this.findWhat, "find-what");
            this.objToProps.put(this.replaceWith, "find-replace-with");
            this.objToProps.put(this.highlightSearch, "find-highlight-search");
            this.objToProps.put(this.incSearch, "find-inc-search");
            this.objToProps.put(this.matchCase, "find-match-case");
            this.objToProps.put(this.smartCase, "find-smart-case");
            this.objToProps.put(this.wholeWords, "find-whole-words");
            this.objToProps.put(this.regExp, "find-reg-exp");
            this.objToProps.put(this.bwdSearch, "find-backward-search");
            this.objToProps.put(this.wrapSearch, "find-wrap-search");
            this.findProps.putAll(FindSupport.getFindSupport().getFindProperties());
            this.revertMap();
            this.findWhat.getEditor().setItem(this.getProperty(this.findWhat));
            this.replaceWith.getEditor().setItem(this.getProperty(this.replaceWith));
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.smartCase.setSelected(this.getBooleanProperty(this.smartCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            this.regExp.setSelected(this.getBooleanProperty(this.regExp));
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
            this.regExp.setEnabled(false);
            this.regExp.setVisible(false);
            this.findHistory = new Vector();
            this.replaceHistory = new Vector();
            this.findWhat.getEditor().getEditorComponent().addKeyListener(this);
            this.findWhat.addActionListener(this);
            this.replaceWith.getEditor().getEditorComponent().addKeyListener(this);
            this.replaceWith.addActionListener(this);
            this.highlightSearch.addItemListener(this);
            this.incSearch.addItemListener(this);
            this.matchCase.addItemListener(this);
            this.smartCase.addItemListener(this);
            this.wholeWords.addItemListener(this);
            this.regExp.addItemListener(this);
            this.bwdSearch.addItemListener(this);
            this.wrapSearch.addItemListener(this);
        }

        protected Map getFindProps() {
            return this.findProps;
        }

        private void putProperty(Object component, Object value) {
            String prop = (String)this.objToProps.get(component);
            if (prop != null) {
                this.findProps.put(prop, value);
                FindDialogSupport.this.incSearchTimer.restart();
            }
        }

        private Object getProperty(Object component) {
            String prop = (String)this.objToProps.get(component);
            return prop != null ? this.findProps.get(prop) : null;
        }

        private boolean getBooleanProperty(Object component) {
            Object prop = this.getProperty(component);
            return prop != null ? (Boolean)prop : false;
        }

        protected void changeVisibility(boolean v) {
            this.replaceWith.setVisible(v);
            this.replaceWithLabel.setVisible(v);
        }

        protected void init(boolean isReplace) {
            this.findWhat.setModel(new DefaultComboBoxModel(this.findHistory));
            this.findWhat.getEditor().getEditorComponent().addFocusListener(this);
            if (isReplace) {
                this.replaceWith.setModel(new DefaultComboBoxModel(this.replaceHistory));
                this.replaceWith.getEditor().getEditorComponent().addFocusListener(this);
            }
            JTextComponent c = Utilities.getLastActiveComponent();
            String selText = null;
            if (c != null && (selText = c.getSelectedText()) != null) {
                int n = selText.indexOf(10);
                if (n >= 0) {
                    selText = selText.substring(0, n);
                }
                this.findWhat.getEditor().setItem(selText.trim());
                this.changeFindWhat();
            }
        }

        protected void showNotify() {
            this.findWhat.getEditor().getEditorComponent().requestFocus();
        }

        private void updateHistory(JComboBox c, Vector history) {
            Object item = c.getEditor().getItem();
            if (item != null && !item.equals("")) {
                int index = history.indexOf(item);
                if (index >= 0) {
                    history.remove(index);
                }
                history.add(0, item);
            }
        }

        protected void updateFindHistory() {
            this.updateHistory(this.findWhat, this.findHistory);
        }

        protected void updateReplaceHistory() {
            this.updateHistory(this.replaceWith, this.replaceHistory);
        }

        private void revertMap() {
            Object prop = this.findProps.get("revert-map");
            if (!(prop instanceof Map)) {
                return;
            }
            Map revertMap = (Map)prop;
            Iterator i = revertMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object obj = this.findProps.get(key);
                boolean value = obj != null ? (Boolean)obj : false;
                value = !value;
                this.findProps.put(key, value ? Boolean.TRUE : Boolean.FALSE);
            }
            this.findProps.put("revert-map", null);
        }

        private void changeFindWhat() {
            Object old = this.getProperty(this.findWhat);
            Object cur = this.findWhat.getEditor().getItem();
            if (old == null || !old.equals(cur)) {
                this.putProperty(this.findWhat, cur);
            }
        }

        private void changeReplaceWith() {
            Object old = this.getProperty(this.replaceWith);
            Object cur = this.replaceWith.getEditor().getItem();
            if (old == null || !old.equals(cur)) {
                this.putProperty(this.replaceWith, cur);
            }
        }

        private void postChangeCombos() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    FindPanel.access$100(this.this$1);
                    FindPanel.access$200(this.this$1);
                }
            });
        }

        public void keyPressed(KeyEvent evt) {
        }

        public void keyReleased(KeyEvent evt) {
            this.postChangeCombos();
        }

        public void keyTyped(KeyEvent evt) {
            if (evt.getKeyChar() == '\n') {
                FindDialogSupport.this.actionPerformed(new ActionEvent(findButtons[0], 0, null));
            }
        }

        public void itemStateChanged(ItemEvent evt) {
            Boolean val = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
            this.putProperty(evt.getSource(), val);
        }

        public void actionPerformed(ActionEvent evt) {
            this.postChangeCombos();
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                ((JTextField)e.getSource()).selectAll();
            }
            ((JComponent)e.getSource()).removeFocusListener(this);
        }

        public void focusLost(FocusEvent e) {
        }

        static /* synthetic */ void access$100(FindPanel x0) {
            x0.changeFindWhat();
        }

        static /* synthetic */ void access$200(FindPanel x0) {
            x0.changeReplaceWith();
        }
    }
}

