/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.CompletionPane;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtCompletionPane;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.JDCPopupPanel;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.ScrollCompletionPane;
import org.netbeans.editor.ext.ScrollJavaDocPane;
import org.openide.util.RequestProcessor;

public class Completion
implements PropertyChangeListener,
SettingsChangeListener,
ActionListener {
    protected ExtEditorUI extEditorUI;
    private CompletionQuery query;
    private CompletionQuery.Result lastResult;
    private boolean keyPressed = false;
    private CompletionView view;
    private ExtCompletionPane pane;
    private JavaDocPane javaDocPane;
    private JDCPopupPanel jdcPopupPanel;
    private boolean autoPopup;
    private int autoPopupDelay;
    private int refreshDelay;
    private boolean instantSubstitution;
    Timer timer;
    Timer docChangeTimer;
    private DocumentListener docL;
    private CaretListener caretL;
    private PropertyChangeListener docChangeL;
    private int caretPos = -1;
    private static RequestProcessor serializingRequestProcessor;
    private static final String PROP_DEBUG_COMPLETION = "editor.debug.completion";
    private static final boolean DEBUG_COMPLETION;
    private CancelableRunnable cancellable = new CancelableRunnable(){

        public void run() {
        }
    };
    static /* synthetic */ Class class$org$netbeans$editor$ext$ExtSyntaxSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Completion(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        this.timer = new Timer(0, new WeakTimerListener(this));
        this.timer.setRepeats(false);
        this.docChangeTimer = new Timer(0, new WeakTimerListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Completion.this.setKeyPressed(true);
                Completion.this.invalidateLastResult();
                Completion.this.refreshImpl(false);
            }
        }));
        this.docChangeTimer.setRepeats(false);
        class CompletionDocumentListener
        implements DocumentListener {
            CompletionDocumentListener() {
            }

            private void processTimer() {
                Completion.this.docChangeTimer.stop();
                Completion.this.docChangeTimer.setInitialDelay(Completion.this.refreshDelay);
                Completion.this.docChangeTimer.setDelay(Completion.this.refreshDelay);
                Completion.this.docChangeTimer.start();
            }

            public void insertUpdate(DocumentEvent evt) {
                Completion.trace("ENTRY insertUpdate");
                this.processTimer();
            }

            public void removeUpdate(DocumentEvent evt) {
                Completion.trace("ENTRY removeUpdate");
                this.processTimer();
            }

            public void changedUpdate(DocumentEvent evt) {
            }
        }
        this.docL = new CompletionDocumentListener();
        class CompletionCaretListener
        implements CaretListener {
            CompletionCaretListener() {
            }

            public void caretUpdate(CaretEvent e) {
                Completion.trace("ENTRY caretUpdate");
                if (!Completion.this.isPaneVisible()) {
                    Completion.this.cancelRequestImpl();
                } else {
                    Completion.this.refreshImpl(true);
                }
            }
        }
        this.caretL = new CompletionCaretListener();
        Settings.addSettingsChangeListener(this);
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent component = extEditorUI.getComponent();
            if (component != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, component));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            this.autoPopup = SettingsUtil.getBoolean(kitClass, "completion-auto-popup", ExtSettingsDefaults.defaultCompletionAutoPopup);
            this.autoPopupDelay = SettingsUtil.getInteger(kitClass, "completion-auto-popup-delay", ExtSettingsDefaults.defaultCompletionAutoPopupDelay);
            this.refreshDelay = SettingsUtil.getInteger(kitClass, "completion-refresh-delay", ExtSettingsDefaults.defaultCompletionRefreshDelay);
            this.instantSubstitution = SettingsUtil.getBoolean(kitClass, "completion-instant-substitution", ExtSettingsDefaults.defaultCompletionInstantSubstitution);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("component".equals(propName)) {
            JTextComponent component = (JTextComponent)evt.getNewValue();
            if (component != null) {
                this.settingsChange(null);
                BaseDocument doc = Utilities.getDocument(component);
                if (doc != null) {
                    doc.addDocumentListener(this.docL);
                }
                component.addCaretListener(this.caretL);
            } else {
                this.setPaneVisible(false);
                component = (JTextComponent)evt.getOldValue();
                BaseDocument doc = Utilities.getDocument(component);
                if (doc != null) {
                    doc.removeDocumentListener(this.docL);
                }
                if (component != null) {
                    component.removeCaretListener(this.caretL);
                }
            }
        } else if ("document".equals(propName)) {
            if (evt.getOldValue() instanceof BaseDocument) {
                ((BaseDocument)evt.getOldValue()).removeDocumentListener(this.docL);
            }
            if (evt.getNewValue() instanceof BaseDocument) {
                ((BaseDocument)evt.getNewValue()).addDocumentListener(this.docL);
            }
        }
    }

    public CompletionPane getPane() {
        return this.getExtPane();
    }

    public ExtCompletionPane getExtPane() {
        if (this.pane == null) {
            this.pane = new ScrollCompletionPane(this.extEditorUI);
        }
        return this.pane;
    }

    protected CompletionView createView() {
        return new ListCompletionView();
    }

    public final CompletionView getView() {
        if (this.view == null) {
            this.view = this.createView();
        }
        return this.view;
    }

    protected CompletionQuery createQuery() {
        return null;
    }

    public final CompletionQuery getQuery() {
        if (this.query == null) {
            this.query = this.createQuery();
        }
        return this.query;
    }

    public JavaDocPane getJavaDocPane() {
        if (this.javaDocPane == null) {
            this.javaDocPane = new ScrollJavaDocPane(this.extEditorUI);
        }
        return this.javaDocPane;
    }

    public final JDCPopupPanel getJDCPopupPanelIfExists() {
        return this.jdcPopupPanel;
    }

    public JDCPopupPanel getJDCPopupPanel() {
        if (this.jdcPopupPanel == null) {
            this.jdcPopupPanel = new JDCPopupPanel(this.extEditorUI, this.getExtPane(), this);
        }
        return this.jdcPopupPanel;
    }

    public final synchronized CompletionQuery.Result getLastResult() {
        return this.lastResult;
    }

    public final synchronized void invalidateLastResult() {
        this.currentTask().cancel();
        this.lastResult = null;
        this.caretPos = -1;
    }

    private synchronized void setKeyPressed(boolean value) {
        this.keyPressed = true;
    }

    private synchronized boolean isKeyPressed() {
        return this.keyPressed;
    }

    public synchronized Object getSelectedValue() {
        int index;
        if (this.lastResult != null && (index = this.getView().getSelectedIndex()) >= 0 && index < this.lastResult.getData().size()) {
            return this.lastResult.getData().get(index);
        }
        return null;
    }

    public boolean isAutoPopupEnabled() {
        return this.autoPopup;
    }

    public boolean isPaneVisible() {
        return this.pane != null && this.pane.isVisible();
    }

    public void setPaneVisible(boolean visible) {
        Completion.trace("ENTRY setPaneVisible " + visible);
        if (visible) {
            if (this.extEditorUI.getComponent() != null) {
                this.popupImpl(false);
            }
        } else if (this.pane != null) {
            this.cancelRequestImpl();
            this.invalidateLastResult();
            this.getJDCPopupPanel().setCompletionVisible(false);
            this.caretPos = -1;
        }
    }

    public void completionCancel() {
        Completion.trace("ENTRY completionCancel");
        if (this.pane != null) {
            this.cancelRequestImpl();
            this.invalidateLastResult();
            this.caretPos = -1;
        }
    }

    public void refresh(boolean postRequest) {
        Completion.trace("ENTRY refresh " + postRequest);
        this.refreshImpl(postRequest);
    }

    private synchronized void refreshImpl(boolean postRequest) {
        if (!this.isPaneVisible()) {
            return;
        }
        class RefreshTask
        implements Runnable {
            private final boolean batch;

            RefreshTask(boolean batch) {
                this.batch = batch;
            }

            public void run() {
                if (Completion.this.isPaneVisible()) {
                    Completion.this.timer.stop();
                    if (this.batch) {
                        Completion.this.timer.setInitialDelay(Completion.this.refreshDelay);
                        Completion.this.timer.setDelay(Completion.this.refreshDelay);
                        Completion.this.timer.start();
                    } else {
                        Completion.this.actionPerformed(null);
                    }
                }
            }
        }
        SwingUtilities.invokeLater(new RefreshTask(postRequest));
    }

    public void popup(boolean postRequest) {
        Completion.trace("ENTRY popup " + postRequest);
        this.popupImpl(postRequest);
    }

    private synchronized void popupImpl(boolean postRequest) {
        if (this.isPaneVisible()) {
            this.refreshImpl(postRequest);
        } else {
            this.timer.stop();
            if (postRequest) {
                this.timer.setInitialDelay(this.autoPopupDelay);
                this.timer.setDelay(this.autoPopupDelay);
                this.timer.start();
            } else {
                this.actionPerformed(null);
            }
        }
    }

    public void cancelRequest() {
        Completion.trace("ENTRY cancelRequest");
        this.cancelRequestImpl();
    }

    private synchronized void cancelRequestImpl() {
        this.timer.stop();
    }

    public synchronized void actionPerformed(ActionEvent evt) {
        if (this.jdcPopupPanel == null) {
            this.extEditorUI.getCompletionJavaDoc();
        }
        JTextComponent component = this.extEditorUI.getComponent();
        BaseDocument doc = Utilities.getDocument(component);
        if (component != null && doc != null) {
            ExtSyntaxSupport sup;
            boolean provokedByAutoPopup;
            boolean bl = provokedByAutoPopup = evt != null;
            if (provokedByAutoPopup && (sup = (ExtSyntaxSupport)doc.getSyntaxSupport().get(class$org$netbeans$editor$ext$ExtSyntaxSupport == null ? (class$org$netbeans$editor$ext$ExtSyntaxSupport = Completion.class$("org.netbeans.editor.ext.ExtSyntaxSupport")) : class$org$netbeans$editor$ext$ExtSyntaxSupport)) != null && !sup.isPrepared()) {
                return;
            }
            try {
                if (this.caretPos != -1 && Utilities.getRowStart(component, component.getCaret().getDot()) != Utilities.getRowStart(component, this.caretPos) && component.getCaret().getDot() - this.caretPos > 0) {
                    this.getJDCPopupPanel().setCompletionVisible(false);
                    this.caretPos = -1;
                    return;
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
            this.caretPos = component.getCaret().getDot();
            this.currentTask().cancel();
            boolean reentrantProvider = this.getQuery() instanceof CompletionQuery.SupportsSpeculativeInvocation;
            RequestProcessor rp = reentrantProvider ? RequestProcessor.getDefault() : this.getSerialiazingRequestProcessor();
            class PendingTask
            extends CancelableRunnable {
                PendingTask() {
                }

                public void run() {
                    if (this.cancelled()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ PendingTask this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            if (this.this$1.cancelled()) {
                                return;
                            }
                            Completion.access$600(PendingTask.access$500(this.this$1));
                        }
                    });
                }

                static /* synthetic */ Completion access$500(PendingTask x0) {
                    return x0.Completion.this;
                }
            }
            PendingTask wait = new PendingTask();
            class QueryTask
            extends CancelableRunnable {
                private final CancelableRunnable wait;
                private final boolean isPaneVisible;
                private final /* synthetic */ JTextComponent val$component;

                public QueryTask(CancelableRunnable wait, boolean isPaneVisible, JTextComponent val$component) {
                    this.val$component = val$component;
                    this.wait = wait;
                    this.isPaneVisible = isPaneVisible;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (this.cancelled()) {
                        return;
                    }
                    try {
                        Completion.this.performQuery(this.val$component);
                        Object var2_1 = null;
                        this.wait.cancel();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        this.wait.cancel();
                        if (this.cancelled()) {
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ QueryTask this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                if (this.this$1.cancelled()) {
                                    return;
                                }
                                CompletionQuery.Result res = Completion.access$900(QueryTask.access$800(this.this$1));
                                if (res != null && Completion.access$1000(QueryTask.access$800(this.this$1)) && res.getData().size() == 1 && !QueryTask.access$1100(this.this$1) && Completion.access$1300(QueryTask.access$800(this.this$1), Completion.access$1200(QueryTask.access$800(this.this$1)))) {
                                    QueryTask.access$800(this.this$1).setPaneVisible(false);
                                    return;
                                }
                                Completion.access$1400(QueryTask.access$800(this.this$1));
                            }
                        });
                        throw throwable;
                    }
                    if (this.cancelled()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }

                void cancel() {
                    super.cancel();
                    this.wait.cancel();
                }

                static /* synthetic */ Completion access$800(QueryTask x0) {
                    return x0.Completion.this;
                }

                static /* synthetic */ boolean access$1100(QueryTask x0) {
                    return x0.isPaneVisible;
                }
            }
            QueryTask task = new QueryTask(wait, this.getPane().isVisible(), component);
            this.currentTask(task);
            if (!provokedByAutoPopup) {
                RequestProcessor.getDefault().post((Runnable)wait, 100);
            }
            rp.post((Runnable)task);
        }
    }

    private void performWait() {
        this.getPane().setTitle(LocaleSupport.getString("ext.Completion.wait"));
        this.getView().setResult(null);
        if (this.isPaneVisible()) {
            this.getJDCPopupPanel().refresh();
        } else {
            this.getJDCPopupPanel().setCompletionVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performQuery(JTextComponent target) {
        BaseDocument doc = Utilities.getDocument(target);
        long start = System.currentTimeMillis();
        try {
            this.lastResult = this.getQuery().query(target, this.caretPos, doc.getSyntaxSupport());
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Completion.trace("performQuery took " + (System.currentTimeMillis() - start) + "ms");
            this.setKeyPressed(false);
            throw throwable;
        }
        Completion.trace("performQuery took " + (System.currentTimeMillis() - start) + "ms");
        this.setKeyPressed(false);
    }

    private void performResults() {
        CompletionQuery.Result res = this.lastResult;
        if (res != null) {
            if (this.instantSubstitution && res.getData().size() == 1 && !this.isPaneVisible() && this.instantSubstitutionImpl(this.caretPos)) {
                return;
            }
            this.getPane().setTitle(res.getTitle());
            this.getView().setResult(res);
            if (this.isPaneVisible()) {
                this.getJDCPopupPanel().refresh();
            } else {
                this.getJDCPopupPanel().setCompletionVisible(true);
            }
        } else {
            this.getJDCPopupPanel().setCompletionVisible(false);
            if (!this.isKeyPressed()) {
                this.caretPos = -1;
            } else {
                this.setKeyPressed(false);
            }
        }
    }

    public boolean instantSubstitution(int caretPos) {
        Completion.trace("ENTRY instantSubstitution " + caretPos);
        return this.instantSubstitutionImpl(caretPos);
    }

    private synchronized boolean instantSubstitutionImpl(int caretPos) {
        if (this.getLastResult() == null) {
            return false;
        }
        JTextComponent comp = this.extEditorUI.getComponent();
        try {
            if (comp == null || Utilities.getWordEnd(comp, caretPos) > caretPos) {
                return false;
            }
            return this.getLastResult().substituteText(0, true);
        }
        catch (BadLocationException ble) {
            return false;
        }
    }

    public synchronized boolean substituteText(boolean shift) {
        Completion.trace("ENTRY substituteText " + shift);
        if (this.lastResult != null) {
            int index = this.getView().getSelectedIndex();
            if (index >= 0) {
                this.lastResult.substituteText(index, shift);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean substituteCommonText() {
        Completion.trace("ENTRY substituteCommonText");
        if (this.lastResult != null) {
            int index = this.getView().getSelectedIndex();
            if (index >= 0) {
                this.lastResult.substituteCommonText(index);
            }
            return true;
        }
        return false;
    }

    private void currentTask(CancelableRunnable task) {
        this.cancellable = task;
    }

    private CancelableRunnable currentTask() {
        return this.cancellable;
    }

    private synchronized RequestProcessor getSerialiazingRequestProcessor() {
        if (serializingRequestProcessor == null) {
            serializingRequestProcessor = new RequestProcessor("editor.completion", 1);
        }
        return serializingRequestProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trace(String msg) {
        if (DEBUG_COMPLETION && Boolean.getBoolean(PROP_DEBUG_COMPLETION)) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println(msg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$600(Completion x0) {
        x0.performWait();
    }

    static /* synthetic */ CompletionQuery.Result access$900(Completion x0) {
        return x0.lastResult;
    }

    static /* synthetic */ boolean access$1000(Completion x0) {
        return x0.instantSubstitution;
    }

    static /* synthetic */ int access$1200(Completion x0) {
        return x0.caretPos;
    }

    static /* synthetic */ boolean access$1300(Completion x0, int x1) {
        return x0.instantSubstitutionImpl(x1);
    }

    static /* synthetic */ void access$1400(Completion x0) {
        x0.performResults();
    }

    static {
        DEBUG_COMPLETION = Boolean.getBoolean(PROP_DEBUG_COMPLETION);
    }

    abstract class CancelableRunnable
    implements Runnable {
        private boolean cancelled = false;

        CancelableRunnable() {
        }

        boolean cancelled() {
            return this.cancelled;
        }

        void cancel() {
            this.cancelled = true;
        }
    }
}

