/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class PopupManager {
    private JComponent popup = null;
    private JTextComponent textComponent;
    public static final Placement Above = new Placement("Above");
    public static final Placement Below = new Placement("Below");
    public static final Placement Largest = new Placement("Largest");
    public static final Placement AbovePreferred = new Placement("AbovePreferred");
    public static final Placement BelowPreferred = new Placement("BelowPreferred");
    public static final HorizontalBounds ViewPortBounds = new HorizontalBounds("ViewPort");
    public static final HorizontalBounds ScrollBarBounds = new HorizontalBounds("ScrollBar");
    private KeyListener keyListener;
    private TextComponentListener componentListener;
    static /* synthetic */ Class class$org$netbeans$editor$PopupManager$Placement;

    public PopupManager(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.keyListener = new PopupKeyListener();
        textComponent.addKeyListener(this.keyListener);
        this.componentListener = new TextComponentListener();
        textComponent.addComponentListener(this.componentListener);
    }

    public void install(JComponent popup) {
        if (this.textComponent == null) {
            return;
        }
        int caretPos = this.textComponent.getCaret().getDot();
        try {
            Rectangle caretBounds = this.textComponent.modelToView(caretPos);
            this.install(popup, caretBounds, Largest);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void uninstall(JComponent popup) {
        if (this.popup != null) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            this.removeFromRootPane(this.popup);
        }
        if (popup != this.popup && popup != null) {
            if (popup.isVisible()) {
                popup.setVisible(false);
            }
            this.removeFromRootPane(popup);
        }
    }

    public void install(JComponent popup, Rectangle cursorBounds, Placement placement, HorizontalBounds horizontalBounds, int horizontalAdjustment, int verticalAdjustment) {
        Rectangle bounds;
        if (this.popup != null) {
            if (this.popup.isVisible() && this.popup != popup) {
                this.popup.setVisible(false);
            }
            this.removeFromRootPane(this.popup);
        }
        this.popup = popup;
        if (this.popup != null) {
            this.installToRootPane(this.popup);
        }
        if ((bounds = PopupManager.computeBounds(this.popup, this.textComponent, cursorBounds, placement, horizontalBounds)) != null) {
            JRootPane rp;
            if (horizontalBounds == ScrollBarBounds) {
                bounds.x = 0;
            }
            if ((rp = this.textComponent.getRootPane()) != null) {
                bounds = SwingUtilities.convertRectangle(this.textComponent, bounds, rp.getLayeredPane());
            }
            if (horizontalBounds == ScrollBarBounds && this.textComponent.getParent() instanceof JViewport) {
                int shift = this.textComponent.getParent().getX();
                Rectangle viewBounds = ((JViewport)this.textComponent.getParent()).getViewRect();
                bounds.x += viewBounds.x;
                bounds.x -= shift;
                bounds.width += shift;
            }
            bounds.x += horizontalAdjustment;
            bounds.y += verticalAdjustment;
            bounds.width -= horizontalAdjustment;
            bounds.height -= verticalAdjustment;
            this.popup.setBounds(bounds);
        } else {
            this.popup.setVisible(false);
        }
    }

    public void install(JComponent popup, Rectangle cursorBounds, Placement placement, HorizontalBounds horizontalBounds) {
        this.install(popup, cursorBounds, placement, ViewPortBounds, 0, 0);
    }

    public void install(JComponent popup, Rectangle cursorBounds, Placement placement) {
        this.install(popup, cursorBounds, placement, ViewPortBounds);
    }

    public JComponent get() {
        return this.popup;
    }

    private void installToRootPane(JComponent c) {
        JRootPane rp = this.textComponent.getRootPane();
        if (rp != null) {
            rp.getLayeredPane().add(c, JLayeredPane.POPUP_LAYER, 0);
        }
    }

    private void removeFromRootPane(JComponent c) {
        JRootPane rp = c.getRootPane();
        if (rp != null) {
            rp.getLayeredPane().remove(c);
        }
    }

    protected static Rectangle computeBounds(JComponent popup, JComponent view, Rectangle cursorBounds, Placement placement, HorizontalBounds horizontalBounds) {
        Rectangle ret;
        Container viewParent;
        if (horizontalBounds == null) {
            horizontalBounds = ViewPortBounds;
        }
        if ((viewParent = view.getParent()) instanceof JViewport) {
            Rectangle viewBounds = ((JViewport)viewParent).getViewRect();
            Rectangle translatedCursorBounds = (Rectangle)cursorBounds.clone();
            translatedCursorBounds.translate(-viewBounds.x, -viewBounds.y);
            ret = PopupManager.computeBounds(popup, viewBounds.width, viewBounds.height, translatedCursorBounds, placement, horizontalBounds);
            if (ret != null) {
                ret.translate(viewBounds.x, viewBounds.y);
            }
        } else {
            ret = PopupManager.computeBounds(popup, view.getWidth(), view.getHeight(), cursorBounds, placement);
        }
        return ret;
    }

    protected static Rectangle computeBounds(JComponent popup, JComponent view, Rectangle cursorBounds, Placement placement) {
        return PopupManager.computeBounds(popup, view, cursorBounds, placement, ViewPortBounds);
    }

    protected static Rectangle computeBounds(JComponent popup, int viewWidth, int viewHeight, Rectangle cursorBounds, Placement placement, HorizontalBounds horizontalBounds) {
        Placement updatedPlacement;
        if (placement == null) {
            throw new NullPointerException("placement cannot be null");
        }
        int aboveCursorHeight = cursorBounds.y;
        int belowCursorY = cursorBounds.y + cursorBounds.height;
        int belowCursorHeight = viewHeight - belowCursorY;
        if (placement == Largest) {
            placement = aboveCursorHeight < belowCursorHeight ? Below : Above;
        } else if (placement == AbovePreferred && aboveCursorHeight > belowCursorHeight) {
            placement = Above;
        } else if (placement == BelowPreferred && belowCursorHeight > aboveCursorHeight) {
            placement = Below;
        }
        Rectangle popupBounds = null;
        while (true) {
            popup.putClientProperty(class$org$netbeans$editor$PopupManager$Placement == null ? PopupManager.class$("org.netbeans.editor.PopupManager$Placement") : class$org$netbeans$editor$PopupManager$Placement, placement);
            int height = placement == Above || placement == AbovePreferred ? aboveCursorHeight : belowCursorHeight;
            popup.setSize(viewWidth, height);
            popupBounds = popup.getBounds();
            updatedPlacement = (Placement)popup.getClientProperty(class$org$netbeans$editor$PopupManager$Placement == null ? PopupManager.class$("org.netbeans.editor.PopupManager$Placement") : class$org$netbeans$editor$PopupManager$Placement);
            if (updatedPlacement == placement) break;
            if (placement == AbovePreferred && updatedPlacement == null) {
                placement = Below;
                continue;
            }
            if (placement != BelowPreferred || updatedPlacement != null) break;
            placement = Above;
        }
        if (updatedPlacement == null) {
            popupBounds = null;
        }
        if (popupBounds != null) {
            popupBounds.x = Math.min(cursorBounds.x, viewWidth - popupBounds.width);
            popupBounds.y = placement == Above || placement == AbovePreferred ? aboveCursorHeight - popupBounds.height : belowCursorY;
        }
        return popupBounds;
    }

    protected static Rectangle computeBounds(JComponent popup, int viewWidth, int viewHeight, Rectangle cursorBounds, Placement placement) {
        return PopupManager.computeBounds(popup, viewWidth, viewHeight, cursorBounds, placement, ViewPortBounds);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class HorizontalBounds {
        private final String representation;

        private HorizontalBounds(String representation) {
            this.representation = representation;
        }

        public String toString() {
            return this.representation;
        }
    }

    public static final class Placement {
        private final String representation;

        private Placement(String representation) {
            this.representation = representation;
        }

        public String toString() {
            return this.representation;
        }
    }

    private final class TextComponentListener
    extends ComponentAdapter {
        private TextComponentListener() {
        }

        public void componentHidden(ComponentEvent evt) {
            PopupManager.this.install(null);
        }
    }

    private class PopupKeyListener
    implements KeyListener {
        private PopupKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e == null) {
                return;
            }
            if (PopupManager.this.popup != null && PopupManager.this.popup.isShowing()) {
                Action action;
                ActionMap am = PopupManager.this.popup.getActionMap();
                InputMap im = PopupManager.this.popup.getInputMap();
                Object obj = im.get(KeyStroke.getKeyStrokeForEvent(e));
                if (obj != null && (action = am.get(obj)) != null) {
                    action.actionPerformed(null);
                    e.consume();
                }
            }
        }
    }
}

