/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.LineRootElement;
import org.netbeans.editor.MultiMark;
import org.netbeans.editor.Syntax;

final class LineElement
implements Element {
    private LineRootElement root;
    private MultiMark mark;
    private LineElement next;
    private AttributeSet attributes;
    private Syntax.StateInfo syntaxStateInfo;

    LineElement(LineRootElement root, int offset, LineElement next) {
        this.root = root;
        try {
            this.mark = ((BaseDocument)root.getDocument()).createBiasMark(offset, Position.Bias.Backward);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e.toString());
        }
        this.next = next;
    }

    public Document getDocument() {
        return this.root.getDocument();
    }

    public int getStartOffset() {
        return this.mark.getOffset();
    }

    public int getEndOffset() {
        return this.next != null ? this.next.getStartOffset() : this.getDocument().getLength() + 1;
    }

    public Element getParentElement() {
        return this.root;
    }

    public String getName() {
        return "paragraph";
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public int getElementIndex(int offset) {
        return -1;
    }

    public int getElementCount() {
        return 0;
    }

    public Element getElement(int index) {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    LineElement getNext() {
        return this.next;
    }

    void setNext(LineElement next) {
        this.next = next;
    }

    protected void finalize() throws Throwable {
        this.mark.dispose();
        super.finalize();
    }

    Syntax.StateInfo getSyntaxStateInfo() {
        return this.syntaxStateInfo;
    }

    void updateSyntaxStateInfo(Syntax syntax) {
        if (this.syntaxStateInfo == null) {
            this.syntaxStateInfo = syntax.createStateInfo();
        }
        syntax.storeState(this.syntaxStateInfo);
    }

    void clearSyntaxStateInfo() {
        this.syntaxStateInfo = null;
    }

    public String toString() {
        return "getStartOffset()=" + this.getStartOffset() + ", getEndOffset()=" + this.getEndOffset();
    }
}

