/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.PrintContainer;

interface DrawGraphics {
    public void setForeColor(Color var1);

    public void setBackColor(Color var1);

    public void setDefaultBackColor(Color var1);

    public void setStrikeThroughColor(Color var1);

    public void setUnderlineColor(Color var1);

    public void setWaveUnderlineColor(Color var1);

    public void setFont(Font var1);

    public void setX(int var1);

    public void setY(int var1);

    public void setLineHeight(int var1);

    public void setLineAscent(int var1);

    public Graphics getGraphics();

    public boolean supportsLineNumbers();

    public void init(DrawContext var1);

    public void finish();

    public void fillRect(int var1);

    public void drawChars(int var1, int var2, int var3);

    public void drawTabs(int var1, int var2, int var3, int var4);

    public void setBuffer(char[] var1);

    public boolean targetOffsetReached(int var1, char var2, int var3, int var4, DrawContext var5);

    public void eol();

    public void setView(View var1);

    public static final class PrintDG
    extends SimpleDG {
        PrintContainer container;
        boolean lineInited;

        public PrintDG(PrintContainer container) {
            this.container = container;
        }

        public boolean supportsLineNumbers() {
            return true;
        }

        public void drawChars(int offset, int length, int width) {
            if (length > 0) {
                char[] chars = new char[length];
                System.arraycopy(this.buffer, offset, chars, 0, length);
                this.container.add(chars, this.font, this.foreColor, this.backColor);
            }
        }

        private void printSpaces(int spaceCount) {
            char[] chars = new char[spaceCount];
            System.arraycopy(Analyzer.getSpacesBuffer(spaceCount), 0, chars, 0, spaceCount);
            this.container.add(chars, this.font, this.foreColor, this.backColor);
        }

        public void drawTabs(int offset, int length, int spaceCount, int width) {
            this.printSpaces(spaceCount);
        }

        public void eol() {
            if (!this.lineInited && this.container.initEmptyLines()) {
                this.printSpaces(1);
            }
            this.container.eol();
            this.lineInited = false;
        }
    }

    public static final class GraphicsDG
    extends SimpleDG {
        private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.draw.graphics");
        private Graphics graphics;
        private int startOffset = -1;
        private int endOffset;
        private int startX;
        private int startY;
        private int width;
        private Color strikeThroughColor;
        private Color underlineColor;
        private Color waveUnderlineColor;
        private int lastDrawnAnnosY;
        private int lastDrawnAnnosX;
        private AnnotationDesc[] passiveAnnosAtY;
        private AlphaComposite alpha = null;
        private Annotations annos = null;
        private boolean drawTextLimitLine;
        private int textLimitWidth;
        private int defaultSpaceWidth;
        private Color textLimitLineColor;
        private int absoluteX;
        private int maxWidth;
        private View view;

        GraphicsDG(Graphics graphics) {
            this.graphics = graphics;
            this.y = -1;
        }

        public void setForeColor(Color foreColor) {
            if (!foreColor.equals(this.foreColor)) {
                this.flush();
                this.foreColor = foreColor;
            }
        }

        public void setBackColor(Color backColor) {
            if (!backColor.equals(this.backColor)) {
                this.flush();
                this.backColor = backColor;
            }
        }

        public void setStrikeThroughColor(Color strikeThroughColor) {
            if (!(strikeThroughColor == this.strikeThroughColor || strikeThroughColor != null && strikeThroughColor.equals(this.strikeThroughColor))) {
                this.flush();
                this.strikeThroughColor = strikeThroughColor;
            }
        }

        public void setUnderlineColor(Color underlineColor) {
            if (!(underlineColor == this.underlineColor || underlineColor != null && underlineColor.equals(this.underlineColor))) {
                this.flush();
                this.underlineColor = underlineColor;
            }
        }

        public void setWaveUnderlineColor(Color waveUnderlineColor) {
            if (!(waveUnderlineColor == this.waveUnderlineColor || waveUnderlineColor != null && waveUnderlineColor.equals(this.waveUnderlineColor))) {
                this.flush();
                this.waveUnderlineColor = waveUnderlineColor;
            }
        }

        public void setFont(Font font) {
            if (!font.equals(this.font)) {
                this.flush();
                this.font = font;
            }
        }

        public void setX(int x) {
            if (x != this.x) {
                this.flush();
                this.x = x;
            }
        }

        public void setY(int y) {
            if (y != this.y) {
                this.flush();
                this.y = y;
            }
        }

        public void init(DrawContext ctx) {
            JTextComponent c = ctx.getEditorUI().getComponent();
            this.annos = ctx.getEditorUI().getDocument().getAnnotations();
            this.drawTextLimitLine = ctx.getEditorUI().textLimitLineVisible;
            this.textLimitWidth = ctx.getEditorUI().textLimitWidth;
            this.defaultSpaceWidth = ctx.getEditorUI().defaultSpaceWidth;
            this.textLimitLineColor = ctx.getEditorUI().textLimitLineColor;
            this.absoluteX = ctx.getEditorUI().getTextMargin().left;
            this.maxWidth = ctx.getEditorUI().getExtentBounds().width;
        }

        public void finish() {
            this.flush();
        }

        public void setView(View view) {
            this.view = view;
        }

        private void flush() {
            this.flush(false);
        }

        private void flush(boolean atEOL) {
            FontMetricsCache.Info fmcInfo;
            if (this.y < 0) {
                return;
            }
            if (this.startOffset >= 0 && this.startOffset != this.endOffset) {
                this.fillRectImpl(this.startX, this.startY, this.x - this.startX);
            }
            if (this.lastDrawnAnnosY != this.y) {
                this.lastDrawnAnnosY = this.y;
                this.lastDrawnAnnosX = 0;
                if (AnnotationTypes.getTypes().isBackgroundDrawing().booleanValue()) {
                    if (this.alpha == null) {
                        this.alpha = AlphaComposite.getInstance(3, (float)AnnotationTypes.getTypes().getBackgroundGlyphAlpha().intValue() / 100.0f);
                    }
                    if (this.view != null) {
                        this.passiveAnnosAtY = this.annos.getPassiveAnnotations(this.view.getStartOffset());
                    }
                } else {
                    this.passiveAnnosAtY = null;
                }
            }
            int glyphX = 2;
            if (this.passiveAnnosAtY != null) {
                Graphics2D g2d = (Graphics2D)this.graphics;
                Shape shape = this.graphics.getClip();
                Composite origin = g2d.getComposite();
                g2d.setComposite(this.alpha);
                int endX = atEOL ? Integer.MAX_VALUE : this.x;
                int startX = Math.min(this.lastDrawnAnnosX, this.startX);
                Rectangle r = new Rectangle(startX, this.y, endX - startX, this.lineHeight);
                this.lastDrawnAnnosX = endX;
                r = r.intersection(shape.getBounds());
                this.graphics.setClip(r);
                for (int i = 0; i < this.passiveAnnosAtY.length; ++i) {
                    g2d.drawImage(this.passiveAnnosAtY[i].getGlyph(), glyphX, this.y, null);
                    glyphX += this.passiveAnnosAtY[i].getGlyph().getWidth(null) + 1;
                }
                this.graphics.setClip(shape);
                g2d.setComposite(origin);
            }
            if (this.startOffset < 0 || this.startOffset == this.endOffset) {
                this.startOffset = -1;
                return;
            }
            if (this.drawTextLimitLine) {
                Rectangle clip = this.graphics.getClipBounds();
                int lineX = this.absoluteX + this.textLimitWidth * this.defaultSpaceWidth;
                if (lineX >= this.startX && lineX <= this.x) {
                    Color bakColor = this.graphics.getColor();
                    this.graphics.setColor(this.textLimitLineColor);
                    this.graphics.drawLine(lineX, this.startY, lineX, this.startY + this.lineHeight);
                    this.graphics.setColor(bakColor);
                }
            }
            this.graphics.setColor(this.foreColor);
            this.graphics.setFont(this.font);
            if (debug) {
                String text = new String(this.buffer, this.startOffset, this.endOffset - this.startOffset);
                System.out.println("DrawGraphics: text='" + text + "', text.length=" + text.length() + ", x=" + this.startX + ", y=" + this.startY + ", ascent=" + this.lineAscent + ", clip=" + this.graphics.getClipBounds() + ", color=" + this.graphics.getColor());
            }
            this.graphics.drawChars(this.buffer, this.startOffset, this.endOffset - this.startOffset, this.startX, this.startY + this.lineAscent);
            if (this.strikeThroughColor != null) {
                fmcInfo = FontMetricsCache.getInfo(this.font);
                this.graphics.setColor(this.strikeThroughColor);
                this.graphics.fillRect(this.startX, this.startY + (int)((double)(fmcInfo.getStrikethroughOffset(this.graphics) + (float)this.lineAscent) + 0.5), this.x - this.startX, (int)((double)fmcInfo.getStrikethroughThickness(this.graphics) + 0.5));
            }
            if (this.waveUnderlineColor != null) {
                fmcInfo = FontMetricsCache.getInfo(this.font);
                this.graphics.setColor(this.waveUnderlineColor);
                int[] wf = new int[]{0, 1, 0, -1};
                int y0 = (int)((double)((float)this.startY + fmcInfo.getUnderlineOffset(this.graphics) + (float)this.lineAscent + 1.0f) + 0.5);
                for (int x0 = this.startX; x0 <= this.x; ++x0) {
                    this.graphics.drawLine(x0, y0 + wf[x0 % 4], x0 + 1, y0 + wf[(x0 + 1) % 4]);
                }
            }
            if (this.underlineColor != null) {
                fmcInfo = FontMetricsCache.getInfo(this.font);
                this.graphics.setColor(this.underlineColor);
                this.graphics.fillRect(this.startX, this.startY + (int)((double)(fmcInfo.getUnderlineOffset(this.graphics) + (float)this.lineAscent) + 1.5), this.x - this.startX, (int)((double)fmcInfo.getUnderlineThickness(this.graphics) + 0.5));
            }
            this.startOffset = -1;
        }

        public Graphics getGraphics() {
            return this.graphics;
        }

        public boolean supportsLineNumbers() {
            return true;
        }

        public void fillRect(int width) {
            this.fillRectImpl(this.x, this.y, width);
            this.x += width;
        }

        private void fillRectImpl(int rx, int ry, int width) {
            if (width > 0 && !this.backColor.equals(this.defaultBackColor)) {
                this.graphics.setColor(this.backColor);
                this.graphics.fillRect(rx, ry, width, this.lineHeight);
            }
        }

        public void drawChars(int offset, int length, int width) {
            if (length >= 0) {
                if (this.startOffset < 0) {
                    this.startOffset = offset;
                    this.endOffset = offset + length;
                    this.startX = this.x;
                    this.startY = this.y;
                    this.width = width;
                } else {
                    this.endOffset += length;
                }
            }
            this.x += width;
        }

        public void drawTabs(int offset, int length, int spaceCount, int width) {
            if (width > 0) {
                this.flush();
                this.fillRectImpl(this.x, this.y, width);
                this.x += width;
            }
        }

        public void setBuffer(char[] buffer) {
            this.flush();
            this.buffer = buffer;
            this.startOffset = -1;
        }

        public void eol() {
            int lineX;
            if (this.drawTextLimitLine && (lineX = this.absoluteX + this.textLimitWidth * this.defaultSpaceWidth) >= this.x - this.defaultSpaceWidth) {
                Color bakColor = this.graphics.getColor();
                this.graphics.setColor(this.textLimitLineColor);
                Rectangle clipB = this.graphics.getClipBounds();
                if (clipB.width + clipB.x <= lineX) {
                    this.graphics.setClip(clipB.x, clipB.y, this.maxWidth, clipB.height);
                    this.graphics.drawLine(lineX, this.y, lineX, this.y + this.lineHeight);
                    this.graphics.setClip(clipB.x, clipB.y, clipB.width, clipB.height);
                } else {
                    this.graphics.drawLine(lineX, this.y, lineX, this.y + this.lineHeight);
                }
                this.graphics.setColor(bakColor);
            }
            this.flush(true);
        }
    }

    public static class SimpleDG
    extends AbstractDG {
        public Graphics getGraphics() {
            return null;
        }

        public boolean supportsLineNumbers() {
            return false;
        }

        public void init(DrawContext ctx) {
        }

        public void finish() {
        }

        public void fillRect(int width) {
        }

        public boolean targetOffsetReached(int offset, char ch, int x, int charWidth, DrawContext ctx) {
            return true;
        }

        public void eol() {
        }
    }

    public static abstract class AbstractDG
    implements DrawGraphics {
        Color foreColor;
        Color backColor;
        Color defaultBackColor;
        Font font;
        char[] buffer;
        int x;
        int y;
        int lineHeight;
        int lineAscent;

        public Color getForeColor() {
            return this.foreColor;
        }

        public void setForeColor(Color foreColor) {
            this.foreColor = foreColor;
        }

        public Color getBackColor() {
            return this.backColor;
        }

        public void setBackColor(Color backColor) {
            this.backColor = backColor;
        }

        public Color getDefaultBackColor() {
            return this.defaultBackColor;
        }

        public void setDefaultBackColor(Color defaultBackColor) {
            this.defaultBackColor = defaultBackColor;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getLineHeight() {
            return this.lineHeight;
        }

        public void setLineHeight(int lineHeight) {
            this.lineHeight = lineHeight;
        }

        public int getLineAscent() {
            return this.lineAscent;
        }

        public void setLineAscent(int lineAscent) {
            this.lineAscent = lineAscent;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public void setBuffer(char[] buffer) {
            this.buffer = buffer;
        }

        public void drawChars(int offset, int length, int width) {
            this.x += width;
        }

        public void drawTabs(int offset, int length, int spaceCount, int width) {
            this.x += width;
        }

        public void setStrikeThroughColor(Color strikeThroughColor) {
        }

        public void setUnderlineColor(Color underlineColor) {
        }

        public void setWaveUnderlineColor(Color waveUnderlineColor) {
        }

        public void setView(View view) {
        }
    }
}

