/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FoldMultiLineView;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldHierarchy;
import org.netbeans.editor.fold.api.FoldHierarchyEvent;
import org.netbeans.editor.fold.api.FoldHierarchyIterator;
import org.netbeans.editor.fold.api.FoldHierarchyListener;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.lib.editor.view.GapDocumentView;

class DrawEngineDocView
extends GapDocumentView
implements FoldHierarchyListener,
PropertyChangeListener {
    private FoldHierarchy foldHierarchy;
    private EditorUI editorUI;
    private FoldHierarchyIterator collapsedFoldIterator;
    private Fold collapsedFold;
    private int collapsedFoldStartOffset;
    private int collapsedFoldEndOffset;
    private int docLength;
    private boolean collapsedFoldsInPresentViews;
    private boolean estimatedSpanResetInitiated;

    private static Element getParagraphRootElement(JTextComponent component) {
        return ((BaseDocument)component.getDocument()).getParagraphElement(0).getParentElement();
    }

    DrawEngineDocView(Element elem) {
        super(elem);
        this.setEstimatedSpan(true);
    }

    public void setParent(View parent) {
        if (parent != null) {
            JTextComponent component = (JTextComponent)parent.getContainer();
            this.foldHierarchy = FoldHierarchy.get(component);
            this.foldHierarchy.addFoldHierarchyListener(this);
            TextUI tui = component.getUI();
            if (tui instanceof BaseTextUI) {
                this.editorUI = ((BaseTextUI)tui).getEditorUI();
                if (this.editorUI != null) {
                    this.editorUI.addPropertyChangeListener(this);
                }
            }
        }
        super.setParent(parent);
        if (parent == null) {
            this.foldHierarchy.removeFoldHierarchyListener(this);
            this.foldHierarchy = null;
            if (this.editorUI != null) {
                this.editorUI.removePropertyChangeListener(this);
                this.editorUI = null;
            }
        }
    }

    protected void attachListeners() {
        if (this.foldHierarchy != null) {
            // empty if block
        }
    }

    private FoldHierarchy getFoldHierarchy() {
        return this.foldHierarchy;
    }

    protected boolean useCustomReloadChildren() {
        return true;
    }

    protected Fold nextCollapsedFold() {
        Fold fold;
        Fold fold2 = fold = this.collapsedFoldIterator.hasNext() ? (Fold)this.collapsedFoldIterator.next() : null;
        if (fold != null) {
            this.collapsedFoldStartOffset = fold.getStartOffset();
            this.collapsedFoldEndOffset = fold.getStartOffset();
            if (this.collapsedFoldEndOffset > this.docLength) {
                fold = null;
            }
        }
        if (fold != null) {
            this.collapsedFoldsInPresentViews = true;
        }
        return fold;
    }

    protected void initCustomReloadChildren(FoldHierarchy hierarchy, int startOffset, int endOffset) {
        this.collapsedFoldIterator = hierarchy.collapsedFoldIterator(startOffset, endOffset);
        this.collapsedFold = this.nextCollapsedFold();
    }

    protected void finishCustomReloadChildren(FoldHierarchy hierarchy) {
        this.collapsedFoldIterator = null;
        this.collapsedFold = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void customReloadChildren(int index, int removeLength, int startOffset, int endOffset) {
        FoldHierarchy hierarchy;
        if (index == 0 && removeLength == this.getViewCount()) {
            this.collapsedFoldsInPresentViews = false;
        }
        if ((hierarchy = this.getFoldHierarchy()) != null) {
            hierarchy.lock();
            try {
                this.docLength = this.getDocument().getLength();
                this.initCustomReloadChildren(hierarchy, startOffset, endOffset);
                super.customReloadChildren(index, removeLength, startOffset, endOffset);
                this.finishCustomReloadChildren(hierarchy);
            }
            finally {
                hierarchy.unlock();
            }
        }
    }

    protected View createCustomView(ViewFactory f, int startOffset, int maxEndOffset, int elementIndex) {
        boolean createCollapsed;
        if (elementIndex == -1) {
            throw new IllegalStateException("Need underlying line element structure");
        }
        View view = null;
        Element elem = this.getElement();
        Element lineElem = elem.getElement(elementIndex);
        boolean bl = createCollapsed = this.collapsedFold != null;
        if (createCollapsed) {
            int lineElemEndOffset = lineElem.getEndOffset();
            boolean bl2 = createCollapsed = this.collapsedFoldStartOffset < lineElemEndOffset;
            if (createCollapsed) {
                Element firstLineElem = lineElem;
                ArrayList<Object> foldAndEndLineElemList = new ArrayList<Object>();
                do {
                    int collapsedFoldEndOffset = this.collapsedFold.getEndOffset();
                    while (collapsedFoldEndOffset > lineElemEndOffset) {
                        lineElem = elem.getElement(++elementIndex);
                        lineElemEndOffset = lineElem.getEndOffset();
                    }
                    foldAndEndLineElemList.add(this.collapsedFold);
                    foldAndEndLineElemList.add(lineElem);
                    this.collapsedFold = this.nextCollapsedFold();
                } while (this.collapsedFold != null && this.collapsedFoldStartOffset < lineElemEndOffset);
                view = new FoldMultiLineView(firstLineElem, foldAndEndLineElemList);
            }
        }
        if (!createCollapsed) {
            view = f.create(lineElem);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        LockView lockView = LockView.get(this);
        lockView.lock();
        try {
            this.layoutLock();
            try {
                FoldHierarchyIterator it;
                FoldHierarchy hierarchy = (FoldHierarchy)evt.getSource();
                if (hierarchy.getComponent().getDocument() != lockView.getDocument()) {
                    return;
                }
                boolean rebuildViews = true;
                int affectedStartOffset = evt.getAffectedStartOffset();
                int affectedEndOffset = evt.getAffectedEndOffset();
                if (!this.collapsedFoldsInPresentViews && !(it = hierarchy.collapsedFoldIterator(affectedStartOffset, affectedEndOffset)).hasNext()) {
                    rebuildViews = false;
                }
                if (rebuildViews) {
                    int docLength = this.getDocument().getLength();
                    int rebuildStartOffset = Math.min(affectedStartOffset, docLength);
                    int rebuildEndOffset = Math.min(affectedEndOffset, docLength);
                    this.offsetRebuild(rebuildStartOffset, rebuildEndOffset);
                }
            }
            finally {
                this.updateLayout();
                this.layoutUnlock();
            }
        }
        finally {
            lockView.unlock();
        }
    }

    public void paint(Graphics g, Shape allocation) {
        TextUI textUI;
        super.paint(g, allocation);
        if (this.getContainer() instanceof JTextComponent && (textUI = ((JTextComponent)this.getContainer()).getUI()) instanceof BaseTextUI) {
            ((BaseTextUI)textUI).getEditorUI().paint(g);
        }
    }

    protected void customInsertUpdate(DocumentEvent evt, Shape a, ViewFactory f) {
        if (((BaseDocumentEvent)evt).getLFCount() > 0) {
            super.customInsertUpdate(evt, a, f);
        } else {
            this.forwardUpdate(null, evt, a, f);
        }
    }

    protected void customRemoveUpdate(DocumentEvent evt, Shape a, ViewFactory f) {
        if (((BaseDocumentEvent)evt).getLFCount() > 0) {
            super.customRemoveUpdate(evt, a, f);
        } else {
            this.forwardUpdate(null, evt, a, f);
        }
    }

    public void setSize(float width, float height) {
        super.setSize(width, height);
        if (!this.estimatedSpanResetInitiated && this.isEstimatedSpan()) {
            this.estimatedSpanResetInitiated = true;
            Timer timer = new Timer(4000, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent evt) {
                    block7: {
                        AbstractDocument doc = (AbstractDocument)DrawEngineDocView.this.getDocument();
                        if (doc != null) {
                            doc.readLock();
                            try {
                                LockView lockView = LockView.get(DrawEngineDocView.this);
                                if (lockView == null) break block7;
                                lockView.lock();
                                try {
                                    DrawEngineDocView.this.setEstimatedSpan(false);
                                }
                                finally {
                                    lockView.unlock();
                                }
                            }
                            finally {
                                doc.readUnlock();
                            }
                        }
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    protected boolean isChildrenResizeDisabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent component = (JTextComponent)this.getContainer();
        if (component == null || evt == null || !"line-height-changed-prop".equals(evt.getPropertyName())) {
            return;
        }
        AbstractDocument doc = (AbstractDocument)this.getDocument();
        if (doc != null) {
            doc.readLock();
            try {
                LockView lockView = LockView.get(this);
                lockView.lock();
                try {
                    this.rebuild(0, this.getViewCount());
                }
                finally {
                    lockView.unlock();
                }
            }
            finally {
                doc.readUnlock();
            }
            component.revalidate();
        }
    }
}

