/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class DialogSupport {
    private static DialogFactory factory;

    private DialogSupport() {
    }

    public static Dialog createDialog(String title, JPanel panel, boolean modal, JButton[] buttons, boolean sidebuttons, int defaultIndex, int cancelIndex, ActionListener listener) {
        if (factory == null) {
            factory = new DefaultDialogFactory();
        }
        return factory.createDialog(title, panel, modal, buttons, sidebuttons, defaultIndex, cancelIndex, listener);
    }

    public static void setDialogFactory(DialogFactory factory) {
        DialogSupport.factory = factory;
    }

    private static class DefaultDialogFactory
    extends WindowAdapter
    implements DialogFactory,
    ActionListener {
        private JButton cancelButton;

        private DefaultDialogFactory() {
        }

        JPanel createButtonPanel(JButton[] buttons, boolean sidebuttons) {
            int count = buttons.length;
            JPanel outerPanel = new JPanel(new BorderLayout());
            outerPanel.setBorder(new EmptyBorder(new Insets(sidebuttons ? 5 : 0, sidebuttons ? 0 : 5, 5, 5)));
            GridLayout lm = new GridLayout(sidebuttons ? count : 1, sidebuttons ? 1 : count, 5, 5);
            JPanel innerPanel = new JPanel(lm);
            for (int i = 0; i < count; ++i) {
                innerPanel.add(buttons[i]);
            }
            outerPanel.add((Component)innerPanel, sidebuttons ? "North" : "East");
            return outerPanel;
        }

        public Dialog createDialog(String title, JPanel panel, boolean modal, JButton[] buttons, boolean sidebuttons, int defaultIndex, int cancelIndex, ActionListener listener) {
            JDialog d = new JDialog((Frame)null, title, modal);
            d.setDefaultCloseOperation(0);
            d.getContentPane().add((Component)panel, "Center");
            JPanel buttonPanel = this.createButtonPanel(buttons, sidebuttons);
            String buttonAlign = sidebuttons ? "East" : "South";
            d.getContentPane().add((Component)buttonPanel, buttonAlign);
            if (listener != null) {
                for (int i = 0; i < buttons.length; ++i) {
                    buttons[i].addActionListener(listener);
                }
            }
            if (defaultIndex >= 0) {
                d.getRootPane().setDefaultButton(buttons[defaultIndex]);
            }
            if (cancelIndex >= 0) {
                this.cancelButton = buttons[cancelIndex];
                d.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0, true), 2);
                d.addWindowListener(this);
            }
            d.pack();
            return d;
        }

        public void actionPerformed(ActionEvent evt) {
            this.cancelButton.doClick(10);
        }

        public void windowClosing(WindowEvent evt) {
            this.cancelButton.doClick(10);
        }
    }

    public static interface DialogFactory {
        public Dialog createDialog(String var1, JPanel var2, boolean var3, JButton[] var4, boolean var5, int var6, int var7, ActionListener var8);
    }
}

