/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;

public class Abbrev
implements SettingsChangeListener,
PropertyChangeListener {
    private StringBuffer abbrevSB = new StringBuffer();
    private boolean checkDocText;
    private boolean checkTextDelimiter;
    protected EditorUI editorUI;
    private Acceptor doExpandAcceptor;
    private Acceptor addTypedAcceptor;
    private Acceptor resetAcceptor;
    private HashMap abbrevMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Abbrev(EditorUI editorUI, boolean checkDocText, boolean checkTextDelimiter) {
        this.editorUI = editorUI;
        this.checkDocText = checkDocText;
        this.checkTextDelimiter = checkTextDelimiter;
        Settings.addSettingsChangeListener(this);
        Object object = editorUI.getComponentLock();
        synchronized (object) {
            JTextComponent component = editorUI.getComponent();
            if (component != null) {
                this.propertyChange(new PropertyChangeEvent(editorUI, "component", null, component));
            }
            editorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Class kitClass = Utilities.getKitClass(this.editorUI.getComponent());
        if (kitClass != null) {
            String settingName;
            String string = settingName = evt != null ? evt.getSettingName() : null;
            if (settingName == null || "abbrev-action-map".equals(settingName) || "abbrev-map".equals(settingName)) {
                this.abbrevMap = new HashMap();
                Map m = (Map)Settings.getValue(kitClass, "abbrev-action-map");
                if (m != null) {
                    BaseKit kit = Utilities.getKit(this.editorUI.getComponent());
                    Iterator iter = m.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry me = iter.next();
                        Object value = me.getValue();
                        Action a = null;
                        if (value instanceof String) {
                            a = kit.getActionByName((String)value);
                        } else if (value instanceof Action) {
                            a = (Action)value;
                        }
                        if (a == null) continue;
                        this.abbrevMap.put(me.getKey(), a);
                    }
                }
                if ((m = (Map)Settings.getValue(kitClass, "abbrev-map")) != null) {
                    Iterator iter = m.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry me = iter.next();
                        Object value = me.getValue();
                        if (value == null) continue;
                        this.abbrevMap.put(me.getKey(), value);
                    }
                }
            }
            if (settingName == null || "abbrev-expand-acceptor".equals(settingName)) {
                this.doExpandAcceptor = SettingsUtil.getAcceptor(kitClass, "abbrev-expand-acceptor", AcceptorFactory.FALSE);
            }
            if (settingName == null || "abbrev-add-typed-char-acceptor".equals(settingName)) {
                this.addTypedAcceptor = SettingsUtil.getAcceptor(kitClass, "abbrev-add-typed-char-acceptor", AcceptorFactory.FALSE);
            }
            if (settingName == null || "abbrev-reset-acceptor".equals(settingName)) {
                this.resetAcceptor = SettingsUtil.getAcceptor(kitClass, "abbrev-reset-acceptor", AcceptorFactory.TRUE);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent component;
        String propName = evt.getPropertyName();
        if ("component".equals(propName) && (component = (JTextComponent)evt.getNewValue()) != null) {
            this.settingsChange(null);
        }
    }

    public void reset() {
        this.abbrevSB.setLength(0);
    }

    public void addChar(char ch) {
        this.abbrevSB.append(ch);
    }

    public String getAbbrevString() {
        return this.abbrevSB.toString();
    }

    public Map getAbbrevMap() {
        return this.abbrevMap;
    }

    public Object translateAbbrev(String abbrev) {
        String abbStr = abbrev != null ? abbrev : this.abbrevSB.toString();
        return this.getAbbrevMap().get(abbStr);
    }

    public String getExpandString(char typedChar) {
        return this.doExpandAcceptor.accept(typedChar) ? this.getExpandString() : null;
    }

    public String getExpandString() {
        BaseDocument doc = this.editorUI.getDocument();
        String abbrevStr = this.getAbbrevString();
        int abbrevStrLen = abbrevStr.length();
        Object expansion = this.translateAbbrev(abbrevStr);
        Caret caret = this.editorUI.getComponent().getCaret();
        int dotPos = caret.getDot();
        if (abbrevStr != null && expansion != null && dotPos >= abbrevStrLen && this.checkDocText) {
            try {
                String prevChars = doc.getText(dotPos - abbrevStrLen, abbrevStrLen);
                if (prevChars.equals(abbrevStr) && (!this.checkTextDelimiter || dotPos == abbrevStrLen || this.resetAcceptor.accept(doc.getChars(dotPos - abbrevStrLen - 1, 1)[0]))) {
                    return abbrevStr;
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean doExpansion(int dotPos, String expandStr, ActionEvent evt) throws BadLocationException {
        Object expansion = this.translateAbbrev(expandStr);
        boolean expanded = false;
        if (expansion instanceof String) {
            BaseDocument doc = this.editorUI.getDocument();
            String ins = (String)expansion;
            int offset = ins.indexOf(124);
            if (offset >= 0) {
                if (offset > 0) {
                    doc.insertString(dotPos, ins.substring(0, offset), null);
                }
                if (offset + 1 < ins.length()) {
                    doc.insertString(dotPos + offset, ins.substring(offset + 1), null);
                }
                Caret caret = this.editorUI.getComponent().getCaret();
                caret.setDot(dotPos + offset);
            } else {
                doc.insertString(dotPos, ins, null);
            }
            if (ins.indexOf("\n") != -1) {
                Formatter formatter = doc.getFormatter();
                formatter.reformat(doc, dotPos, dotPos + ins.length());
            }
            expanded = true;
        } else if (expansion instanceof Action) {
            ((Action)expansion).actionPerformed(evt);
            expanded = true;
        }
        return expanded;
    }

    public boolean expandString(char typedChar, String expandStr, ActionEvent evt) throws BadLocationException {
        if (this.expandString(expandStr, evt)) {
            if (this.addTypedAcceptor.accept(typedChar)) {
                int dotPos = this.editorUI.getComponent().getCaret().getDot();
                this.editorUI.getDocument().insertString(dotPos, String.valueOf(typedChar), null);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expandString(String expandStr, ActionEvent evt) throws BadLocationException {
        boolean expanded = false;
        BaseDocument doc = this.editorUI.getDocument();
        doc.atomicLock();
        try {
            Caret caret = this.editorUI.getComponent().getCaret();
            int pos = caret.getDot() - expandStr.length();
            doc.remove(pos, expandStr.length());
            expanded = this.doExpansion(pos, expandStr, evt);
            Object var8_7 = null;
            if (expanded) {
                this.reset();
            } else {
                doc.breakAtomicLock();
            }
            doc.atomicUnlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (expanded) {
                this.reset();
            } else {
                doc.breakAtomicLock();
            }
            doc.atomicUnlock();
            throw throwable;
        }
        return expanded;
    }

    public boolean checkReset(char typedChar) {
        if (this.resetAcceptor.accept(typedChar)) {
            this.reset();
            return true;
        }
        return false;
    }

    public boolean checkAndExpand(char typedChar, ActionEvent evt) throws BadLocationException {
        boolean doInsert = true;
        String expandStr = this.getExpandString(typedChar);
        if (expandStr != null) {
            doInsert = false;
            this.expandString(typedChar, expandStr, evt);
        } else {
            this.addChar(typedChar);
        }
        this.checkReset(typedChar);
        return doInsert;
    }

    public void checkAndExpand(ActionEvent evt) throws BadLocationException {
        String expandStr = this.getExpandString();
        if (expandStr != null) {
            this.expandString(expandStr, evt);
        }
    }
}

