/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Insets;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XNETProtocol
extends XProtocol
implements XStateProtocol,
XLayerProtocol {
    static final Logger log = Logger.getLogger("sun.awt.X11.XNETProtocol");
    private static final Logger iconLog = Logger.getLogger("sun.awt.X11.icon.XNETProtocol");
    XAtom XA_UTF8_STRING = XAtom.get("UTF8_STRING");
    XAtom XA_NET_SUPPORTING_WM_CHECK = XAtom.get("_NET_SUPPORTING_WM_CHECK");
    XAtom XA_NET_SUPPORTED = XAtom.get("_NET_SUPPORTED");
    XAtom XA_NET_WM_NAME = XAtom.get("_NET_WM_NAME");
    XAtom XA_NET_WM_STATE = XAtom.get("_NET_WM_STATE");
    XAtom XA_NET_WM_STATE_MAXIMIZED_HORZ = XAtom.get("_NET_WM_STATE_MAXIMIZED_HORZ");
    XAtom XA_NET_WM_STATE_MAXIMIZED_VERT = XAtom.get("_NET_WM_STATE_MAXIMIZED_VERT");
    XAtom XA_NET_WM_STATE_SHADED = XAtom.get("_NET_WM_STATE_SHADED");
    XAtom XA_NET_WM_STATE_ABOVE = XAtom.get("_NET_WM_STATE_ABOVE");
    XAtom XA_NET_WM_STATE_MODAL = XAtom.get("_NET_WM_STATE_MODAL");
    XAtom XA_NET_WM_STATE_FULLSCREEN = XAtom.get("_NET_WM_STATE_FULLSCREEN");
    XAtom XA_NET_WM_STATE_BELOW = XAtom.get("_NET_WM_STATE_BELOW");
    XAtom XA_NET_WM_STATE_SKIP_TASKBAR = XAtom.get("_NET_WM_STATE_SKIP_TASKBAR");
    XAtom XA_NET_WM_WINDOW_TYPE = XAtom.get("_NET_WM_WINDOW_TYPE");
    XAtom XA_NET_WM_WINDOW_TYPE_DIALOG = XAtom.get("_NET_WM_WINDOW_TYPE_DIALOG");
    XAtom XA_NET_WM_WINDOW_OPACITY = XAtom.get("_NET_WM_WINDOW_OPACITY");
    static final int _NET_WM_STATE_REMOVE = 0;
    static final int _NET_WM_STATE_ADD = 1;
    static final int _NET_WM_STATE_TOGGLE = 2;
    boolean supportChecked = false;
    long NetWindow = 0L;
    String net_wm_name_cache;

    XNETProtocol() {
    }

    @Override
    public boolean supportsState(int n) {
        return this.doStateProtocol();
    }

    @Override
    public void setState(XWindowPeer xWindowPeer, int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting state of " + xWindowPeer + " to " + n);
        }
        if (xWindowPeer.isShowing()) {
            this.requestState(xWindowPeer, n);
        } else {
            this.setInitialState(xWindowPeer, n);
        }
    }

    private void setInitialState(XWindowPeer xWindowPeer, int n) {
        XAtomList xAtomList = xWindowPeer.getNETWMState();
        log.log(Level.FINE, "Current state of the window {0} is {1}", new Object[]{xWindowPeer, xAtomList});
        if ((n & 4) != 0) {
            xAtomList.add(this.XA_NET_WM_STATE_MAXIMIZED_VERT);
        } else {
            xAtomList.remove(this.XA_NET_WM_STATE_MAXIMIZED_VERT);
        }
        if ((n & 2) != 0) {
            xAtomList.add(this.XA_NET_WM_STATE_MAXIMIZED_HORZ);
        } else {
            xAtomList.remove(this.XA_NET_WM_STATE_MAXIMIZED_HORZ);
        }
        log.log(Level.FINE, "Setting initial state of the window {0} to {1}", new Object[]{xWindowPeer, xAtomList});
        xWindowPeer.setNETWMState(xAtomList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void requestState(XWindowPeer xWindowPeer, int n) {
        XClientMessageEvent xClientMessageEvent;
        block12: {
            block11: {
                int n2 = this.getState(xWindowPeer);
                int n3 = (n ^ n2) & 6;
                xClientMessageEvent = new XClientMessageEvent();
                try {
                    switch (n3) {
                        case 0: {
                            Object var9_6 = null;
                            xClientMessageEvent.dispose();
                            return;
                        }
                        case 2: {
                            xClientMessageEvent.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_HORZ.getAtom());
                            xClientMessageEvent.set_data(2, 0L);
                            break;
                        }
                        case 4: {
                            xClientMessageEvent.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_VERT.getAtom());
                            xClientMessageEvent.set_data(2, 0L);
                            break;
                        }
                        case 6: {
                            xClientMessageEvent.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_HORZ.getAtom());
                            xClientMessageEvent.set_data(2, this.XA_NET_WM_STATE_MAXIMIZED_VERT.getAtom());
                            break;
                        }
                        default: {
                            break block11;
                        }
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Requesting state on " + xWindowPeer + " for " + n);
                    }
                    xClientMessageEvent.set_type(33);
                    xClientMessageEvent.set_window(xWindowPeer.getWindow());
                    xClientMessageEvent.set_message_type(this.XA_NET_WM_STATE.getAtom());
                    xClientMessageEvent.set_format(32);
                    xClientMessageEvent.set_data(0, 2L);
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xWindowPeer.getScreenNumber()), false, 0x180000L, xClientMessageEvent.pData);
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    xClientMessageEvent.dispose();
                    throw throwable;
                }
            }
            Object var9_7 = null;
            xClientMessageEvent.dispose();
            return;
        }
        Object var9_8 = null;
        xClientMessageEvent.dispose();
    }

    @Override
    public int getState(XWindowPeer xWindowPeer) {
        return this.getStateImpl(xWindowPeer);
    }

    int getStateImpl(XWindowPeer xWindowPeer) {
        XAtomList xAtomList = xWindowPeer.getNETWMState();
        if (xAtomList.size() == 0) {
            return 0;
        }
        int n = 0;
        if (xAtomList.contains(this.XA_NET_WM_STATE_MAXIMIZED_VERT)) {
            n |= 4;
        }
        if (xAtomList.contains(this.XA_NET_WM_STATE_MAXIMIZED_HORZ)) {
            n |= 2;
        }
        return n;
    }

    @Override
    public boolean isStateChange(XPropertyEvent xPropertyEvent) {
        boolean bl;
        boolean bl2 = bl = this.doStateProtocol() && xPropertyEvent.get_atom() == this.XA_NET_WM_STATE.getAtom();
        if (bl) {
            XWindowPeer xWindowPeer = (XWindowPeer)XToolkit.windowToXWindow(xPropertyEvent.get_window());
            xWindowPeer.setNETWMState(null);
        }
        return bl;
    }

    @Override
    public void unshadeKludge(XWindowPeer xWindowPeer) {
        XAtomList xAtomList = xWindowPeer.getNETWMState();
        xAtomList.remove(this.XA_NET_WM_STATE_SHADED);
        xWindowPeer.setNETWMState(xAtomList);
    }

    @Override
    public boolean supportsLayer(int n) {
        return (n == 1 || n == 0) && this.doLayerProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestState(XWindow xWindow, XAtom xAtom, boolean bl) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(xWindow.getWindow());
            xClientMessageEvent.set_message_type(this.XA_NET_WM_STATE.getAtom());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_data(0, bl ? 1L : 0L);
            xClientMessageEvent.set_data(1, xAtom.getAtom());
            log.log(Level.FINE, "Setting _NET_STATE atom {0} on {1} for {2}", new Object[]{xAtom, xWindow, bl});
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xWindow.getScreenNumber()), false, 0x180000L, xClientMessageEvent.pData);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            Object var8_8 = null;
            xClientMessageEvent.dispose();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            xClientMessageEvent.dispose();
            throw throwable;
        }
    }

    private void setStateHelper(XWindowPeer xWindowPeer, XAtom xAtom, boolean bl) {
        log.log(Level.FINER, "Window visibility is: withdrawn={0}, visible={1}, mapped={2} showing={3}", new Object[]{xWindowPeer.isWithdrawn(), xWindowPeer.isVisible(), xWindowPeer.isMapped(), xWindowPeer.isShowing()});
        if (xWindowPeer.isShowing()) {
            this.requestState(xWindowPeer, xAtom, bl);
        } else {
            XAtomList xAtomList = xWindowPeer.getNETWMState();
            log.log(Level.FINE, "Current state on {0} is {1}", new Object[]{xWindowPeer, xAtomList});
            if (!bl) {
                xAtomList.remove(xAtom);
            } else {
                xAtomList.add(xAtom);
            }
            log.log(Level.FINE, "Setting states on {0} to {1}", new Object[]{xWindowPeer, xAtomList});
            xWindowPeer.setNETWMState(xAtomList);
        }
        XToolkit.XSync();
    }

    @Override
    public void setLayer(XWindowPeer xWindowPeer, int n) {
        this.setStateHelper(xWindowPeer, this.XA_NET_WM_STATE_ABOVE, n == 1);
    }

    void detect() {
        if (this.supportChecked) {
            return;
        }
        this.NetWindow = this.checkAnchor(this.XA_NET_SUPPORTING_WM_CHECK, 33L);
        this.supportChecked = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " is active: " + (this.NetWindow != 0L));
        }
    }

    boolean active() {
        this.detect();
        return this.NetWindow != 0L;
    }

    boolean doStateProtocol() {
        boolean bl = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE);
        return bl;
    }

    boolean doLayerProtocol() {
        boolean bl = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE_ABOVE);
        return bl;
    }

    boolean doModalityProtocol() {
        boolean bl = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE_MODAL);
        return bl;
    }

    boolean doOpacityProtocol() {
        boolean bl = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_WINDOW_OPACITY);
        return bl;
    }

    boolean isWMName(String string) {
        if (!this.active()) {
            return false;
        }
        String string2 = this.getWMName();
        if (string2 == null) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("### WM_NAME = " + string2);
        }
        return string2.startsWith(string);
    }

    public String getWMName() {
        if (!this.active()) {
            return null;
        }
        if (this.net_wm_name_cache != null) {
            return this.net_wm_name_cache;
        }
        String string = "UTF8";
        byte[] byArray = this.XA_NET_WM_NAME.getByteArrayProperty(this.NetWindow, this.XA_UTF8_STRING.getAtom());
        if (byArray == null) {
            byArray = this.XA_NET_WM_NAME.getByteArrayProperty(this.NetWindow, 31L);
            string = "ASCII";
        }
        if (byArray == null) {
            return null;
        }
        try {
            this.net_wm_name_cache = new String(byArray, string);
            return this.net_wm_name_cache;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public Insets getWMExtents(XWindowPeer xWindowPeer, XAtom xAtom) {
        if (xWindowPeer == null || xWindowPeer.getWindow() == 0L) {
            return null;
        }
        Insets insets = null;
        if (xAtom != null) {
            insets = this.calcWMExtents(xWindowPeer, xAtom);
        } else {
            insets = this.calcWMExtents(xWindowPeer, XAtom.get("_NET_WM_FRAME_EXTENTS"));
            if (insets == null) {
                XWM.getWM();
                if (XWM.getWMID() == 8) {
                    insets = this.calcWMExtents(xWindowPeer, XAtom.get("_KDE_NET_WM_FRAME_STRUT"));
                }
            }
        }
        log.log(Level.FINE, "WM EXTENTS: {0}", new Object[]{insets});
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Insets calcWMExtents(XWindowPeer xWindowPeer, XAtom xAtom) {
        WindowPropertyGetter windowPropertyGetter;
        block3: {
            windowPropertyGetter = new WindowPropertyGetter(xWindowPeer.getWindow(), xAtom, 0L, 4L, false, 6L);
            try {
                if (windowPropertyGetter.execute() == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualFormat() == 32) break block3;
                Insets insets = null;
                Object var6_6 = null;
                windowPropertyGetter.dispose();
                return insets;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                windowPropertyGetter.dispose();
                throw throwable;
            }
        }
        Insets insets = new Insets((int)Native.getCard32(windowPropertyGetter.getData(), 2), (int)Native.getCard32(windowPropertyGetter.getData(), 0), (int)Native.getCard32(windowPropertyGetter.getData(), 3), (int)Native.getCard32(windowPropertyGetter.getData(), 1));
        Object var6_7 = null;
        windowPropertyGetter.dispose();
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWMExtents(XWindowPeer xWindowPeer) {
        if (xWindowPeer == null || xWindowPeer.getWindow() == 0L) {
            return;
        }
        log.fine("Requesting NET_WM_EXTENTS");
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.zero();
        xClientMessageEvent.set_type(33);
        xClientMessageEvent.set_display(XToolkit.getDisplay());
        xClientMessageEvent.set_window(xWindowPeer.getWindow());
        xClientMessageEvent.set_format(32);
        XToolkit.awtLock();
        try {
            xClientMessageEvent.set_message_type(XAtom.get("_KDE_NET_WM_FRAME_STRUT").getAtom());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, xClientMessageEvent.getPData());
            xClientMessageEvent.set_message_type(XAtom.get("_NET_REQUEST_FRAME_EXTENTS").getAtom());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, xClientMessageEvent.getPData());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        xClientMessageEvent.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWMIcons(XWindowPeer xWindowPeer, List<XIconInfo> list) {
        if (xWindowPeer == null) {
            return;
        }
        XAtom xAtom = XAtom.get("_NET_WM_ICON");
        if (list == null) {
            xAtom.DeleteProperty(xWindowPeer);
            return;
        }
        int n = 0;
        for (XIconInfo xIconInfo : list) {
            n += xIconInfo.getRawLength();
        }
        int n2 = XlibWrapper.dataModel == 32 ? 4 : 8;
        int n3 = n * n2;
        if (n3 != 0) {
            long l = XlibWrapper.unsafe.allocateMemory(n3);
            try {
                long l2 = l;
                for (XIconInfo xIconInfo : list) {
                    int n4 = xIconInfo.getRawLength() * n2;
                    if (XlibWrapper.dataModel == 32) {
                        XlibWrapper.copyIntArray(l2, xIconInfo.getIntData(), n4);
                    } else {
                        XlibWrapper.copyLongArray(l2, xIconInfo.getLongData(), n4);
                    }
                    l2 += (long)n4;
                }
                xAtom.setAtomData(xWindowPeer.getWindow(), 6L, l, n3 / Native.getCard32Size());
                Object var15_14 = null;
                XlibWrapper.unsafe.freeMemory(l);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                XlibWrapper.unsafe.freeMemory(l);
                throw throwable;
            }
        } else {
            xAtom.DeleteProperty(xWindowPeer);
        }
    }
}

