/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class StringSelection
implements Transferable,
ClipboardOwner {
    private static final int STRING = 0;
    private static final int PLAIN_TEXT = 1;
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
    private String data;

    public StringSelection(String string) {
        this.data = string;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!dataFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavors[0])) {
            return this.data;
        }
        if (dataFlavor.equals(flavors[1])) {
            return new StringReader(this.data == null ? "" : this.data);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

