/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal;

import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class CachedXPathAPI {
    protected XPathContext xpathSupport;

    public CachedXPathAPI() {
        this.xpathSupport = new XPathContext();
    }

    public CachedXPathAPI(CachedXPathAPI cachedXPathAPI) {
        this.xpathSupport = cachedXPathAPI.xpathSupport;
    }

    public XPathContext getXPathContext() {
        return this.xpathSupport;
    }

    public Node selectSingleNode(Node node, String string) throws TransformerException {
        return this.selectSingleNode(node, string, node);
    }

    public Node selectSingleNode(Node node, String string, Node node2) throws TransformerException {
        NodeIterator nodeIterator = this.selectNodeIterator(node, string, node2);
        return nodeIterator.nextNode();
    }

    public NodeIterator selectNodeIterator(Node node, String string) throws TransformerException {
        return this.selectNodeIterator(node, string, node);
    }

    public NodeIterator selectNodeIterator(Node node, String string, Node node2) throws TransformerException {
        XObject xObject = this.eval(node, string, node2);
        return xObject.nodeset();
    }

    public NodeList selectNodeList(Node node, String string) throws TransformerException {
        return this.selectNodeList(node, string, node);
    }

    public NodeList selectNodeList(Node node, String string, Node node2) throws TransformerException {
        XObject xObject = this.eval(node, string, node2);
        return xObject.nodelist();
    }

    public XObject eval(Node node, String string) throws TransformerException {
        return this.eval(node, string, node);
    }

    public XObject eval(Node node, String string, Node node2) throws TransformerException {
        PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node2.getNodeType() == 9 ? ((Document)node2).getDocumentElement() : node2);
        XPath xPath = new XPath(string, null, prefixResolverDefault, 0, null);
        int n = this.xpathSupport.getDTMHandleFromNode(node);
        return xPath.execute(this.xpathSupport, n, (PrefixResolver)prefixResolverDefault);
    }

    public XObject eval(Node node, String string, PrefixResolver prefixResolver) throws TransformerException {
        XPath xPath = new XPath(string, null, prefixResolver, 0, null);
        XPathContext xPathContext = new XPathContext();
        int n = xPathContext.getDTMHandleFromNode(node);
        return xPath.execute(xPathContext, n, prefixResolver);
    }
}

