/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.util.misc;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.statement.ModifiedObjectAttr;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.misc.StringFunctions;

public class CustomizeUtil {
    public static String objectNamesToQuotedIdentifier(String objectName, String[] keywords, ModifiedObjectAttr modifiedAttr, int targetdb) {
        String[] specChars = new String[]{"%", "+", "-", "!", "*", "~", ":", ";", "{", "}", ",", "^", "<", ">", "'", "|", "/", "\\"};
        if (SwisSQLAPI.enableObjectMapping && objectName != null) {
            CustomizeUtil.checkAndResetObjectNameFromMapping(objectName);
        }
        if (!(objectName == null || objectName.startsWith("\"") && objectName.endsWith("\"") || objectName.startsWith("'") && objectName.endsWith("'") || objectName.startsWith(":"))) {
            int i;
            for (i = 0; i < specChars.length; ++i) {
                if ((objectName.indexOf(specChars[i]) != -1 || CustomizeUtil.isStartsWithNum(objectName)) && objectName.startsWith("[")) {
                    objectName = "\"" + objectName.trim().substring(1, objectName.length() - 1) + "\"";
                    if (modifiedAttr == null) break;
                    modifiedAttr.setModifiedType(2);
                    break;
                }
                if (objectName.indexOf(specChars[i]) == -1 && !CustomizeUtil.isStartsWithNum(objectName)) continue;
                objectName = "\"" + objectName + "\"";
                if (modifiedAttr == null) break;
                modifiedAttr.setModifiedType(2);
                break;
            }
            if (!objectName.startsWith("\"") && keywords != null) {
                for (i = 0; i < keywords.length; ++i) {
                    if (objectName.startsWith("[") || objectName.startsWith("`")) {
                        if (!keywords[i].trim().equalsIgnoreCase(objectName.trim().substring(1, objectName.length() - 1))) continue;
                        if (!SwisSQLOptions.doNotModifyVariableName) {
                            objectName = targetdb == 1 ? (SwisSQLAPI.quotedOracleIdentifier ? "\"" + objectName.trim().substring(1, objectName.length() - 1) + "\"" : objectName.trim().substring(1, objectName.length() - 1) + "_") : "\"" + objectName.trim().substring(1, objectName.length() - 1) + "\"";
                        }
                        if (modifiedAttr == null) break;
                        modifiedAttr.setModifiedType(3);
                        break;
                    }
                    if (!keywords[i].trim().equalsIgnoreCase(objectName.trim()) || SwisSQLOptions.doNotModifyVariableName) continue;
                    objectName = targetdb == 1 ? (SwisSQLAPI.quotedOracleIdentifier ? "\"" + objectName + "\"" : objectName + "_") : "\"" + objectName + "\"";
                    if (modifiedAttr == null) break;
                    modifiedAttr.setModifiedType(3);
                    break;
                }
            }
        }
        if (objectName != null && objectName.startsWith("\"") && objectName.endsWith("\"") && targetdb == 11) {
            boolean isKeyword = false;
            for (int i = 0; i < keywords.length; ++i) {
                if (!keywords[i].trim().equalsIgnoreCase(objectName.trim().substring(1, objectName.length() - 1))) continue;
                isKeyword = true;
                break;
            }
            if (SwisSQLOptions.setObjectNamesToLowerCase) {
                if ((StringFunctions.isUpperCase(objectName.substring(1, objectName.length() - 1)) || StringFunctions.isLowerCase(objectName.substring(1, objectName.length() - 1))) && !isKeyword && objectName.substring(1, objectName.length() - 1).trim().length() > 0) {
                    objectName = objectName.substring(1, objectName.length() - 1).toLowerCase();
                }
            } else if (SwisSQLOptions.setObjectNamesToUpperCase && (StringFunctions.isUpperCase(objectName.substring(1, objectName.length() - 1)) || StringFunctions.isLowerCase(objectName.substring(1, objectName.length() - 1))) && !isKeyword && objectName.substring(1, objectName.length() - 1).trim().length() > 0) {
                objectName = objectName.substring(1, objectName.length() - 1).toUpperCase();
            }
        }
        return objectName;
    }

    public static String objectNamesToBracedIdentifier(String objectName, String[] keywords, ModifiedObjectAttr modifiedAttr) {
        String[] specChars = new String[]{"%", "+", "-", "!", "*", "~", ":", ";", "{", "}", ",", "^", "<", ">", "'", "|"};
        if (SwisSQLAPI.enableObjectMapping && objectName != null) {
            CustomizeUtil.checkAndResetObjectNameFromMapping(objectName);
        }
        if (!(objectName == null || objectName.startsWith("[") && objectName.endsWith("]") || objectName.startsWith("'") && objectName.endsWith("'") || objectName.startsWith(":"))) {
            int i;
            for (i = 0; i < specChars.length; ++i) {
                if ((objectName.indexOf(specChars[i]) != -1 || CustomizeUtil.isStartsWithNum(objectName)) && objectName.startsWith("\"")) {
                    objectName = "[" + objectName.trim().substring(1, objectName.length() - 1) + "]";
                    if (modifiedAttr == null) break;
                    modifiedAttr.setModifiedType(2);
                    break;
                }
                if (objectName.indexOf(specChars[i]) == -1 && !CustomizeUtil.isStartsWithNum(objectName)) continue;
                objectName = "[" + objectName + "]";
                if (modifiedAttr == null) break;
                modifiedAttr.setModifiedType(2);
                break;
            }
            if (!objectName.startsWith("[") && keywords != null) {
                for (i = 0; i < keywords.length; ++i) {
                    if (objectName.startsWith("\"") || objectName.startsWith("`")) {
                        if (!keywords[i].trim().equalsIgnoreCase(objectName.trim().substring(1, objectName.length() - 1))) continue;
                        objectName = "[" + objectName.trim().substring(1, objectName.length() - 1) + "]";
                        if (modifiedAttr == null) break;
                        modifiedAttr.setModifiedType(3);
                        break;
                    }
                    if (!keywords[i].trim().equalsIgnoreCase(objectName.trim())) continue;
                    objectName = "[" + objectName + "]";
                    if (modifiedAttr == null || modifiedAttr == null) break;
                    modifiedAttr.setModifiedType(3);
                    break;
                }
            }
        }
        return objectName;
    }

    public static boolean isStartsWithNum(String objectName) {
        for (int i = 0; i < 10; ++i) {
            if (objectName.startsWith("[") || objectName.startsWith("\"")) {
                objectName = objectName.substring(1, objectName.length() - 1);
            }
            if (!objectName.startsWith(new String(i + ""))) continue;
            return true;
        }
        return false;
    }

    private static void checkAndResetObjectNameFromMapping(String objectName) {
        String objectNameToCheckMapping = "";
        objectNameToCheckMapping = objectName.startsWith("[") && objectName.endsWith("]") || objectName.startsWith("'") && objectName.endsWith("'") || objectName.startsWith("\"") && objectName.endsWith("\"") || objectName.startsWith("`") && objectName.endsWith("`") ? objectName.trim().substring(1, objectName.length() - 1) : (objectName.startsWith(":") ? objectName.trim().substring(1, objectName.length()) : objectName.trim());
        String targetObjName = SwisSQLUtils.getObjectNameFromMapping(objectNameToCheckMapping);
        if (targetObjName != null) {
            objectName = objectName.replaceAll(objectNameToCheckMapping, targetObjName);
        }
    }

    public static boolean compareQuotedIdentifiers(String identifier, String comparedIdentifier, boolean ignoreCase) {
        if (identifier != null && (identifier.startsWith("`") || identifier.startsWith("\"") || identifier.startsWith("["))) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        if (comparedIdentifier != null && (comparedIdentifier.startsWith("`") || comparedIdentifier.startsWith("\"") || comparedIdentifier.startsWith("["))) {
            comparedIdentifier = comparedIdentifier.substring(1, comparedIdentifier.length() - 1);
        }
        if (ignoreCase) {
            return identifier.equalsIgnoreCase(comparedIdentifier);
        }
        return identifier.equals(comparedIdentifier);
    }
}

