/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.update;

import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.select.FromClause;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.util.misc.StringFunctions;
import java.util.ArrayList;
import java.util.Vector;

public class SetExpression {
    private ArrayList columnList = new ArrayList();
    private String equalto;
    private ArrayList expressionList = new ArrayList();
    private SelectQueryStatement subQuery;
    private UserObjectContext context = null;
    private int setExpressionId;

    public SetExpression() {
        this.equalto = new String();
    }

    public void setColumnList(ArrayList list) {
        this.columnList = list;
    }

    public ArrayList getColumnList() {
        return this.columnList;
    }

    public void setEqualTo(String s) {
        this.equalto = s;
    }

    public String getEqualTo() {
        return this.equalto;
    }

    public void setObjectContext(UserObjectContext obj) {
        this.context = obj;
    }

    public void setSubQuery(SelectQueryStatement s) {
        this.subQuery = s;
    }

    public SelectQueryStatement getSubQuery() {
        return this.subQuery;
    }

    public void setExpressionList(ArrayList list) {
        this.expressionList = list;
    }

    public ArrayList getExpressionList() {
        return this.expressionList;
    }

    public void setSetExpressionId(int exprId) {
        this.setExpressionId = exprId;
    }

    public int getSetExpressionId() {
        return this.setExpressionId;
    }

    public void toMySQL() throws ConvertException {
        Object obj;
        int i;
        int size;
        if (this.expressionList == null && this.subQuery != null) {
            this.subQuery = this.subQuery.toMySQLSelect();
        } else {
            size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toMySQLSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toMySQLSelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toMySQLSelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toOracle() throws ConvertException {
        TableColumn tc;
        Object obj;
        int i;
        int size;
        if (this.expressionList == null && this.subQuery != null) {
            this.subQuery = this.subQuery.toOracleSelect();
        } else {
            size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toOracleSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (obj instanceof TableColumn) {
                    tc = (TableColumn)obj;
                    tc = tc.toOracleSelect(null, null);
                    this.expressionList.set(i, tc);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toOracleSelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                tc = (TableColumn)obj;
                tc = tc.toOracleSelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toMSSQLServer() throws ConvertException {
        Object obj;
        int i;
        if (this.expressionList == null && this.subQuery != null) {
            boolean subqueryHasAggregateFunction = false;
            SelectStatement subSelectStatement = this.subQuery.getSelectStatement();
            Vector subSelectCol = subSelectStatement.getSelectItemList();
            if (subSelectCol != null) {
                for (int i2 = 0; i2 < subSelectCol.size(); ++i2) {
                    if (!(subSelectCol.get(i2) instanceof SelectColumn) || !((SelectColumn)subSelectCol.get(i2)).isAggregateFunction() && !this.selectColumnHasAggrFunction(((SelectColumn)subSelectCol.get(i2)).getColumnExpression(), false)) continue;
                    subqueryHasAggregateFunction = true;
                }
            }
            if (!subqueryHasAggregateFunction) {
                this.newConversionForRamco();
                return;
            }
            this.subQuery = this.subQuery.toMSSQLServerSelect();
            ArrayList<String> newExpressionList = new ArrayList<String>();
            SelectStatement selectStatement = this.subQuery.getSelectStatement();
            Vector selectList = selectStatement.getSelectItemList();
            if (selectList != null) {
                ArrayList arrayList = new ArrayList();
                for (int i3 = 0; i3 < selectList.size(); ++i3) {
                    SelectColumn newSelectColumn = new SelectColumn();
                    if (selectList.get(i3) instanceof SelectColumn) {
                        SelectColumn oldSelectColumn = (SelectColumn)selectList.get(i3);
                        Vector colExp = oldSelectColumn.getColumnExpression();
                        Vector<String> newColExp = new Vector<String>();
                        if (colExp != null) {
                            for (int j = 0; j < colExp.size(); ++j) {
                                newColExp.add(colExp.get(j).toString());
                            }
                        }
                        newSelectColumn.setColumnExpression(newColExp);
                    }
                    Vector<SelectColumn> selectItem = new Vector<SelectColumn>();
                    selectItem.add(newSelectColumn);
                    SelectQueryStatement eachColumnStmt = new SelectQueryStatement();
                    SelectStatement newSelectStatement = new SelectStatement();
                    newSelectStatement.setDistinctList(selectStatement.getDistinctList());
                    newSelectStatement.setSelectClause(selectStatement.getSelectClause());
                    newSelectStatement.setSelectQualifier(selectStatement.getSelectQualifier());
                    newSelectStatement.setSelectRowCount(selectStatement.getSelectRowCount());
                    newSelectStatement.setSelectRowSpecifier(selectStatement.getSelectRowSpecifier());
                    newSelectStatement.setSelectSpecialQualifier(selectStatement.getSelectSpecialQualifier());
                    newSelectStatement.setSelectItemList(selectItem);
                    eachColumnStmt.setSelectStatement(newSelectStatement);
                    eachColumnStmt.setFromClause(this.subQuery.getFromClause());
                    eachColumnStmt.setWhereExpression(this.subQuery.getWhereExpression());
                    eachColumnStmt.setGroupByStatement(this.subQuery.getGroupByStatement());
                    eachColumnStmt.setForUpdateStatement(this.subQuery.getForUpdateStatement());
                    eachColumnStmt.setIntoStatement(this.subQuery.getIntoStatement());
                    eachColumnStmt.setSetOperatorClause(this.subQuery.getSetOperatorClause());
                    eachColumnStmt.setHavingStatement(this.subQuery.getHavingStatement());
                    if (selectList.size() > 1) {
                        newExpressionList.add("");
                    }
                    String queryString = eachColumnStmt.toMSSQLServerString();
                    queryString = StringFunctions.replaceAll("\n\t\t\t\t", "\n", queryString);
                    newExpressionList.add("\n\t\t\t\t(\n\t\t\t\t" + queryString + ")" + "\n\t");
                }
            }
            this.setSubQuery(null);
            this.setExpressionList(newExpressionList);
        } else {
            int size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toMSSQLServerSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toMSSQLServerSelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            int size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toMSSQLServerSelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toSybase() throws ConvertException {
        Object obj;
        int i;
        if (this.expressionList == null && this.subQuery != null) {
            boolean subqueryHasAggregateFunction = false;
            SelectStatement subSelectStatement = this.subQuery.getSelectStatement();
            Vector subSelectCol = subSelectStatement.getSelectItemList();
            if (subSelectCol != null) {
                for (int i2 = 0; i2 < subSelectCol.size(); ++i2) {
                    if (!(subSelectCol.get(i2) instanceof SelectColumn) || !((SelectColumn)subSelectCol.get(i2)).isAggregateFunction()) continue;
                    subqueryHasAggregateFunction = true;
                }
            }
            if (!subqueryHasAggregateFunction) {
                this.newConversionForRamco();
                return;
            }
            this.subQuery = this.subQuery.toSybaseSelect();
            ArrayList<String> newExpressionList = new ArrayList<String>();
            SelectStatement selectStatement = this.subQuery.getSelectStatement();
            Vector selectList = selectStatement.getSelectItemList();
            if (selectList != null) {
                ArrayList arrayList = new ArrayList();
                for (int i3 = 0; i3 < selectList.size(); ++i3) {
                    SelectColumn newSelectColumn = new SelectColumn();
                    if (selectList.get(i3) instanceof SelectColumn) {
                        SelectColumn oldSelectColumn = (SelectColumn)selectList.get(i3);
                        Vector colExp = oldSelectColumn.getColumnExpression();
                        Vector<String> newColExp = new Vector<String>();
                        if (colExp != null) {
                            for (int j = 0; j < colExp.size(); ++j) {
                                newColExp.add(colExp.get(j).toString());
                            }
                        }
                        newSelectColumn.setColumnExpression(newColExp);
                    }
                    Vector<SelectColumn> selectItem = new Vector<SelectColumn>();
                    selectItem.add(newSelectColumn);
                    SelectQueryStatement eachColumnStmt = new SelectQueryStatement();
                    SelectStatement newSelectStatement = new SelectStatement();
                    newSelectStatement.setDistinctList(selectStatement.getDistinctList());
                    newSelectStatement.setSelectClause(selectStatement.getSelectClause());
                    newSelectStatement.setSelectQualifier(selectStatement.getSelectQualifier());
                    newSelectStatement.setSelectRowCount(selectStatement.getSelectRowCount());
                    newSelectStatement.setSelectRowSpecifier(selectStatement.getSelectRowSpecifier());
                    newSelectStatement.setSelectSpecialQualifier(selectStatement.getSelectSpecialQualifier());
                    newSelectStatement.setSelectItemList(selectItem);
                    eachColumnStmt.setSelectStatement(newSelectStatement);
                    eachColumnStmt.setFromClause(this.subQuery.getFromClause());
                    eachColumnStmt.setWhereExpression(this.subQuery.getWhereExpression());
                    eachColumnStmt.setGroupByStatement(this.subQuery.getGroupByStatement());
                    eachColumnStmt.setForUpdateStatement(this.subQuery.getForUpdateStatement());
                    eachColumnStmt.setIntoStatement(this.subQuery.getIntoStatement());
                    eachColumnStmt.setSetOperatorClause(this.subQuery.getSetOperatorClause());
                    eachColumnStmt.setHavingStatement(this.subQuery.getHavingStatement());
                    if (selectList.size() > 1) {
                        newExpressionList.add("");
                    }
                    String queryString = eachColumnStmt.toSybaseString();
                    queryString = StringFunctions.replaceAll("\n\t\t\t\t", "\n", queryString);
                    newExpressionList.add("\n\t\t\t\t(\n\t\t\t\t" + queryString + ")" + "\n\t");
                }
            }
            this.setSubQuery(null);
            this.setExpressionList(newExpressionList);
        } else {
            int size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs.setObjectContext(this.context);
                    sqs = sqs.toSybaseSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc.setObjectContext(this.context);
                sc = sc.toSybaseSelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            int size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toSybaseSelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toPostgreSQL() throws ConvertException {
        Object obj;
        int i;
        int size;
        if (this.expressionList == null && this.subQuery != null) {
            this.subQuery = this.subQuery.toPostgreSQLSelect();
        } else {
            size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toPostgreSQLSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toPostgreSQLSelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toPostgreSQLSelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toDB2() throws ConvertException {
        Object obj;
        int i;
        int size;
        if (this.expressionList == null && this.subQuery != null) {
            this.subQuery = this.subQuery.toDB2Select();
        } else {
            size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toDB2Select();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc.setSelectColFromUQSSetExpression(true);
                sc = sc.toDB2Select(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toDB2Select(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toInformix() throws ConvertException {
        Object obj;
        int i;
        int size;
        if (this.expressionList == null && this.subQuery != null) {
            this.subQuery = this.subQuery.toInformixSelect();
        } else {
            size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toInformixSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toInformixSelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toInformixSelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toANSISQL() throws ConvertException {
        Object obj;
        int i;
        int size;
        if (this.expressionList == null && this.subQuery != null) {
            this.subQuery = this.subQuery.toANSISelect();
        } else {
            size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toANSISelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toANSISelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toANSISelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toTeradata() throws ConvertException {
        Object obj;
        int i;
        int size;
        if (this.expressionList == null && this.subQuery != null) {
            this.subQuery = this.subQuery.toTeradataSelect();
        } else {
            size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toTeradataSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toTeradataSelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toTeradataSelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public void toTimesTen() throws ConvertException {
        if (this.expressionList == null && this.subQuery != null) {
            this.subQuery = this.subQuery.toTimesTenSelect();
        } else {
            TableColumn tc;
            Object obj;
            int i;
            int size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toTimesTenSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (obj instanceof TableColumn) {
                    tc = (TableColumn)obj;
                    tc = tc.toTimesTenSelect(null, null);
                    this.expressionList.set(i, tc);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toTimesTenSelect(null, null);
                this.expressionList.set(i, sc);
            }
            if (this.columnList != null) {
                size = this.columnList.size();
                for (i = 0; i < size; ++i) {
                    obj = this.columnList.get(i);
                    if (!(obj instanceof TableColumn)) continue;
                    tc = (TableColumn)obj;
                    tc = tc.toTimesTenSelect(null, null);
                    this.columnList.set(i, tc);
                }
            }
        }
    }

    public void toNetezzaSQL() throws ConvertException {
        Object obj;
        int i;
        if (this.expressionList == null && this.subQuery != null) {
            boolean subqueryHasAggregateFunction = false;
            SelectStatement subSelectStatement = this.subQuery.getSelectStatement();
            Vector subSelectCol = subSelectStatement.getSelectItemList();
            if (subSelectCol != null) {
                for (int i2 = 0; i2 < subSelectCol.size(); ++i2) {
                    if (!(subSelectCol.get(i2) instanceof SelectColumn) || !((SelectColumn)subSelectCol.get(i2)).isAggregateFunction() && !this.selectColumnHasAggrFunction(((SelectColumn)subSelectCol.get(i2)).getColumnExpression(), false)) continue;
                    subqueryHasAggregateFunction = true;
                }
            }
            if (!subqueryHasAggregateFunction) {
                this.newConversionForRamco();
                return;
            }
            this.subQuery = this.subQuery.toNetezzaSelect();
            ArrayList<String> newExpressionList = new ArrayList<String>();
            SelectStatement selectStatement = this.subQuery.getSelectStatement();
            Vector selectList = selectStatement.getSelectItemList();
            if (selectList != null) {
                ArrayList arrayList = new ArrayList();
                for (int i3 = 0; i3 < selectList.size(); ++i3) {
                    SelectColumn newSelectColumn = new SelectColumn();
                    if (selectList.get(i3) instanceof SelectColumn) {
                        SelectColumn oldSelectColumn = (SelectColumn)selectList.get(i3);
                        Vector colExp = oldSelectColumn.getColumnExpression();
                        Vector<String> newColExp = new Vector<String>();
                        if (colExp != null) {
                            for (int j = 0; j < colExp.size(); ++j) {
                                newColExp.add(colExp.get(j).toString());
                            }
                        }
                        newSelectColumn.setColumnExpression(newColExp);
                    }
                    Vector<SelectColumn> selectItem = new Vector<SelectColumn>();
                    selectItem.add(newSelectColumn);
                    SelectQueryStatement eachColumnStmt = new SelectQueryStatement();
                    SelectStatement newSelectStatement = new SelectStatement();
                    newSelectStatement.setDistinctList(selectStatement.getDistinctList());
                    newSelectStatement.setSelectClause(selectStatement.getSelectClause());
                    newSelectStatement.setSelectQualifier(selectStatement.getSelectQualifier());
                    newSelectStatement.setSelectRowCount(selectStatement.getSelectRowCount());
                    newSelectStatement.setSelectRowSpecifier(selectStatement.getSelectRowSpecifier());
                    newSelectStatement.setSelectSpecialQualifier(selectStatement.getSelectSpecialQualifier());
                    newSelectStatement.setSelectItemList(selectItem);
                    eachColumnStmt.setSelectStatement(newSelectStatement);
                    eachColumnStmt.setFromClause(this.subQuery.getFromClause());
                    eachColumnStmt.setWhereExpression(this.subQuery.getWhereExpression());
                    eachColumnStmt.setGroupByStatement(this.subQuery.getGroupByStatement());
                    eachColumnStmt.setForUpdateStatement(this.subQuery.getForUpdateStatement());
                    eachColumnStmt.setIntoStatement(this.subQuery.getIntoStatement());
                    eachColumnStmt.setSetOperatorClause(this.subQuery.getSetOperatorClause());
                    eachColumnStmt.setHavingStatement(this.subQuery.getHavingStatement());
                    if (selectList.size() > 1) {
                        newExpressionList.add("");
                    }
                    String queryString = eachColumnStmt.toNetezzaString();
                    queryString = StringFunctions.replaceAll("\n\t\t\t\t", "\n", queryString);
                    newExpressionList.add("\n\t\t\t\t(\n\t\t\t\t" + queryString + ")" + "\n\t");
                }
            }
            this.setSubQuery(null);
            this.setExpressionList(newExpressionList);
        } else {
            int size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                obj = this.expressionList.get(i);
                if (obj instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)obj;
                    sqs = sqs.toNetezzaSelect();
                    this.expressionList.set(i, sqs);
                    continue;
                }
                if (!(obj instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)obj;
                sc = sc.toNetezzaSelect(null, null);
                this.expressionList.set(i, sc);
            }
        }
        if (this.columnList != null) {
            int size = this.columnList.size();
            for (i = 0; i < size; ++i) {
                obj = this.columnList.get(i);
                if (!(obj instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)obj;
                tc = tc.toNetezzaSelect(null, null);
                this.columnList.set(i, tc);
            }
        }
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        int size = this.columnList.size();
        for (i = 0; i < size; ++i) {
            if (this.columnList.get(i) instanceof TableColumn) {
                ((TableColumn)this.columnList.get(i)).setObjectContext(this.context);
            }
            sb.append(this.columnList.get(i).toString());
        }
        sb.append(" " + this.equalto + " ");
        if (this.expressionList == null) {
            for (int j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                sb.append("\t");
            }
            sb.append("(");
            sb.append(this.subQuery.toString());
            sb.append(")");
        } else {
            size = this.expressionList.size();
            for (i = 0; i < size; ++i) {
                sb.append("\n");
                for (int j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                    sb.append("\t");
                }
                sb.append(this.expressionList.get(i).toString());
            }
        }
        return sb.toString();
    }

    public void newConversionForRamco() throws ConvertException {
        int i;
        ArrayList newExpressionList = new ArrayList();
        this.subQuery = this.subQuery.toMSSQLServerSelect();
        SelectStatement selectStatement = this.subQuery.getSelectStatement();
        Vector selectList = selectStatement.getSelectItemList();
        FromClause fromClause = this.subQuery.getFromClause();
        Vector fromList = fromClause.getFromItemList();
        ArrayList commaRemovedColumnList = new ArrayList();
        for (i = 0; i < this.columnList.size(); ++i) {
            if (this.columnList.get(i).toString().trim().equals(",") || this.columnList.get(i).toString().trim().equals("(") || this.columnList.get(i).toString().trim().equals(")")) {
                this.columnList.remove(i);
                --i;
                continue;
            }
            commaRemovedColumnList.add(this.columnList.get(i));
        }
        if (selectList.size() != commaRemovedColumnList.size()) {
            String message = "ColumnList size does not match Select column size";
            throw new ConvertException(message);
        }
        for (i = 0; i < commaRemovedColumnList.size(); ++i) {
            newExpressionList.add(commaRemovedColumnList.get(i));
            newExpressionList.add(" = ");
            FromTable fromTableObject = (FromTable)fromList.get(0);
            String tableName = null;
            tableName = fromTableObject.getAliasName() != null ? fromTableObject.getAliasName() : fromTableObject.getTableName().toString();
            Object selectObj = ((SelectColumn)selectList.get(i)).getColumnExpression().get(0);
            if (selectObj instanceof TableColumn) {
                TableColumn selectTableColumn = (TableColumn)selectObj;
                if (!(selectTableColumn.getTableName() != null || selectTableColumn.getColumnName().equalsIgnoreCase("GETDATE()") || selectTableColumn.getColumnName().equalsIgnoreCase("SYSTEM_USER") || selectTableColumn.getColumnName().equalsIgnoreCase("CURRENT_TIMESTAMP") || selectTableColumn.getColumnName().trim().startsWith("@"))) {
                    selectTableColumn.setTableName(tableName);
                }
                newExpressionList.add(selectList.get(i));
                continue;
            }
            newExpressionList.add(selectList.get(i));
        }
        this.expressionList = newExpressionList;
        this.columnList = null;
    }

    private boolean selectColumnHasAggrFunction(Vector colExp, boolean inputVal) {
        boolean bool = inputVal;
        if (colExp != null) {
            for (int i = 0; i < colExp.size(); ++i) {
                if (colExp.get(i) instanceof SelectColumn) {
                    if (((SelectColumn)colExp.get(i)).isAggregateFunction()) {
                        return true;
                    }
                    Vector selColExp = ((SelectColumn)colExp.get(i)).getColumnExpression();
                    bool = this.selectColumnHasAggrFunction(selColExp, bool);
                    continue;
                }
                if (!(colExp.get(i) instanceof FunctionCalls)) continue;
                Vector FunctionArgs = ((FunctionCalls)colExp.get(i)).getFunctionArguments();
                bool = this.selectColumnHasAggrFunction(FunctionArgs, bool);
            }
        }
        return bool;
    }
}

