/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.functions.misc.decode;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.delete.DeleteQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.CaseStatement;
import com.adventnet.swissqlapi.sql.statement.select.FromClause;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import com.adventnet.swissqlapi.sql.statement.update.TableClause;
import com.adventnet.swissqlapi.sql.statement.update.TableExpression;
import com.adventnet.swissqlapi.sql.statement.update.TableObject;
import com.adventnet.swissqlapi.sql.statement.update.UpdateQueryStatement;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.database.MetadataInfoUtil;
import com.adventnet.swissqlapi.util.misc.CastingUtil;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import com.adventnet.swissqlapi.util.misc.StringFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class WhereColumn {
    private String OpenBrace;
    private Vector columnExpression;
    private String CloseBrace;
    private UserObjectContext context = null;
    private TableColumn corrTableColumn = null;
    private String targetDataType = null;
    private boolean lhs = false;
    private ArrayList fromTableList = null;
    private String tableName = null;
    private String sourceDataType = null;
    private UpdateQueryStatement fromUQS;
    private DeleteQueryStatement fromDQS;
    private CommentClass commentObj;
    private String stmtTableName;

    public void setColumnExpression(Vector v_cn) {
        this.columnExpression = v_cn;
    }

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setOpenBrace(String s_ob) {
        this.OpenBrace = s_ob;
    }

    public void setCloseBrace(String s_cb) {
        this.CloseBrace = s_cb;
    }

    public void setFromUQS(UpdateQueryStatement fromUQS) {
        this.fromUQS = fromUQS;
    }

    public void setFromDQS(DeleteQueryStatement fromDQS) {
        this.fromDQS = fromDQS;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public void setStmtTableName(String stmtTableName) {
        this.stmtTableName = stmtTableName;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public Vector getColumnExpression() {
        return this.columnExpression;
    }

    public String getOpenBrace() {
        return this.OpenBrace;
    }

    public String getCloseBrace() {
        return this.CloseBrace;
    }

    public void setSourceDataType(String sourceDataType) {
        this.sourceDataType = sourceDataType;
    }

    public String getSourceDataType() {
        return this.sourceDataType;
    }

    public void setTargetDataType(String targetDataType) {
        this.targetDataType = targetDataType;
    }

    public String getTargetDataType() {
        return this.targetDataType;
    }

    public void setLHSExpr(boolean lhs) {
        this.lhs = lhs;
    }

    public boolean isLHSExpr() {
        return this.lhs;
    }

    public TableColumn getCorrTableColumn() {
        return this.corrTableColumn;
    }

    public void setFromTableList(ArrayList fromTableList) {
        this.fromTableList = fromTableList;
    }

    public WhereColumn toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)this.columnExpression.elementAt(i_count);
                    tc.setObjectContext(this.context);
                    if (tc.getColumnName() != null) {
                        String column_Name = tc.getColumnName();
                        if (column_Name.trim().length() > 0 && !SwisSQLOptions.TSQLQuotedIdentifier && column_Name.trim().startsWith("\"") && column_Name.trim().endsWith("\"")) {
                            String temp = column_Name.substring(1, column_Name.length() - 1);
                            column_Name = "'" + temp + "'";
                        }
                        tc.setColumnName(column_Name);
                    }
                    v_ce.addElement(tc.toMSSQLServerSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    if (((FunctionCalls)this.columnExpression.elementAt(i_count)).getFunctionName() == null) {
                        v_ce.addElement((FunctionCalls)this.columnExpression.elementAt(i_count));
                        continue;
                    }
                    v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectColumn) {
                    v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toMSSQLServerSelect());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (SwisSQLOptions.removeDBSchemaQualifier && s_ce.indexOf(".") != -1 && s_ce.indexOf(".") != s_ce.lastIndexOf(".")) {
                        s_ce = s_ce.substring(s_ce.indexOf(".") + 1);
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                        v_ce.addElement("CURRENT_TIME");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("SYS_GUID")) {
                        v_ce.addElement("NEWID()");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("SYSDATE")) {
                        v_ce.addElement("GETDATE()");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                        v_ce.addElement("CURRENT_DATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                        v_ce.addElement("CURRENT_TIMESTAMP");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT")) {
                        v_ce.addElement("CURRENT_DATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                        this.createPowerFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("::")) {
                        this.createCastFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.startsWith(":")) {
                        v_ce.addElement("@" + s_ce.substring(1));
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("||")) {
                        v_ce.addElement("+");
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    public WhereColumn toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i_count)).toSybaseSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    ((FunctionCalls)this.columnExpression.elementAt(i_count)).setObjectContext(this.context);
                    v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i_count)).toSybaseSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toSybaseSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectColumn) {
                    ((SelectColumn)this.columnExpression.elementAt(i_count)).setObjectContext(this.context);
                    v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i_count)).toSybaseSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    ((CaseStatement)this.columnExpression.elementAt(i_count)).setObjectContext(this.context);
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toSybaseSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    ((SelectQueryStatement)this.columnExpression.elementAt(i_count)).setObjectContext(this.context);
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toSybaseSelect());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (s_ce.charAt(0) == '\"') {
                        v_ce.addElement(s_ce.replace('\"', '\''));
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                        v_ce.addElement("CURRENT_TIME");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("SYS_GUID")) {
                        v_ce.addElement("NEWID()");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("SYSDATE")) {
                        v_ce.addElement("GETDATE()");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                        v_ce.addElement("CURRENT_DATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                        v_ce.addElement("CURRENT_TIMESTAMP");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT")) {
                        v_ce.addElement("CURRENT_DATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                        this.createPowerFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("::")) {
                        this.createCastFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.startsWith(":")) {
                        v_ce.addElement("@" + s_ce.substring(1));
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("||")) {
                        v_ce.addElement("+");
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        wc.setObjectContext(this.context);
        return wc;
    }

    public void createPowerFunction(Vector v_ce, Vector columnExpression, int i_count) {
        WhereColumn wc_firstarg = new WhereColumn();
        WhereColumn wc_secondarg = new WhereColumn();
        Vector<WhereColumn> v_farg = new Vector<WhereColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        tc.setColumnName("POWER");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(columnExpression.elementAt(i_count - 1));
        v_ce.setElementAt(" ", i_count - 1);
        wc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(wc_firstarg);
        vec_secondarg.addElement(columnExpression.elementAt(i_count + 1));
        columnExpression.setElementAt(" ", i_count + 1);
        wc_secondarg.setColumnExpression(vec_secondarg);
        v_farg.addElement(wc_secondarg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
    }

    public WhereColumn toANSISelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i_count)).toANSISelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i_count)).toANSISelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toANSISelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toANSISelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toANSISelect());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectColumn) {
                    v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i_count)).toANSISelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (s_ce.equalsIgnoreCase("**")) {
                        this.createPowerFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (!s_ce.trim().startsWith("\"")) {
                        if (s_ce.indexOf(".") != -1) {
                            Vector<String> tokenVector = new Vector<String>();
                            StringTokenizer st = new StringTokenizer(s_ce, ".");
                            while (st.hasMoreTokens()) {
                                tokenVector.add(st.nextToken());
                            }
                            if (tokenVector.size() == 2) {
                                String table_Column = "\"" + tokenVector.get(0) + "\"" + "." + "\"" + tokenVector.get(1) + "\"";
                                v_ce.addElement(table_Column);
                                continue;
                            }
                            v_ce.addElement(s_ce);
                            continue;
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    public WhereColumn toTeradataSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i_count)).toTeradataSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    FunctionCalls wcFunc = (FunctionCalls)this.columnExpression.elementAt(i_count);
                    if (wcFunc.getFunctionName() == null) {
                        v_ce.addElement((FunctionCalls)this.columnExpression.elementAt(i_count));
                        continue;
                    }
                    wcFunc = wcFunc.toTeradataSelect(to_sqs, from_sqs);
                    v_ce.addElement(wcFunc);
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toTeradataSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toTeradataSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toTeradataSelect());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectColumn) {
                    v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i_count)).toTeradataSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (s_ce.equalsIgnoreCase("**")) {
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (s_ce.startsWith("/*") || s_ce.startsWith("--")) {
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("+") || s_ce.equalsIgnoreCase("-")) {
                        Object nextObj;
                        FunctionCalls fc;
                        TableColumn tc;
                        v_ce.addElement(s_ce);
                        if (i_count <= 0 || i_count >= this.columnExpression.size() - 1) continue;
                        boolean isDateExpr = false;
                        Object obj = this.columnExpression.get(i_count - 1);
                        if (obj instanceof TableColumn) {
                            if (SwisSQLUtils.getFunctionReturnType(((TableColumn)obj).getColumnName(), null).equalsIgnoreCase("date")) {
                                isDateExpr = true;
                            } else if (CastingUtil.getValueIgnoreCase(SwisSQLAPI.columnDatatypes, ((TableColumn)obj).getColumnName()) != null && CastingUtil.getValueIgnoreCase(SwisSQLAPI.columnDatatypes, ((TableColumn)obj).getColumnName()).toString().equalsIgnoreCase("timestamp")) {
                                isDateExpr = true;
                            }
                        } else if (obj instanceof FunctionCalls && (tc = (fc = (FunctionCalls)obj).getFunctionName()) != null) {
                            Vector args = fc.getFunctionArguments();
                            if (tc != null && SwisSQLUtils.getFunctionReturnType(tc.getColumnName(), args).equalsIgnoreCase("date")) {
                                isDateExpr = true;
                            }
                        }
                        if (!isDateExpr || !((nextObj = this.columnExpression.get(i_count + 1)) instanceof String)) continue;
                        Vector intervalVector = new Vector();
                        int increaseLoopCount = this.convertNumeralsToInterval(intervalVector, this.columnExpression.subList(i_count + 1, this.columnExpression.size()));
                        if (intervalVector.size() <= 0) continue;
                        v_ce.addAll(intervalVector);
                        i_count += increaseLoopCount;
                        continue;
                    }
                    if (s_ce.indexOf(".") != -1 && s_ce.charAt(0) != '\'' && s_ce.charAt(0) != '.') {
                        String[] elements = s_ce.split("\\.");
                        int esize = elements.length;
                        if (esize > 0) {
                            StringBuffer newS_ce = new StringBuffer();
                            for (int es = 0; es < esize; ++es) {
                                String elem = elements[es];
                                if (!CustomizeUtil.isStartsWithNum(elem)) {
                                    elem = CustomizeUtil.objectNamesToQuotedIdentifier(elem, SwisSQLUtils.getKeywords("teradata"), null, -1);
                                }
                                if (elem.equalsIgnoreCase("dual") || elem.equalsIgnoreCase("sys.dual")) {
                                    elem = "\"DUAL\"";
                                }
                                if (es == 0) {
                                    newS_ce.append(elem);
                                    continue;
                                }
                                newS_ce.append("." + elem);
                            }
                            v_ce.addElement(newS_ce.toString());
                            this.columnExpression.setElementAt(newS_ce.toString(), i_count);
                            continue;
                        }
                        v_ce.addElement(CustomizeUtil.objectNamesToQuotedIdentifier(s_ce, SwisSQLUtils.getKeywords("teradata"), null, -1));
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    public WhereColumn toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)this.columnExpression.elementAt(i_count);
                    if (tc.getColumnName() != null) {
                        String column_Name = tc.getColumnName();
                        if (column_Name.equalsIgnoreCase("SEQUENCE_NAME")) {
                            column_Name = "SEQNAME";
                        }
                        tc.setColumnName(column_Name);
                    }
                    if (this.isLHSExpr()) {
                        TableColumn tcTemp = new TableColumn();
                        tcTemp.setColumnName(tc.getColumnName());
                        if (tc.getTableName() == null) {
                            if (this.stmtTableName != null) {
                                tcTemp.setTableName(this.stmtTableName);
                                tc.setTableName(this.stmtTableName);
                            } else {
                                tcTemp.setTableName(MetadataInfoUtil.getFromTable(this.fromTableList, tc));
                            }
                        } else {
                            tcTemp.setTableName(tc.getTableName());
                        }
                        if (this.sourceDataType == null) {
                            this.sourceDataType = MetadataInfoUtil.getTargetDataTypeForColumn(tcTemp);
                        }
                    } else {
                        tc.setTargetDataType(CastingUtil.getDataType(this.targetDataType));
                    }
                    TableColumn newTC = tc.toDB2Select(to_sqs, from_sqs);
                    if (newTC != null) {
                        if (this.sourceDataType != null && !this.sourceDataType.equalsIgnoreCase("")) {
                            newTC.setSourceDataType(this.sourceDataType);
                        }
                        if (this.stmtTableName != null) {
                            newTC.setTableName(null);
                        }
                    }
                    v_ce.addElement(newTC);
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i_count)).toDB2Select(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toDB2Select(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toDB2Select(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toDB2Select());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectColumn) {
                    v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i_count)).toDB2Select(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    String varDataType;
                    Object exprObj;
                    String operator;
                    Object obj;
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (s_ce.charAt(0) == '\"') {
                        v_ce.addElement(s_ce.replace('\"', '\''));
                        continue;
                    }
                    if (s_ce.startsWith("'") && (s_ce.indexOf("-") != -1 || s_ce.indexOf("/") != -1)) {
                        if (s_ce.indexOf("-") == -1 && s_ce.indexOf("/") == -1) continue;
                        if (s_ce.indexOf("-") != -1) {
                            v_ce.addElement(this.convertToOracleDateFormat(s_ce, "-", true));
                            continue;
                        }
                        if (s_ce.indexOf("/") == -1) continue;
                        v_ce.addElement(this.convertToOracleDateFormat(s_ce, "/", true));
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                        this.createPowerFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("%")) {
                        this.createModFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("::")) {
                        this.createCastFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT")) {
                        v_ce.addElement("CURRENT DATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("NULL")) {
                        v_ce.addElement("CAST(NULL AS INT)");
                        continue;
                    }
                    if (s_ce.trim().equals("/")) {
                        Object obj2 = v_ce.lastElement();
                        FunctionCalls fn = new FunctionCalls();
                        TableColumn tc = new TableColumn();
                        tc.setColumnName("CAST");
                        fn.setFunctionName(tc);
                        Vector<String> args = new Vector<String>();
                        args.add(obj2 + " AS DECIMAL");
                        fn.setFunctionArguments(args);
                        v_ce.setElementAt(fn, v_ce.size() - 1);
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (s_ce.trim().equals("+") && i_count != 0 && i_count != this.columnExpression.size() - 1) {
                        Object o1 = this.columnExpression.get(i_count - 1);
                        Object o2 = this.columnExpression.get(i_count + 1);
                        if (o1.toString().startsWith("'") && o1.toString().endsWith("'") || o2.toString().startsWith("'") && o2.toString().endsWith("'")) {
                            v_ce.add("CONCAT");
                            continue;
                        }
                        if (o1 instanceof TableColumn && o2 instanceof TableColumn) {
                            String datatype1 = MetadataInfoUtil.getDatatypeName(null, (TableColumn)o1);
                            String datatype2 = MetadataInfoUtil.getDatatypeName(null, (TableColumn)o2);
                            if (datatype1 != null && datatype2 != null) {
                                if (datatype1.trim().toLowerCase().startsWith("varchar") || datatype2.trim().toLowerCase().startsWith("varchar")) {
                                    v_ce.add("CONCAT");
                                }
                                if (!datatype1.trim().toLowerCase().startsWith("char") && !datatype2.trim().toLowerCase().startsWith("char")) continue;
                                v_ce.add("CONCAT");
                                continue;
                            }
                            v_ce.add(s_ce);
                            continue;
                        }
                        v_ce.add(s_ce);
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    int size = v_ce.size();
                    if (size <= 2 || !((obj = v_ce.get(size - 2)) instanceof String) || !(operator = (String)obj).trim().equals("+") && !operator.trim().equals("-") || !((exprObj = v_ce.get(size - 3)) instanceof TableColumn)) continue;
                    TableColumn tc = (TableColumn)exprObj;
                    String dataType = MetadataInfoUtil.getDatatypeName(from_sqs, tc);
                    if (dataType != null && (dataType.equalsIgnoreCase("TIMESTAMP") || dataType.equalsIgnoreCase("DATE"))) {
                        v_ce.addElement("DAYS");
                        continue;
                    }
                    if (SwisSQLAPI.variableDatatypeMapping == null || (varDataType = (String)SwisSQLAPI.variableDatatypeMapping.get(tc.getColumnName())) == null || !varDataType.equalsIgnoreCase("TIMESTAMP") && !varDataType.equalsIgnoreCase("DATE")) continue;
                    v_ce.addElement("DAYS");
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    public WhereColumn toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        wc.setCommentClass(this.commentObj);
        if (this.columnExpression != null) {
            for (int i = 0; i < this.columnExpression.size(); ++i) {
                Object temp;
                if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                    String colName;
                    TableColumn tc = (TableColumn)this.columnExpression.elementAt(i);
                    if (this.fromUQS != null) {
                        tc.setFromUQS(this.fromUQS);
                    } else if (this.fromDQS != null) {
                        tc.setFromDQS(this.fromDQS);
                    }
                    if (!this.isLHSExpr()) {
                        this.handleTableColumn(tc, from_sqs, 1);
                    }
                    if (tc.getColumnName() != null) {
                        String column_Name = tc.getColumnName();
                        if (column_Name.equalsIgnoreCase("SEQNAME")) {
                            column_Name = "SEQUENCE_NAME";
                        }
                        tc.setColumnName(column_Name);
                    }
                    tc = tc.toOracleSelect(to_sqs, from_sqs);
                    if (SwisSQLOptions.SetSybaseDoubleQuotedLiteralsToSingleQuotes && tc.getOwnerName() == null && tc.getTableName() == null && (colName = tc.getColumnName()).startsWith("\"")) {
                        colName = colName.replaceAll("'", "\"");
                        colName = "'" + colName.substring(1, colName.length() - 1) + "'";
                        tc.setColumnName(colName);
                    }
                    v_ce.addElement(tc);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                    temp = ((FunctionCalls)this.columnExpression.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                    temp = ((SelectColumn)this.columnExpression.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                    temp = ((CaseStatement)this.columnExpression.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                    temp = ((SelectQueryStatement)this.columnExpression.elementAt(i)).toOracleSelect();
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof WhereColumn) {
                    temp = ((WhereColumn)this.columnExpression.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof String) {
                    String s;
                    String first_arg;
                    s_ce = (String)this.columnExpression.elementAt(i);
                    if (s_ce.charAt(0) == '\"') {
                        v_ce.addElement(s_ce.replace('\"', '\''));
                        continue;
                    }
                    if (s_ce.startsWith("'") && (s_ce.indexOf("-") != -1 || s_ce.indexOf("/") != -1)) {
                        if (s_ce.indexOf("-") == -1 && s_ce.indexOf("/") == -1) continue;
                        if (s_ce.indexOf("-") != -1) {
                            v_ce.addElement(this.convertToOracleDateFormat(s_ce, "-", false));
                            continue;
                        }
                        if (s_ce.indexOf("/") == -1) continue;
                        v_ce.addElement(this.convertToOracleDateFormat(s_ce, "/", false));
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                        v_ce.addElement("TO_CHAR(SYSDATE,'HH:MI:SS')");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                        v_ce.addElement("SYSDATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                        v_ce.addElement("SYSTIMESTAMP");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT")) {
                        v_ce.addElement("SYSDATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("%")) {
                        this.createModFunction(v_ce, this.columnExpression, i);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("&")) {
                        first_arg = "";
                        if (i >= 1) {
                            if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                                first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                            } else if (this.columnExpression.elementAt(i - 1) instanceof FunctionCalls) {
                                first_arg = ((FunctionCalls)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                            } else {
                                for (int h = i - 1; h >= 0; --h) {
                                    s = null;
                                    s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                    if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                        first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                        String bitand2 = this.createBitAnd(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                        v_ce.add(bitand2);
                        v_ce.setElementAt(" ", i - 1);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("|")) {
                        first_arg = "";
                        if (i >= 1) {
                            if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                                first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                            } else {
                                for (int h = i - 1; h >= 0; --h) {
                                    s = null;
                                    s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                    if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                        first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                        String bitor = this.createBitOR(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                        v_ce.add(bitor);
                        v_ce.setElementAt(" ", i - 1);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("^")) {
                        first_arg = "";
                        if (i >= 1) {
                            if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                                first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                            } else {
                                for (int h = i - 1; h >= 0; --h) {
                                    s = null;
                                    s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                    if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                        first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                        String bitxor = this.createBitXOR(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                        v_ce.add(bitxor);
                        v_ce.setElementAt(" ", i - 1);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("::")) {
                        this.createCastFunction(v_ce, this.columnExpression, i);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("**")) {
                        this.createPowerFunction(v_ce, this.columnExpression, i);
                        continue;
                    }
                    if (s_ce.trim().equalsIgnoreCase("+")) {
                        String newStr = null;
                        if (i - 1 >= 0 && this.columnExpression.elementAt(i - 1).toString().trim().startsWith("'")) {
                            newStr = this.columnExpression.elementAt(i - 1).toString();
                            if (newStr.equals("''") || StringFunctions.replaceAll("", " ", newStr.substring(1, newStr.length() - 1)).length() == 0) {
                                v_ce.addElement("||");
                                continue;
                            }
                            if (i + 1 < this.columnExpression.size() && (this.columnExpression.elementAt(i + 1) instanceof TableColumn || this.columnExpression.elementAt(i + 1) instanceof FunctionCalls)) {
                                v_ce.addElement("||");
                                continue;
                            }
                            if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1) instanceof String && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                                v_ce.addElement("||");
                                continue;
                            }
                            if (from_sqs != null) {
                                if (from_sqs.getFromClause() == null && i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                                    v_ce.addElement("||");
                                    continue;
                                }
                                v_ce.addElement(s_ce);
                                continue;
                            }
                            v_ce.addElement(s_ce);
                            continue;
                        }
                        if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                            newStr = this.columnExpression.elementAt(i + 1).toString();
                            if (newStr.equals("''") || StringFunctions.replaceAll("", " ", newStr.substring(1, newStr.length() - 1)).length() == 0) {
                                v_ce.addElement("||");
                                continue;
                            }
                            if (i - 1 >= 0 && (this.columnExpression.elementAt(i - 1) instanceof TableColumn || this.columnExpression.elementAt(i - 1) instanceof FunctionCalls)) {
                                v_ce.addElement("||");
                                continue;
                            }
                            v_ce.addElement(s_ce);
                            continue;
                        }
                        if (i - 1 >= 0 && this.columnExpression.elementAt(i - 1) instanceof TableColumn) {
                            this.addConcatenationSymbol(from_sqs, v_ce, s_ce, (TableColumn)this.columnExpression.elementAt(i - 1));
                            continue;
                        }
                        if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                            this.addConcatenationSymbol(from_sqs, v_ce, s_ce, (TableColumn)this.columnExpression.elementAt(i + 1));
                            continue;
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (s_ce.startsWith("@")) {
                        v_ce.addElement(":" + s_ce.substring(1));
                        continue;
                    }
                    if (s_ce.startsWith("0x") || s_ce.startsWith("0X")) {
                        String str2 = s_ce.substring(2);
                        v_ce.addElement("HEX_TO_NUMBER('" + str2 + "')");
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    private void addConcatenationSymbol(SelectQueryStatement from_sqs, Vector v_ce, String s_ce, TableColumn tc) {
        String dtype = MetadataInfoUtil.getDatatypeName(from_sqs, tc);
        String newStr = tc.getColumnName();
        if (dtype != null && dtype.toLowerCase().indexOf("char") != -1) {
            v_ce.addElement("||");
        } else if (dtype == null && newStr.startsWith("\"") && newStr.endsWith("\"")) {
            String name_only = newStr.substring(1, newStr.length() - 1);
            if (name_only.trim().equals("")) {
                v_ce.addElement("||");
            } else {
                v_ce.addElement(s_ce);
            }
        } else {
            v_ce.addElement(s_ce);
        }
    }

    private String createBitAnd(String first_arg, Vector sec_arg, int startIndex, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String bitand2 = "";
        String sec_arg_str = "";
        Object val = sec_arg.elementAt(startIndex);
        for (int i = startIndex; i < sec_arg.size(); ++i) {
            Object col;
            Object data = sec_arg.elementAt(i);
            if (data instanceof String) {
                String f_arg;
                String str2 = data.toString();
                if (str2.equals("&")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg_str + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    return this.createBitAnd(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("|")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg_str + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("^")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg_str + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitXOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("~")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    Object ne = sec_arg.get(i + 1);
                    if (ne instanceof String) {
                        String ss = ne.toString();
                        return "BITAND(" + first_arg + ",((0-" + ne + ")+1))";
                    }
                    if (!(ne instanceof TableColumn)) continue;
                    TableColumn col2 = ((TableColumn)ne).toOracleSelect(to_sqs, from_sqs);
                    sec_arg_str = sec_arg_str + col2.toString();
                    return "BITAND(" + first_arg + ",((0-" + sec_arg_str + ")+1))";
                }
                if (str2.trim().equals("+") || str2.trim().equals("-") || str2.trim().equals("*") || str2.trim().equals("/") || str2.trim().equals("%") || str2.trim().equals("**") || str2.trim().equals("^") || str2.trim().equals("|") || str2.trim().equals("&")) break;
                sec_arg_str = sec_arg_str + str2;
                continue;
            }
            if (data instanceof TableColumn) {
                col = ((TableColumn)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((TableColumn)col).toString();
                continue;
            }
            if (data instanceof FunctionCalls) {
                col = ((FunctionCalls)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((FunctionCalls)col).toString();
                continue;
            }
            if (data instanceof SelectQueryStatement) {
                SelectQueryStatement sqs = ((SelectQueryStatement)data).toOracleSelect();
                sec_arg_str = sec_arg_str + sqs.toString();
                continue;
            }
            if (data instanceof CaseStatement) {
                CaseStatement cs = ((CaseStatement)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + cs.toString();
                continue;
            }
            if (!(data instanceof SelectColumn)) break;
            SelectColumn sel = ((SelectColumn)data).toOracleSelect(to_sqs, from_sqs);
            sec_arg_str = sec_arg_str + sel.toString();
        }
        sec_arg.setElementAt(" ", startIndex - 1);
        this.columnExpression.setElementAt(" ", startIndex);
        bitand2 = bitand2 + "BITAND(" + first_arg + "," + sec_arg_str + ")";
        return bitand2;
    }

    private String createBitXOR(String first_arg, Vector sec_arg, int startIndex, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String bitxor = "";
        String sec_arg_str = "";
        Object val = sec_arg.elementAt(startIndex);
        for (int i = startIndex; i < sec_arg.size(); ++i) {
            Object col;
            Object data = sec_arg.elementAt(i);
            if (data instanceof String) {
                String f_arg;
                String str2 = data.toString();
                if (str2.equals("^")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + ")*2)";
                    sec_arg.setElementAt(" ", i - 1);
                    return this.createBitXOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("|")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + ")*2)";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("&")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + ")*2)";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitAnd(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("~")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    Object ne = sec_arg.get(i + 1);
                    if (ne instanceof String) {
                        String ss = ne.toString();
                        sec_arg_str = "((0 - " + ne + ") + 1)";
                        return first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))*2";
                    }
                    if (!(ne instanceof TableColumn)) continue;
                    TableColumn col2 = ((TableColumn)ne).toOracleSelect(to_sqs, from_sqs);
                    sec_arg_str = "((0 - " + sec_arg_str + col2.toString() + ") + 1";
                    return first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))*2";
                }
                if (str2.trim().equals("+") || str2.trim().equals("-") || str2.trim().equals("*") || str2.trim().equals("/") || str2.trim().equals("%") || str2.trim().equals("**") || str2.trim().equals("^") || str2.trim().equals("|") || str2.trim().equals("&")) break;
                sec_arg_str = sec_arg_str + str2;
                continue;
            }
            if (data instanceof TableColumn) {
                col = ((TableColumn)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((TableColumn)col).toString();
                continue;
            }
            if (data instanceof FunctionCalls) {
                col = ((FunctionCalls)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((FunctionCalls)col).toString();
                continue;
            }
            if (data instanceof SelectQueryStatement) {
                SelectQueryStatement sqs = ((SelectQueryStatement)data).toOracleSelect();
                sec_arg_str = sec_arg_str + sqs.toString();
                continue;
            }
            if (data instanceof CaseStatement) {
                CaseStatement cs = ((CaseStatement)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + cs.toString();
                continue;
            }
            if (!(data instanceof SelectColumn)) break;
            SelectColumn sel = ((SelectColumn)data).toOracleSelect(to_sqs, from_sqs);
            sec_arg_str = sec_arg_str + sel.toString();
        }
        sec_arg.setElementAt(" ", startIndex - 1);
        this.columnExpression.setElementAt(" ", startIndex);
        bitxor = bitxor + "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + ")*2)";
        return bitxor;
    }

    private String createBitOR(String first_arg, Vector sec_arg, int startIndex, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String bitor = "";
        String sec_arg_str = "";
        Object val = sec_arg.elementAt(startIndex);
        for (int i = startIndex; i < sec_arg.size(); ++i) {
            Object col;
            Object data = sec_arg.elementAt(i);
            if (data instanceof String) {
                String f_arg;
                String str2 = data.toString();
                if (str2.equals("|")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                    sec_arg.setElementAt(" ", i - 1);
                    return this.createBitOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("^")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitXOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("&")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitAnd(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("~")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    Object ne = sec_arg.get(i + 1);
                    if (ne instanceof String) {
                        String ss = ne.toString();
                        sec_arg_str = "((0 - " + ne + ") + 1)";
                        return "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                    }
                    if (!(ne instanceof TableColumn)) continue;
                    TableColumn col2 = ((TableColumn)ne).toOracleSelect(to_sqs, from_sqs);
                    sec_arg_str = "((0 - " + sec_arg_str + col2.toString() + ") + 1";
                    return "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                }
                if (str2.trim().equals("+") || str2.trim().equals("-") || str2.trim().equals("*") || str2.trim().equals("/") || str2.trim().equals("%") || str2.trim().equals("**") || str2.trim().equals("^") || str2.trim().equals("|") || str2.trim().equals("&")) break;
                sec_arg_str = sec_arg_str + str2;
                continue;
            }
            if (data instanceof TableColumn) {
                col = ((TableColumn)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((TableColumn)col).toString();
                continue;
            }
            if (data instanceof FunctionCalls) {
                col = ((FunctionCalls)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((FunctionCalls)col).toString();
                continue;
            }
            if (data instanceof SelectQueryStatement) {
                SelectQueryStatement sqs = ((SelectQueryStatement)data).toOracleSelect();
                sec_arg_str = sec_arg_str + sqs.toString();
                continue;
            }
            if (data instanceof CaseStatement) {
                CaseStatement cs = ((CaseStatement)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + cs.toString();
                continue;
            }
            if (!(data instanceof SelectColumn)) break;
            SelectColumn sel = ((SelectColumn)data).toOracleSelect(to_sqs, from_sqs);
            sec_arg_str = sec_arg_str + sel.toString();
        }
        sec_arg.setElementAt(" ", startIndex - 1);
        this.columnExpression.setElementAt(" ", startIndex);
        bitor = bitor + "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
        return bitor;
    }

    private String convertToOracleDateFormat(String originalString, String hiphenOrSlash, boolean convertDateFormatForDB2) {
        StringTokenizer st = new StringTokenizer(originalString, hiphenOrSlash);
        int count2 = st.countTokens();
        Vector<String> tokenVector = new Vector<String>();
        if (count2 == 3) {
            int date2;
            while (st.hasMoreTokens()) {
                tokenVector.add(st.nextToken());
            }
            String str1 = (String)tokenVector.get(0);
            String str2 = (String)tokenVector.get(1);
            String str3 = (String)tokenVector.get(2);
            boolean validDate = true;
            if (str1.startsWith("'")) {
                str1 = str1.substring(1);
            }
            if (str3.endsWith("'")) {
                str3 = str3.substring(0, str3.length() - 1);
            }
            try {
                date2 = Integer.parseInt(str3);
            }
            catch (NumberFormatException e) {
                validDate = false;
            }
            try {
                date2 = Integer.parseInt(str1);
            }
            catch (NumberFormatException e) {
                validDate = false;
            }
            String convertedSting = "";
            if (str1.length() == 2 && str2.length() == 2 && str3.length() == 2 && validDate || str1.length() == 2 && str2.length() == 2 && str3.length() == 4 && validDate || str1.length() == 2 && str2.length() == 3 && str3.length() == 4 && validDate || str1.length() == 2 && str2.length() > 3 && str3.length() == 4 && validDate || str1.length() == 2 && str2.length() > 3 && str3.length() == 2 && validDate) {
                block18: {
                    try {
                        int monthValue = Integer.parseInt(str2);
                        if (monthValue > 12 && convertDateFormatForDB2) {
                            String temp = str2;
                            str2 = str1;
                            str1 = temp;
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!convertDateFormatForDB2) break block18;
                        str2 = this.convertMonthsToEquivalentMonthValue(str2);
                    }
                }
                convertedSting = str3 + hiphenOrSlash + str2 + hiphenOrSlash + str1;
            } else if (str1.length() == 4 && str2.length() == 3 && str3.length() == 2 && validDate || str1.length() == 4 && str2.length() > 3 && str3.length() == 2 && validDate || str1.length() == 4 && str2.length() == 2 && str3.length() == 2 && validDate) {
                block19: {
                    try {
                        int monthValue = Integer.parseInt(str2);
                        if (monthValue > 12 && convertDateFormatForDB2) {
                            String temp = str2;
                            str2 = str3;
                            str3 = temp;
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!convertDateFormatForDB2) break block19;
                        str2 = this.convertMonthsToEquivalentMonthValue(str2);
                    }
                }
                convertedSting = str1 + hiphenOrSlash + str2 + hiphenOrSlash + str3;
            } else {
                convertedSting = str1 + hiphenOrSlash + str2 + hiphenOrSlash + str3;
            }
            return '\'' + convertedSting + '\'';
        }
        return originalString;
    }

    private String convertMonthsToEquivalentMonthValue(String monthName) {
        if ((monthName = monthName.trim().toUpperCase()).equals("JAN") || monthName.equals("JANUARY")) {
            return "01";
        }
        if (monthName.equals("FEB") || monthName.equals("FEBRUARY")) {
            return "02";
        }
        if (monthName.equals("MAR") || monthName.equals("MARCH")) {
            return "03";
        }
        if (monthName.equals("APR") || monthName.equals("APRIL")) {
            return "04";
        }
        if (monthName.equals("MAY")) {
            return "05";
        }
        if (monthName.equals("JUN") || monthName.equals("JUNE")) {
            return "06";
        }
        if (monthName.equals("JUL") || monthName.equals("JULY")) {
            return "07";
        }
        if (monthName.equals("AUG") || monthName.equals("AUGUST")) {
            return "08";
        }
        if (monthName.equals("SEP") || monthName.equals("SEPTEMBER")) {
            return "09";
        }
        if (monthName.equals("OCT") || monthName.equals("OCTOBER")) {
            return "10";
        }
        if (monthName.equals("NOV") || monthName.equals("NOVEMBER")) {
            return "11";
        }
        if (monthName.equals("DEC") || monthName.equals("DECEMBER")) {
            return "12";
        }
        return monthName;
    }

    public WhereColumn toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i_count)).toInformixSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i_count)).toInformixSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toInformixSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toInformixSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toInformixSelect());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                        v_ce.addElement("CURRENT");
                        continue;
                    }
                    if (s_ce.startsWith("'") && (s_ce.indexOf("-") != -1 || s_ce.indexOf("/") != -1)) {
                        if (s_ce.indexOf("-") == -1 && s_ce.indexOf("/") == -1) continue;
                        if (s_ce.indexOf("-") != -1) {
                            v_ce.addElement(this.convertToOracleDateFormat(s_ce, "-", false));
                            continue;
                        }
                        if (s_ce.indexOf("/") == -1) continue;
                        v_ce.addElement(this.convertToOracleDateFormat(s_ce, "/", false));
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("%")) {
                        this.createModFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                        this.createPowerFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    public void createModFunction(Vector v_ce, Vector columnExpression, int i_count) {
        WhereColumn wc_firstarg = new WhereColumn();
        WhereColumn wc_secondarg = new WhereColumn();
        Vector<WhereColumn> v_farg = new Vector<WhereColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        tc.setColumnName("MOD");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(v_ce.get(v_ce.size() - 1));
        v_ce.setElementAt(" ", i_count - 1);
        wc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(wc_firstarg);
        vec_secondarg.addElement(columnExpression.elementAt(i_count + 1));
        columnExpression.setElementAt(" ", i_count + 1);
        wc_secondarg.setColumnExpression(vec_secondarg);
        v_farg.addElement(wc_secondarg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
    }

    public void createCastFunction(Vector v_ce, Vector columnExpression, int i_count) {
        WhereColumn wc_firstarg = new WhereColumn();
        WhereColumn wc_secondarg = new WhereColumn();
        Vector<WhereColumn> v_farg = new Vector<WhereColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        tc.setColumnName("CAST");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(columnExpression.elementAt(i_count - 1));
        vec_firstarg.addElement(" AS ");
        vec_firstarg.addElement(columnExpression.elementAt(i_count + 1));
        v_ce.setElementAt(" ", i_count - 1);
        columnExpression.setElementAt(" ", i_count + 1);
        wc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(wc_firstarg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
    }

    public WhereColumn toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i_count)).toPostgreSQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i_count)).toPostgreSQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toPostgreSQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toPostgreSQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toPostgreSQLSelect());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                        v_ce.addElement("CURRENT_TIME");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                        v_ce.addElement("CURRENT_DATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                        v_ce.addElement("CURRENT_TIMESTAMP");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT")) {
                        v_ce.addElement("CURRENT_DATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("**")) {
                        v_ce.addElement("^");
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    public WhereColumn toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i_count)).toMySQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i_count)).toMySQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toMySQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toMySQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toMySQLSelect());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectColumn) {
                    v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i_count)).toMySQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                        v_ce.addElement("CURRENT_TIME");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                        v_ce.addElement("CURRENT_DATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                        v_ce.addElement("CURRENT_TIMESTAMP");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                        this.createPowerFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("::")) {
                        this.createCastFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    if (s_ce.indexOf(".") != -1 && s_ce.indexOf(".") == s_ce.lastIndexOf(".") && !s_ce.startsWith("'") && !this.isDecimal(s_ce)) {
                        String s_ceTableName = s_ce.substring(0, s_ce.lastIndexOf("."));
                        String s_ceColName = s_ce.substring(s_ce.lastIndexOf(".") + 1);
                        TableColumn tc = new TableColumn();
                        tc.setColumnName(s_ceColName);
                        tc.setTableName(s_ceTableName);
                        v_ce.addElement(tc.toMySQLSelect(to_sqs, from_sqs));
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    public WhereColumn toTimesTenSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i = 0; i < this.columnExpression.size(); ++i) {
                Object temp;
                if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)this.columnExpression.elementAt(i);
                    if (!this.isLHSExpr()) {
                        this.handleTableColumn(tc, from_sqs, 10);
                    }
                    v_ce.addElement(tc.toTimesTenSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                    temp = ((FunctionCalls)this.columnExpression.elementAt(i)).toTimesTenSelect(to_sqs, from_sqs);
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                    temp = ((SelectColumn)this.columnExpression.elementAt(i)).toTimesTenSelect(to_sqs, from_sqs);
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                    throw new ConvertException("\nCASE statements are not supported in TimesTen 5.1.21\n");
                }
                if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                    temp = ((SelectQueryStatement)this.columnExpression.elementAt(i)).toTimesTenSelect();
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof WhereColumn) {
                    temp = ((WhereColumn)this.columnExpression.elementAt(i)).toTimesTenSelect(to_sqs, from_sqs);
                    v_ce.addElement(temp);
                    this.columnExpression.setElementAt(temp, i);
                    continue;
                }
                if (this.columnExpression.elementAt(i) instanceof String) {
                    String s;
                    String first_arg;
                    s_ce = (String)this.columnExpression.elementAt(i);
                    if (s_ce.charAt(0) == '\"') {
                        v_ce.addElement(s_ce.replace('\"', '\''));
                        continue;
                    }
                    if (s_ce.startsWith("'") && (s_ce.indexOf("-") != -1 || s_ce.indexOf("/") != -1)) {
                        if (s_ce.indexOf("-") == -1 && s_ce.indexOf("/") == -1) continue;
                        if (s_ce.indexOf("-") != -1) {
                            v_ce.addElement(this.convertToOracleDateFormat(s_ce, "-", false));
                            continue;
                        }
                        if (s_ce.indexOf("/") == -1) continue;
                        v_ce.addElement(this.convertToOracleDateFormat(s_ce, "/", false));
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                        v_ce.addElement("TO_CHAR(SYSDATE,'HH:MI:SS')");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                        v_ce.addElement("SYSDATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) continue;
                    if (s_ce.equalsIgnoreCase("CURRENT")) {
                        v_ce.addElement("SYSDATE");
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("%")) {
                        this.createModFunction(v_ce, this.columnExpression, i);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("&")) {
                        first_arg = "";
                        if (i >= 1) {
                            if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                                first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toTimesTenSelect(to_sqs, from_sqs).toString();
                            } else if (this.columnExpression.elementAt(i - 1) instanceof FunctionCalls) {
                                first_arg = ((FunctionCalls)this.columnExpression.elementAt(i - 1)).toTimesTenSelect(to_sqs, from_sqs).toString();
                            } else {
                                for (int h = i - 1; h >= 0; --h) {
                                    s = null;
                                    s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toTimesTenSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                    if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                        first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toTimesTenSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                        String bitand2 = this.createBitAnd(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                        v_ce.add(bitand2);
                        v_ce.setElementAt(" ", i - 1);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("|")) {
                        first_arg = "";
                        if (i >= 1) {
                            if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                                first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toTimesTenSelect(to_sqs, from_sqs).toString();
                            } else {
                                for (int h = i - 1; h >= 0; --h) {
                                    s = null;
                                    s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toTimesTenSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                    if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                        first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toTimesTenSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                        String bitor = this.createBitOR(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                        v_ce.add(bitor);
                        v_ce.setElementAt(" ", i - 1);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("^")) {
                        first_arg = "";
                        if (i >= 1) {
                            if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                                first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toTimesTenSelect(to_sqs, from_sqs).toString();
                            } else {
                                for (int h = i - 1; h >= 0; --h) {
                                    s = null;
                                    s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toTimesTenSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                    if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                        first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toTimesTenSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                        String bitxor = this.createBitXOR(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                        v_ce.add(bitxor);
                        v_ce.setElementAt(" ", i - 1);
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("::") || s_ce.equalsIgnoreCase("**")) continue;
                    if (s_ce.startsWith("@")) {
                        v_ce.addElement(":" + s_ce.substring(1));
                        continue;
                    }
                    if (s_ce.startsWith("0x") || s_ce.startsWith("0X")) {
                        String str2 = s_ce.substring(2);
                        v_ce.addElement("HEX_TO_NUMBER('" + str2 + "')");
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    public WhereColumn toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn wc = new WhereColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        wc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression != null) {
            for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
                if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                    v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i_count)).toNetezzaSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                    v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i_count)).toNetezzaSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof WhereColumn) {
                    v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i_count)).toNetezzaSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectColumn) {
                    v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i_count)).toNetezzaSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof CaseStatement) {
                    v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i_count)).toNetezzaSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof SelectQueryStatement) {
                    v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i_count)).toNetezzaSelect());
                    continue;
                }
                if (this.columnExpression.elementAt(i_count) instanceof String) {
                    s_ce = (String)this.columnExpression.elementAt(i_count);
                    if (s_ce.charAt(0) == '\"') {
                        v_ce.addElement(s_ce.replace('\"', '\''));
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("**")) {
                        this.createPowerFunction(v_ce, this.columnExpression, i_count);
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(this.columnExpression.elementAt(i_count));
            }
            wc.setColumnExpression(v_ce);
        }
        wc.setCloseBrace(this.CloseBrace);
        return wc;
    }

    private boolean isDecimal(String input) {
        try {
            double a = Double.parseDouble(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void handleTableColumn(TableColumn tc, SelectQueryStatement from_sqs, int target) {
        String columnName = tc.getColumnName();
        if (columnName != null && tc.getTableName() == null && columnName.trim().length() > 0) {
            if (columnName.equalsIgnoreCase("\"\"")) {
                if (target == 10) {
                    if (SwisSQLOptions.fromSybase) {
                        tc.setColumnName("' '");
                    } else {
                        tc.setColumnName("''");
                    }
                } else {
                    tc.setColumnName("''");
                }
            } else if (columnName.startsWith("\"")) {
                FromTable fromTab;
                String tableName;
                TableObject tabObj;
                ArrayList tabClauseList;
                TableExpression tExpr;
                Vector<FromTable> newFromItems;
                boolean modify = true;
                FromClause fc = null;
                if (from_sqs != null) {
                    fc = from_sqs.getFromClause();
                } else if (this.fromUQS != null) {
                    Vector fromItems;
                    FromClause uqsFC;
                    fc = new FromClause();
                    newFromItems = new Vector<FromTable>();
                    fc.setFromItemList(newFromItems);
                    tExpr = this.fromUQS.getTableExpression();
                    if (tExpr != null && (tabClauseList = tExpr.getTableClauseList()) != null) {
                        for (int j = 0; j < tabClauseList.size(); ++j) {
                            Object obj = tabClauseList.get(j);
                            if (!(obj instanceof TableClause)) continue;
                            tabObj = ((TableClause)obj).getTableObject();
                            tableName = tabObj.getTableName();
                            fromTab = new FromTable();
                            fromTab.setTableName(tableName);
                            newFromItems.add(fromTab);
                        }
                    }
                    if ((uqsFC = this.fromUQS.getFromClause()) != null && (fromItems = uqsFC.getFromItemList()) != null) {
                        for (int j = 0; j < fromItems.size(); ++j) {
                            newFromItems.add((FromTable)fromItems.get(j));
                        }
                    }
                } else if (this.fromDQS != null) {
                    Vector fromItems;
                    FromClause delFC;
                    fc = new FromClause();
                    newFromItems = new Vector();
                    fc.setFromItemList(newFromItems);
                    tExpr = this.fromDQS.getTableExpression();
                    if (tExpr != null && (tabClauseList = tExpr.getTableClauseList()) != null) {
                        for (int j = 0; j < tabClauseList.size(); ++j) {
                            Object obj = tabClauseList.get(j);
                            if (!(obj instanceof TableClause)) continue;
                            tabObj = ((TableClause)obj).getTableObject();
                            tableName = tabObj.getTableName();
                            fromTab = new FromTable();
                            fromTab.setTableName(tableName);
                            newFromItems.add(fromTab);
                        }
                    }
                    if ((delFC = this.fromDQS.getFromClause()) != null && (fromItems = delFC.getFromItemList()) != null) {
                        for (int j = 0; j < fromItems.size(); ++j) {
                            newFromItems.add((FromTable)fromItems.get(j));
                        }
                    }
                } else {
                    modify = false;
                }
                if (fc != null) {
                    String tempCol = columnName.trim().substring(1, columnName.trim().length() - 1);
                    Vector fromItems = fc.getFromItemList();
                    if (fromItems != null) {
                        for (int j = 0; j < fromItems.size(); ++j) {
                            ArrayList colList;
                            Object obj = fromItems.get(j);
                            if (!(obj instanceof FromTable) || !((obj = ((FromTable)obj).getTableName()) instanceof String)) continue;
                            String tableName2 = (String)obj;
                            int index = tableName2.lastIndexOf(".");
                            if (index != -1) {
                                tableName2.substring(index + 1);
                            }
                            if (tableName2.startsWith("\"") || tableName2.startsWith("[") || tableName2.startsWith("`")) {
                                tableName2 = tableName2.substring(1, tableName2.length() - 1);
                            }
                            if ((colList = (ArrayList)CastingUtil.getValueIgnoreCase(SwisSQLAPI.tableColumnListMetadata, tableName2)) != null) {
                                if (!CastingUtil.ContainsIgnoreCase(colList, tempCol)) continue;
                                modify = false;
                                break;
                            }
                            modify = false;
                            break;
                        }
                    }
                }
                if (modify) {
                    columnName = StringFunctions.replaceFirst("'", "\"", columnName);
                    columnName = columnName.trim().substring(0, columnName.trim().length() - 1) + "'";
                    tc.setColumnName(columnName);
                }
            }
        }
    }

    public void createBitAndFunction(Vector v_ce, Vector columnExpression, int i) {
        SelectColumn sc_firstarg = new SelectColumn();
        SelectColumn sc_secondarg = new SelectColumn();
        Vector<SelectColumn> v_farg = new Vector<SelectColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        tc.setColumnName("BITAND");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(columnExpression.elementAt(i - 1));
        v_ce.setElementAt(" ", i - 1);
        sc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(sc_firstarg);
        vec_secondarg.addElement(columnExpression.elementAt(i + 1));
        columnExpression.setElementAt(" ", i + 1);
        sc_secondarg.setColumnExpression(vec_secondarg);
        v_farg.addElement(sc_secondarg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.commentObj != null) {
            sb.append(this.commentObj.toString().trim() + " ");
        }
        if (this.OpenBrace != null) {
            sb.append(this.OpenBrace);
        }
        for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
            if (this.columnExpression.elementAt(i_count) instanceof TableColumn) {
                ((TableColumn)this.columnExpression.elementAt(i_count)).setObjectContext(this.context);
            } else if (this.columnExpression.elementAt(i_count) instanceof SelectColumn) {
                ((SelectColumn)this.columnExpression.elementAt(i_count)).setObjectContext(this.context);
            } else if (this.columnExpression.elementAt(i_count) instanceof FunctionCalls) {
                ((FunctionCalls)this.columnExpression.elementAt(i_count)).setObjectContext(this.context);
            }
            if (this.columnExpression.elementAt(i_count) == null) continue;
            sb.append(this.columnExpression.elementAt(i_count).toString() + " ");
        }
        if (this.CloseBrace != null) {
            sb.append(this.CloseBrace);
        }
        return sb.toString();
    }

    public String getTableAlias() {
        if (this.getColumnExpression() != null && this.getColumnExpression().size() > 0) {
            for (int i = 0; i < this.getColumnExpression().size(); ++i) {
                if (this.getColumnExpression().get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)this.getColumnExpression().get(i);
                    return tc.getTableName();
                }
                if (this.getColumnExpression().get(i) instanceof FunctionCalls) {
                    CaseStatement cs;
                    WhereItem cswi;
                    SelectColumn cssc;
                    String tableName;
                    FunctionCalls fnc;
                    Vector functionArguments = ((FunctionCalls)this.getColumnExpression().get(i)).getFunctionArguments();
                    if (functionArguments != null) {
                        for (int j = 0; j < functionArguments.size(); ++j) {
                            String tableName2;
                            if (!(functionArguments.get(j) instanceof SelectColumn) || (tableName2 = this.getTableAlias((SelectColumn)functionArguments.get(j))) == null || tableName2.equals("")) continue;
                            return tableName2;
                        }
                        continue;
                    }
                    if (functionArguments != null || !(this.getColumnExpression().get(i) instanceof decode) || !(fnc = (FunctionCalls)this.getColumnExpression().get(i)).toString().trim().toLowerCase().startsWith("case") || !(fnc instanceof decode) || (tableName = this.getTableAlias(cssc = (SelectColumn)(cswi = (WhereItem)(cs = ((decode)fnc).getCaseStatement()).getCaseCondition().getWhereItem().get(0)).getLeftWhereExp().getColumnExpression().get(0))) == null || tableName.equals("")) continue;
                    return tableName;
                }
                if (!(this.getColumnExpression().get(i) instanceof String)) continue;
                String tableAliaswhere = (String)this.getColumnExpression().get(i);
                if (tableAliaswhere.startsWith("'")) {
                    return "";
                }
                if (tableAliaswhere.indexOf(".") == -1) continue;
                if (tableAliaswhere.indexOf(46) != tableAliaswhere.lastIndexOf(46) && SwisSQLOptions.removeDBSchemaQualifier) {
                    return tableAliaswhere.substring(tableAliaswhere.indexOf(46) + 1, tableAliaswhere.lastIndexOf("."));
                }
                return tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
            }
        }
        return null;
    }

    private String getTableAlias(SelectColumn sc) {
        if (sc != null && sc.getColumnExpression() != null && sc.getColumnExpression().size() > 0) {
            for (int i = 0; i < sc.getColumnExpression().size(); ++i) {
                if (sc.getColumnExpression().get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)sc.getColumnExpression().get(i);
                    return tc.getTableName();
                }
                if (sc.getColumnExpression().get(i) instanceof FunctionCalls) {
                    Vector functionArguments = ((FunctionCalls)sc.getColumnExpression().get(i)).getFunctionArguments();
                    if (functionArguments == null) continue;
                    for (int j = 0; j < functionArguments.size(); ++j) {
                        String tableName;
                        if (!(functionArguments.get(j) instanceof SelectColumn) || (tableName = this.getTableAlias((SelectColumn)functionArguments.get(j))) == null) continue;
                        return tableName;
                    }
                    continue;
                }
                if (!(sc.getColumnExpression().get(i) instanceof String)) continue;
                String tableAliaswhere = (String)sc.getColumnExpression().get(i);
                if (tableAliaswhere.startsWith("'")) {
                    return "";
                }
                if (tableAliaswhere.indexOf(".") == -1) continue;
                if (tableAliaswhere.indexOf(46) != tableAliaswhere.lastIndexOf(46) && SwisSQLOptions.removeDBSchemaQualifier) {
                    return tableAliaswhere.substring(tableAliaswhere.indexOf(46) + 1, tableAliaswhere.lastIndexOf("."));
                }
                return tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
            }
        }
        return null;
    }

    private int convertNumeralsToInterval(Vector intervalVector, List subList) {
        int processedElements = 0;
        String previousOperator = "";
        for (int k = 0; k < subList.size(); ++k) {
            Object obj = subList.get(k);
            if (!(obj instanceof String)) continue;
            String objStr = obj.toString().trim();
            if (this.isDecimal(objStr) && (previousOperator.equalsIgnoreCase("") || previousOperator.equalsIgnoreCase("+") || previousOperator.equalsIgnoreCase("-"))) {
                String intervalStr = SwisSQLUtils.convertDayToInterval(objStr);
                ++processedElements;
                if (k != subList.size() - 1 && subList.get(k + 1).toString().equalsIgnoreCase("/") && subList.get(k + 2).toString().trim().equalsIgnoreCase("24")) {
                    intervalStr = intervalStr.replaceFirst("DAY", "HOUR");
                    k += 2;
                    processedElements += 2;
                }
                intervalVector.add(intervalStr);
                continue;
            }
            if (objStr.length() != 1) break;
            if (objStr.equalsIgnoreCase("(") || objStr.equalsIgnoreCase(")") || objStr.equalsIgnoreCase("+") || objStr.equalsIgnoreCase("-") || objStr.equalsIgnoreCase("*") || objStr.equalsIgnoreCase("%") || objStr.equalsIgnoreCase("^")) {
                intervalVector.add(objStr);
                previousOperator = objStr;
                ++processedElements;
                continue;
            }
            if (!this.isDecimal(objStr)) continue;
            intervalVector.add(objStr);
            ++processedElements;
        }
        return processedElements;
    }

    public void replaceRownumTableColumn(Object newColumn) throws ConvertException {
        for (int i_count = 0; i_count < this.columnExpression.size(); ++i_count) {
            Object obj = this.columnExpression.elementAt(i_count);
            if (obj instanceof TableColumn) {
                TableColumn tcnMod = (TableColumn)obj;
                if (!tcnMod.getColumnName().equalsIgnoreCase("rownum")) continue;
                this.columnExpression.setElementAt(newColumn, i_count);
                continue;
            }
            if (obj instanceof FunctionCalls) {
                FunctionCalls wcFunc = (FunctionCalls)obj;
                Vector funcArgs = ((FunctionCalls)obj).getFunctionArguments();
                if (funcArgs == null) continue;
                for (int j = 0; j < funcArgs.size(); ++j) {
                    TableColumn tcnMod;
                    if (funcArgs.get(j) instanceof SelectColumn) {
                        ((SelectColumn)funcArgs.get(j)).replaceRownumTableColumn(newColumn);
                        continue;
                    }
                    if (!(funcArgs.get(j) instanceof TableColumn) || !(tcnMod = (TableColumn)funcArgs.get(j)).getColumnName().equalsIgnoreCase("rownum")) continue;
                    funcArgs.setElementAt(newColumn, j);
                }
                continue;
            }
            if (obj instanceof WhereColumn) {
                ((WhereColumn)obj).replaceRownumTableColumn(newColumn);
                continue;
            }
            if (obj instanceof CaseStatement) {
                ((CaseStatement)obj).replaceRownumTableColumn(newColumn);
                continue;
            }
            if (obj instanceof SelectQueryStatement) continue;
            if (obj instanceof SelectColumn) {
                ((SelectColumn)obj).replaceRownumTableColumn(newColumn);
                continue;
            }
            if (!(obj instanceof String)) continue;
        }
    }
}

