/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import java.util.Vector;

public class SetOperatorClause {
    private String SetClause;
    private SelectQueryStatement query_statement;
    private String OpenBrace;
    private String CloseBrace;
    private WhereExpression whereExpression = null;
    private boolean checkSetOperator;
    private UserObjectContext context = null;
    private CommentClass commentObj;

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setSetClause(String s_sc) {
        this.SetClause = s_sc;
    }

    public void setSelectQueryStatement(SelectQueryStatement q_qs) {
        this.query_statement = q_qs;
    }

    public void setOpenBrace(String s_ob) {
        this.OpenBrace = s_ob;
    }

    public void setCloseBrace(String s_cb) {
        this.CloseBrace = s_cb;
    }

    public void setCheckSetOperator(boolean b_cso) {
        this.checkSetOperator = b_cso;
    }

    public void setWhereExpression(WhereExpression we) {
        this.whereExpression = we;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public boolean getCheckSetOperator() {
        return this.checkSetOperator;
    }

    public String getSetClause() {
        return this.SetClause;
    }

    public SelectQueryStatement getSelectQueryStatement() {
        return this.query_statement;
    }

    public String getOpenBrace() {
        return this.OpenBrace;
    }

    public String getCloseBrace() {
        return this.CloseBrace;
    }

    public SetOperatorClause toANSISelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        soc.setOpenBrace(this.OpenBrace);
        if (this.SetClause.equalsIgnoreCase("MINUS")) {
            soc.setSetClause("EXCEPT");
        } else {
            soc.setSetClause(this.SetClause);
        }
        soc.setSelectQueryStatement(this.query_statement.toANSISelect());
        soc.setCloseBrace(this.CloseBrace);
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toTeradataSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        soc.setOpenBrace(this.OpenBrace);
        if (this.SetClause.equalsIgnoreCase("MINUS")) {
            soc.setSetClause("EXCEPT");
        } else {
            soc.setSetClause(this.SetClause);
        }
        if (from_sqs != null && this.query_statement != null) {
            this.query_statement.setTopLevel(from_sqs.getTopLevel());
        }
        soc.setSelectQueryStatement(this.query_statement.toTeradataSelect());
        soc.setCloseBrace(this.CloseBrace);
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        soc.setOpenBrace(this.OpenBrace);
        if (this.SetClause.equalsIgnoreCase("MINUS")) {
            soc.setSetClause("EXCEPT");
        } else {
            soc.setSetClause(this.SetClause);
        }
        soc.setSelectQueryStatement(this.query_statement.toDB2Select());
        soc.setCloseBrace(this.CloseBrace);
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        soc.setOpenBrace(this.OpenBrace);
        if (this.SetClause.equalsIgnoreCase("MINUS") | this.SetClause.equalsIgnoreCase("EXCEPT ALL")) {
            soc.setSetClause("EXCEPT");
        } else if (this.SetClause.equalsIgnoreCase("INTERSECT ALL")) {
            soc.setSetClause("INTERSECT");
        } else {
            soc.setSetClause(this.SetClause);
        }
        soc.setSelectQueryStatement(this.query_statement.toPostgreSQLSelect());
        soc.setCloseBrace(this.CloseBrace);
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        WhereExpression we = new WhereExpression();
        WhereItem wi = new WhereItem();
        SelectQueryStatement sqs = this.query_statement.toMySQLSelect();
        soc.setSelectQueryStatement(sqs);
        soc.setOpenBrace(this.OpenBrace);
        soc.setCloseBrace(this.CloseBrace);
        if (!this.SetClause.equalsIgnoreCase("UNION") && !this.SetClause.equalsIgnoreCase("UNION ALL")) {
            if (this.SetClause.equalsIgnoreCase("INTERSECT") | this.SetClause.equalsIgnoreCase("INTERSECT ALL")) {
                wi.setOperator("EXISTS");
            } else {
                wi.setOperator("NOT EXISTS");
                Vector query_statementFromTableList = sqs.getFromClause().getFromItemList();
                int qListSize = query_statementFromTableList.size();
                for (int qi = 0; qi < qListSize; ++qi) {
                    FromTable fromTableObj = (FromTable)query_statementFromTableList.get(qi);
                    if (fromTableObj.getAliasName() != null && !fromTableObj.getAliasName().equalsIgnoreCase(" ")) continue;
                    fromTableObj.setAliasName("ADV_INNER_ALIAS_" + qi);
                }
            }
            if (sqs.getWhereExpression() != null && !sqs.getWhereExpression().toString().trim().equals("")) {
                sqs.getWhereExpression().addOperator("AND");
                sqs.getWhereExpression().addWhereExpression(this.createWhereExp(to_sqs, sqs));
            } else {
                sqs.setWhereExpression(this.createWhereExp(to_sqs, sqs));
            }
            wi.setRightWhereSubQuery(sqs);
            we.addWhereItem(wi);
            if (to_sqs.getWhereExpression() != null && !to_sqs.getWhereExpression().toString().trim().equals("")) {
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereExpression(we);
            } else {
                to_sqs.setWhereExpression(we);
            }
            if (to_sqs.getSelectStatement() != null) {
                to_sqs.getSelectStatement().setSelectQualifier("DISTINCT");
            }
            soc = null;
        } else {
            soc.setSetClause(this.SetClause);
        }
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        soc.setCommentClass(this.commentObj);
        soc.setOpenBrace(this.OpenBrace);
        if (this.SetClause.equalsIgnoreCase("EXCEPT") | this.SetClause.equalsIgnoreCase("EXCEPT ALL")) {
            soc.setSetClause("MINUS");
        } else if (this.SetClause.equalsIgnoreCase("INTERSECT ALL")) {
            soc.setSetClause("INTERSECT");
        } else {
            soc.setSetClause(this.SetClause);
        }
        this.query_statement.setObjectContext(this.context);
        soc.setSelectQueryStatement(this.query_statement.toOracleSelect());
        soc.setCloseBrace(this.CloseBrace);
        soc.setObjectContext(this.context);
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        WhereExpression we = new WhereExpression();
        WhereItem wi = new WhereItem();
        SelectQueryStatement sqs = this.query_statement.toMSSQLServerSelect();
        soc.setSelectQueryStatement(sqs);
        soc.setOpenBrace(this.OpenBrace);
        soc.setCloseBrace(this.CloseBrace);
        if (!this.SetClause.equalsIgnoreCase("UNION") && !this.SetClause.equalsIgnoreCase("UNION ALL")) {
            if (this.SetClause.equalsIgnoreCase("INTERSECT") | this.SetClause.equalsIgnoreCase("INTERSECT ALL")) {
                wi.setOperator("EXISTS");
            } else {
                wi.setOperator("NOT EXISTS");
                Vector query_statementFromTableList = sqs.getFromClause().getFromItemList();
                int qListSize = query_statementFromTableList.size();
                for (int qi = 0; qi < qListSize; ++qi) {
                    FromTable fromTableObj = (FromTable)query_statementFromTableList.get(qi);
                    if (fromTableObj.getAliasName() != null && !fromTableObj.getAliasName().equalsIgnoreCase(" ")) continue;
                    fromTableObj.setAliasName("ADV_INNER_ALIAS_" + qi);
                }
            }
            if (sqs.getWhereExpression() != null && !sqs.getWhereExpression().toString().trim().equals("")) {
                sqs.getWhereExpression().addOperator("AND");
                sqs.getWhereExpression().addWhereExpression(this.createWhereExp(to_sqs, sqs));
            } else {
                sqs.setWhereExpression(this.createWhereExp(to_sqs, sqs));
            }
            wi.setRightWhereSubQuery(sqs);
            we.addWhereItem(wi);
            if (to_sqs.getWhereExpression() != null && !to_sqs.getWhereExpression().toString().trim().equals("")) {
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereExpression(we);
            } else {
                to_sqs.setWhereExpression(we);
            }
            if (to_sqs.getSelectStatement() != null) {
                to_sqs.getSelectStatement().setSelectQualifier("DISTINCT");
            }
            soc = null;
        } else {
            soc.setSetClause(this.SetClause);
        }
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        soc.setObjectContext(this.context);
        WhereExpression we = new WhereExpression();
        WhereItem wi = new WhereItem();
        SelectQueryStatement sqs = this.query_statement.toSybaseSelect();
        sqs.setObjectContext(this.context);
        we.setObjectContext(this.context);
        wi.setObjectContext(this.context);
        soc.setSelectQueryStatement(sqs);
        soc.setOpenBrace(this.OpenBrace);
        soc.setCloseBrace(this.CloseBrace);
        if (!this.SetClause.equalsIgnoreCase("UNION") && !this.SetClause.equalsIgnoreCase("UNION ALL")) {
            if (this.SetClause.equalsIgnoreCase("INTERSECT") | this.SetClause.equalsIgnoreCase("INTERSECT ALL")) {
                wi.setOperator("EXISTS");
            } else {
                wi.setOperator("NOT EXISTS");
                Vector query_statementFromTableList = sqs.getFromClause().getFromItemList();
                int qListSize = query_statementFromTableList.size();
                for (int qi = 0; qi < qListSize; ++qi) {
                    FromTable fromTableObj = (FromTable)query_statementFromTableList.get(qi);
                    if (fromTableObj.getAliasName() != null && !fromTableObj.getAliasName().equalsIgnoreCase(" ")) continue;
                    fromTableObj.setAliasName("ADV_INNER_ALIAS_" + qi);
                }
            }
            if (sqs.getWhereExpression() != null && !sqs.getWhereExpression().toString().trim().equals("")) {
                sqs.getWhereExpression().addOperator("AND");
                sqs.getWhereExpression().addWhereExpression(this.createWhereExp(to_sqs, sqs));
            } else {
                sqs.setWhereExpression(this.createWhereExp(to_sqs, sqs));
            }
            wi.setRightWhereSubQuery(sqs);
            we.addWhereItem(wi);
            if (to_sqs.getWhereExpression() != null && !to_sqs.getWhereExpression().toString().trim().equals("")) {
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereExpression(we);
            } else {
                to_sqs.setWhereExpression(we);
            }
            if (to_sqs.getSelectStatement() != null) {
                to_sqs.getSelectStatement().setSelectQualifier("DISTINCT");
            }
            soc = null;
        } else {
            soc.setSetClause(this.SetClause);
        }
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        WhereExpression we = new WhereExpression();
        WhereItem wi = new WhereItem();
        SelectQueryStatement sqs = this.query_statement.toInformixSelect();
        soc.setSelectQueryStatement(sqs);
        soc.setOpenBrace(this.OpenBrace);
        soc.setCloseBrace(this.CloseBrace);
        if (!this.SetClause.equalsIgnoreCase("UNION") && !this.SetClause.equalsIgnoreCase("UNION ALL")) {
            if (sqs.getWhereExpression() != null && !sqs.getWhereExpression().toString().trim().equals("")) {
                sqs.getWhereExpression().addOperator("AND");
                sqs.getWhereExpression().addWhereExpression(this.createWhereExp(to_sqs, sqs));
            } else {
                sqs.setWhereExpression(this.createWhereExp(to_sqs, sqs));
            }
            if (this.SetClause.equalsIgnoreCase("INTERSECT") | this.SetClause.equalsIgnoreCase("INTERSECT ALL")) {
                wi.setOperator("EXISTS");
            } else {
                wi.setOperator("NOT EXISTS");
            }
            wi.setRightWhereSubQuery(sqs);
            we.addWhereItem(wi);
            if (to_sqs.getWhereExpression() != null && !to_sqs.getWhereExpression().toString().trim().equals("")) {
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereExpression(we);
            } else {
                to_sqs.setWhereExpression(we);
            }
            if (to_sqs.getSelectStatement() != null) {
                to_sqs.getSelectStatement().setSelectQualifier("DISTINCT");
            }
            soc = null;
        } else {
            soc.setSetClause(this.SetClause);
        }
        this.checkSetOperator = true;
        return soc;
    }

    public SetOperatorClause toTimesTenSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        throw new ConvertException("\nUnsupported SQL in TimesTen 5.1.21\n");
    }

    public SetOperatorClause toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SetOperatorClause soc = new SetOperatorClause();
        soc.setOpenBrace(this.OpenBrace);
        if (this.SetClause.equalsIgnoreCase("MINUS")) {
            soc.setSetClause("EXCEPT");
        } else {
            soc.setSetClause(this.SetClause);
        }
        soc.setSelectQueryStatement(this.query_statement.toNetezzaSelect());
        soc.setCloseBrace(this.CloseBrace);
        this.checkSetOperator = true;
        return soc;
    }

    public WhereExpression createWhereExp(SelectQueryStatement to_sqs, SelectQueryStatement sqs) throws ConvertException {
        Vector v_sil = to_sqs.getSelectStatement().getSelectItemList();
        Vector v_scsil = sqs.getSelectStatement().getSelectItemList();
        Vector v_fil = new Vector();
        Vector v_scfil = new Vector();
        String t_name = null;
        String t_scname = null;
        if (to_sqs.getFromClause() != null) {
            v_fil = to_sqs.getFromClause().getFromItemList();
        }
        if (this.query_statement.getFromClause() != null) {
            v_scfil = sqs.getFromClause().getFromItemList();
        }
        if (v_sil.size() != v_scsil.size()) {
            throw new ConvertException("incorrect number of columns");
        }
        FromTable ft_i = (FromTable)v_fil.elementAt(0);
        FromTable ft_sci = (FromTable)v_scfil.elementAt(0);
        if (ft_i.getAliasName() != null) {
            t_name = ft_i.getAliasName();
        } else if (ft_i.getTableName() instanceof String) {
            t_name = (String)ft_i.getTableName();
        }
        if (ft_sci.getAliasName() != null) {
            t_scname = ft_sci.getAliasName();
        } else if (ft_sci.getTableName() instanceof String) {
            t_scname = (String)ft_sci.getTableName();
        }
        WhereExpression we = new WhereExpression();
        for (int i_count = 0; i_count < v_sil.size(); ++i_count) {
            Vector containsSelectColumn;
            WhereColumn wc_new;
            SelectColumn sc;
            WhereItem wi = new WhereItem();
            Vector v_lwi = new Vector();
            if (v_sil.elementAt(i_count) instanceof SelectColumn) {
                sc = (SelectColumn)v_sil.get(i_count);
                if (sc.toString().indexOf(".") != -1) {
                    wc_new = new WhereColumn();
                    containsSelectColumn = sc.getColumnExpression();
                    wc_new.setColumnExpression(containsSelectColumn);
                    wi.setLeftWhereExp(wc_new);
                } else {
                    wc_new = this.createColumn((SelectColumn)v_sil.elementAt(i_count), t_name);
                    wi.setLeftWhereExp(wc_new);
                }
            }
            if (v_scsil.elementAt(i_count) instanceof SelectColumn) {
                sc = (SelectColumn)v_scsil.get(i_count);
                if (sc.toString().indexOf(".") != -1) {
                    wc_new = new WhereColumn();
                    containsSelectColumn = sc.getColumnExpression();
                    wc_new.setColumnExpression(containsSelectColumn);
                    wi.setRightWhereExp(wc_new);
                } else {
                    wc_new = this.createColumn((SelectColumn)v_scsil.elementAt(i_count), t_scname);
                    wi.setRightWhereExp(wc_new);
                }
            }
            wi.setOperator("=");
            if (i_count == v_sil.size() - 1) {
                we.addWhereItem(wi);
                continue;
            }
            we.addWhereItem(wi);
            we.addOperator("AND");
        }
        return we;
    }

    public WhereColumn createColumn(SelectColumn sc, String tn) {
        Vector v_ce = sc.getColumnExpression();
        WhereColumn wc_new = new WhereColumn();
        Vector<Object> v_nce = new Vector<Object>();
        for (int i_count = 0; i_count < v_ce.size(); ++i_count) {
            if (v_ce.elementAt(i_count) instanceof String) {
                String st = tn + "." + (String)v_ce.elementAt(i_count);
                v_nce.addElement(st);
                continue;
            }
            if (v_ce.elementAt(i_count) instanceof TableColumn) {
                TableColumn tc = (TableColumn)v_ce.elementAt(i_count);
                tc.setTableName(tn);
                v_nce.addElement(tc);
                continue;
            }
            if (v_ce.elementAt(i_count) instanceof FunctionCalls) {
                FunctionCalls fc = (FunctionCalls)v_ce.elementAt(i_count);
                TableColumn tc = fc.getFunctionName();
                if (tc != null) {
                    tc.setTableName(tn);
                }
                v_nce.addElement(fc);
                continue;
            }
            v_nce.addElement(this.createColumn((SelectColumn)v_ce.elementAt(i_count), tn));
        }
        wc_new.setColumnExpression(v_nce);
        return wc_new;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.whereExpression != null) {
            sb.append("  WHERE  " + this.whereExpression);
        }
        for (int i = 0; i < SelectQueryStatement.beautyTabCount; ++i) {
            sb.append("\t");
        }
        if (this.commentObj != null) {
            sb.append(this.commentObj.toString().trim() + " ");
        }
        sb.append(this.SetClause.toUpperCase());
        if (this.OpenBrace != null) {
            sb.append(" " + this.OpenBrace);
        }
        sb.append("\n ");
        this.query_statement.setObjectContext(this.context);
        sb.append(this.query_statement.toString());
        if (this.CloseBrace != null) {
            sb.append(this.CloseBrace);
        }
        return sb.toString();
    }
}

