/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.SwisSQLStatement;
import com.adventnet.swissqlapi.sql.statement.create.CharacterClass;
import com.adventnet.swissqlapi.sql.statement.create.Datatype;
import com.adventnet.swissqlapi.sql.statement.select.CaseStatement;
import com.adventnet.swissqlapi.sql.statement.select.FromClause;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.IntoStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhenStatement;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import com.adventnet.swissqlapi.sql.statement.update.TableClause;
import com.adventnet.swissqlapi.sql.statement.update.TableExpression;
import com.adventnet.swissqlapi.sql.statement.update.TableObject;
import com.adventnet.swissqlapi.sql.statement.update.UpdateQueryStatement;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.database.MetadataInfoUtil;
import com.adventnet.swissqlapi.util.misc.CastingUtil;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import com.adventnet.swissqlapi.util.misc.StringFunctions;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class SelectColumn {
    private String OpenBrace;
    private Vector columnExpression;
    private String CloseBrace;
    private String aliasName;
    private String isAS;
    private String endsWith;
    private UserObjectContext context = null;
    private String targetDataType = null;
    private String targetDataTypeWithSize = null;
    private TableColumn corrTableColumn = null;
    private boolean insideDecodeFunction = false;
    private boolean leftTableColProcessed = false;
    private boolean rightTableColProcessed = false;
    private boolean isSelectColFromUQS = false;
    private boolean inArithmeticExpr;
    private CommentClass commentObj;
    private UpdateQueryStatement fromUQS;
    private boolean isDateAddition = false;
    private Hashtable originalTableNameList = null;
    private boolean isOrderItem = false;
    private String parentFunction = null;
    private String aliasForExpression;
    private boolean teradataUnionCastingDone = false;
    private String ignoreNulls;
    private boolean outerJoin = false;

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public UserObjectContext getObjectContext() {
        return this.context;
    }

    public void setColumnExpression(Vector v_cn) {
        this.columnExpression = v_cn;
    }

    public void addColumnExpressionElement(Object o) {
        this.columnExpression.addElement(o);
    }

    public void setAliasName(String an) {
        this.aliasName = an;
    }

    public void setIsAS(String as) {
        this.isAS = as;
    }

    public void setEndsWith(String ew) {
        this.endsWith = ew;
    }

    public void setOpenBrace(String s_ob) {
        this.OpenBrace = s_ob;
    }

    public String getOpenBrace() {
        return this.OpenBrace;
    }

    public void setCloseBrace(String s_cb) {
        this.CloseBrace = s_cb;
    }

    public String getCloseBrace() {
        return this.CloseBrace;
    }

    public void setInsideDecodeFunction(boolean bool) {
        this.insideDecodeFunction = bool;
    }

    public void setOriginalTableNamesForUpdateSetClause(Hashtable tableList) {
        this.originalTableNameList = tableList;
    }

    public Hashtable getOriginalTableNamesForUpdateSetClause() {
        return this.originalTableNameList;
    }

    public boolean getInsideDecodeFunction() {
        return this.insideDecodeFunction;
    }

    public void setInArithmeticExpression(boolean inArithmeticExpr) {
        this.inArithmeticExpr = inArithmeticExpr;
    }

    public boolean getInArithmeticExpression() {
        return this.inArithmeticExpr;
    }

    public void setCorrespondingTableColumn(TableColumn corrTableColumn) {
        this.corrTableColumn = corrTableColumn;
        if (corrTableColumn != null) {
            this.targetDataTypeWithSize = MetadataInfoUtil.getTargetDataTypeForColumn(corrTableColumn);
            this.targetDataType = CastingUtil.getDataType(this.targetDataTypeWithSize);
        }
    }

    public TableColumn getCorrespondingTableColumn() {
        return this.corrTableColumn;
    }

    public void setTargetDataType(String targetDataType) {
        this.targetDataType = targetDataType;
    }

    public String getTargetDataType() {
        return this.targetDataType;
    }

    public void setSelectColFromUQSSetExpression(boolean isSelectColFromUQS) {
        this.isSelectColFromUQS = isSelectColFromUQS;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public void setFromUQS(UpdateQueryStatement fromUQS) {
        this.fromUQS = fromUQS;
    }

    public void setIsOrderItem(boolean isOrderItem) {
        this.isOrderItem = isOrderItem;
    }

    public void setAliasForExpression(String aliasForExpr) {
        this.aliasForExpression = aliasForExpr;
    }

    public void setTeradataUnionCastingDone(boolean boolVal) {
        this.teradataUnionCastingDone = boolVal;
    }

    public void setIgnoreNulls(String ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public boolean getSelectColFromUQSSetExpression() {
        return this.isSelectColFromUQS;
    }

    public Vector getColumnExpression() {
        return this.columnExpression;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getIsAS() {
        return this.isAS;
    }

    public String getEndsWith() {
        return this.endsWith;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public String getAliasForExpression() {
        return this.aliasForExpression;
    }

    public boolean isTeradataUnionCastingDone() {
        return this.teradataUnionCastingDone;
    }

    public String getIgnoreNulls() {
        return this.ignoreNulls;
    }

    public SelectColumn toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectColumn sc = new SelectColumn();
        sc.setCommentClass(this.commentObj);
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        int sql_dialect = 0;
        boolean isDualTable = false;
        if (from_sqs != null) {
            FromTable fromTable;
            from_sqs.getSQLDialect();
            FromClause fromClause = from_sqs.getFromClause();
            if (fromClause != null && (fromTable = fromClause.getFromTablefromTheVector()) != null && fromTable.getTableName() instanceof String) {
                String fromTableName = (String)fromTable.getTableName();
                if ((fromTableName = fromTableName.trim()).equalsIgnoreCase("DUAL")) {
                    isDualTable = true;
                }
            }
        }
        String[] keywords = null;
        if (SwisSQLUtils.getKeywords(2) != null) {
            keywords = SwisSQLUtils.getKeywords(2);
        }
        sc.setOpenBrace(this.OpenBrace);
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                TableColumn tc = (TableColumn)this.columnExpression.elementAt(i);
                tc.setObjectContext(this.context);
                if (tc.getColumnName() != null) {
                    String column_Name = tc.getColumnName();
                    if (column_Name.trim().length() > 0 && !isDualTable) {
                        if (!SwisSQLOptions.TSQLQuotedIdentifier && column_Name.trim().startsWith("\"") && column_Name.trim().endsWith("\"")) {
                            String temp = column_Name.substring(1, column_Name.length() - 1);
                            if (temp.indexOf("'") != -1) {
                                temp = temp.replaceAll("'", "\"");
                            }
                            column_Name = "'" + temp + "'";
                        }
                        if (!column_Name.trim().equalsIgnoreCase("USER")) {
                            column_Name = CustomizeUtil.objectNamesToBracedIdentifier(column_Name, keywords, null);
                        }
                    }
                    tc.setColumnName(column_Name);
                }
                v_ce.addElement(tc.toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                if (((FunctionCalls)this.columnExpression.elementAt(i)).getFunctionName() == null) {
                    v_ce.addElement((FunctionCalls)this.columnExpression.elementAt(i));
                    continue;
                }
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof WhereColumn) {
                v_ce.addElement(((WhereColumn)this.columnExpression.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof WhereItem) {
                v_ce.addElement(((WhereItem)this.columnExpression.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toMSSQLServerSelect());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                    v_ce.addElement("CURRENT_TIME");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                    v_ce.addElement("GETDATE()");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT")) {
                    v_ce.addElement("GETDATE()");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                    v_ce.addElement("CURRENT_TIMESTAMP");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("SYS_GUID")) {
                    v_ce.addElement("NEWID()");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("SYSDATE")) {
                    v_ce.addElement("GETDATE()");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**")) {
                    this.createPowerFunction(v_ce, this.columnExpression, i, true);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                    throw new ConvertException();
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    FunctionCalls fc = (FunctionCalls)v_ce.get(v_ce.size() - 1);
                    v_ce.setElementAt(fc.toMSSQLServerSelect(to_sqs, from_sqs), v_ce.size() - 1);
                    continue;
                }
                if (s_ce.trim().equals(":=")) {
                    v_ce.addElement("=");
                    continue;
                }
                if (s_ce.startsWith(":")) {
                    if (s_ce.substring(0, 2) != null && !s_ce.substring(0, 2).equalsIgnoreCase("::")) {
                        v_ce.addElement("@" + s_ce.substring(1));
                        continue;
                    }
                    this.createCastFunction(v_ce, this.columnExpression, i);
                    Object object = v_ce.get(v_ce.size() - 1);
                    if (!(object instanceof FunctionCalls)) continue;
                    v_ce.set(v_ce.size() - 1, ((FunctionCalls)object).toMSSQLServerSelect(to_sqs, from_sqs));
                    continue;
                }
                if (s_ce.equalsIgnoreCase("/")) {
                    v_ce.addElement("/");
                    if (this.columnExpression.elementAt(i + 1) instanceof SelectColumn) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((SelectColumn)this.columnExpression.elementAt(i + 1)).toMSSQLServerSelect(to_sqs, from_sqs) + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((TableColumn)this.columnExpression.elementAt(i + 1)).toMSSQLServerSelect(to_sqs, from_sqs) + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof FunctionCalls) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((FunctionCalls)this.columnExpression.elementAt(i + 1)).toMSSQLServerSelect(to_sqs, from_sqs) + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof CaseStatement) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((CaseStatement)this.columnExpression.elementAt(i + 1)).toMSSQLServerSelect(to_sqs, from_sqs) + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof SelectQueryStatement) {
                        v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i + 1)).toMSSQLServerSelect());
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof String) {
                        s_ce = (String)this.columnExpression.elementAt(i + 1);
                        if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                            v_ce.addElement("CONVERT(FLOAT, CURRENT_TIME)");
                        } else if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                            v_ce.addElement("CONVERT(FLOAT, CURRENT_DATE)");
                        } else if (s_ce.equalsIgnoreCase("CURRENT")) {
                            v_ce.addElement("CONVERT(FLOAT, CURRENT_DATE)");
                        } else if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                            v_ce.addElement("CONVERT(FLOAT, CURRENT_TIMESTAMP)");
                        } else if (s_ce.equalsIgnoreCase("SYS_GUID")) {
                            v_ce.addElement("CONVERT(FLOAT, NEWID())");
                        } else if (s_ce.equalsIgnoreCase("SYSDATE")) {
                            v_ce.addElement("CONVERT(FLOAT, GETDATE())");
                        } else if (s_ce.equalsIgnoreCase("**") || s_ce.equalsIgnoreCase("^")) {
                            this.createPowerFunction(v_ce, this.columnExpression, i + 1, true);
                        } else {
                            if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                                throw new ConvertException();
                            }
                            if (s_ce.equalsIgnoreCase("IS")) {
                                throw new ConvertException();
                            }
                            if (s_ce.startsWith(":")) {
                                v_ce.addElement("@" + s_ce.substring(1));
                            } else {
                                v_ce.addElement("CONVERT(FLOAT, " + s_ce + ")");
                            }
                        }
                        ++i;
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("||")) {
                        v_ce.addElement("+");
                        ++i;
                        continue;
                    }
                    v_ce.addElement("CONVERT(FLOAT, " + this.columnExpression.elementAt(i + 1) + ")");
                    ++i;
                    continue;
                }
                if (s_ce.equalsIgnoreCase("||")) {
                    this.checkConcatenationString(v_ce, this.columnExpression, i, 2);
                    v_ce.addElement("+");
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        sc.setAliasName(this.aliasName);
        return sc;
    }

    public SelectColumn toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        Vector fromSelectItems;
        SelectStatement fromSS;
        SelectColumn sc = new SelectColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        int sql_dialect = 0;
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        sc.setOpenBrace(this.OpenBrace);
        sc.setObjectContext(this.context);
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                ((TableColumn)this.columnExpression.elementAt(i)).setObjectContext(this.context);
                v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i)).toSybaseSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                ((FunctionCalls)this.columnExpression.elementAt(i)).setObjectContext(this.context);
                if (((FunctionCalls)this.columnExpression.elementAt(i)).getFunctionName() == null) {
                    v_ce.addElement((FunctionCalls)this.columnExpression.elementAt(i));
                    continue;
                }
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toSybaseSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toSybaseSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                ((CaseStatement)this.columnExpression.elementAt(i)).setObjectContext(this.context);
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toSybaseSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toSybaseSelect());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                    v_ce.addElement("CURRENT_TIME");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                    v_ce.addElement("GETDATE()");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT")) {
                    v_ce.addElement("GETDATE()");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                    v_ce.addElement("CURRENT_TIMESTAMP");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("SYS_GUID")) {
                    v_ce.addElement("NEWID()");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("SYSDATE")) {
                    v_ce.addElement("GETDATE()");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                    this.createPowerFunction(v_ce, this.columnExpression, i, true);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                    throw new ConvertException();
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    FunctionCalls fc = (FunctionCalls)v_ce.get(v_ce.size() - 1);
                    v_ce.setElementAt(fc.toSybaseSelect(to_sqs, from_sqs), v_ce.size() - 1);
                    continue;
                }
                if (s_ce.startsWith(":")) {
                    v_ce.addElement("@" + s_ce.substring(1));
                    continue;
                }
                if (s_ce.equalsIgnoreCase("/")) {
                    v_ce.addElement("/");
                    if (this.columnExpression.elementAt(i + 1) instanceof SelectColumn) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((SelectColumn)this.columnExpression.elementAt(i + 1)).toSybaseSelect(to_sqs, from_sqs) + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((TableColumn)this.columnExpression.elementAt(i + 1)).toSybaseSelect(to_sqs, from_sqs) + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof FunctionCalls) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((FunctionCalls)this.columnExpression.elementAt(i + 1)).toSybaseSelect(to_sqs, from_sqs) + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof CaseStatement) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((CaseStatement)this.columnExpression.elementAt(i + 1)).toSybaseSelect(to_sqs, from_sqs) + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof SelectQueryStatement) {
                        v_ce.addElement("CONVERT(FLOAT, " + ((SelectQueryStatement)this.columnExpression.elementAt(i + 1)).toSybaseSelect() + ")");
                        ++i;
                        continue;
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof String) {
                        s_ce = (String)this.columnExpression.elementAt(i + 1);
                        if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                            v_ce.addElement("CONVERT(FLOAT, CURRENT_TIME)");
                        } else if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                            v_ce.addElement("CONVERT(FLOAT, CURRENT_DATE)");
                        } else if (s_ce.equalsIgnoreCase("CURRENT")) {
                            v_ce.addElement("CONVERT(FLOAT, CURRENT_DATE)");
                        } else if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                            v_ce.addElement("CONVERT(FLOAT, CURRENT_TIMESTAMP)");
                        } else if (s_ce.equalsIgnoreCase("SYS_GUID")) {
                            v_ce.addElement("CONVERT(FLOAT, NEWID())");
                        } else if (s_ce.equalsIgnoreCase("SYSDATE")) {
                            v_ce.addElement("CONVERT(FLOAT, GETDATE())");
                        } else if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                            this.createPowerFunction(v_ce, this.columnExpression, i + 1, true);
                        } else {
                            if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                                throw new ConvertException();
                            }
                            if (s_ce.equalsIgnoreCase("IS")) {
                                throw new ConvertException();
                            }
                            if (s_ce.startsWith(":")) {
                                v_ce.addElement("@" + s_ce.substring(1));
                            } else {
                                v_ce.addElement("CONVERT(FLOAT, " + s_ce + ")");
                            }
                        }
                        ++i;
                        continue;
                    }
                    if (s_ce.equalsIgnoreCase("||")) {
                        v_ce.addElement("+");
                        ++i;
                        continue;
                    }
                    v_ce.addElement("CONVERT(FLOAT, " + this.columnExpression.elementAt(i + 1) + ")");
                    ++i;
                    continue;
                }
                if (s_ce.equalsIgnoreCase("||")) {
                    v_ce.addElement("+");
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        if (from_sqs != null && (fromSS = from_sqs.getSelectStatement()) != null && this.aliasName != null && (fromSelectItems = fromSS.getSelectItemList()) != null) {
            for (int l = 0; l < fromSelectItems.size(); ++l) {
                String colName;
                Object obj1;
                Object obj = fromSelectItems.get(l);
                if (!(obj instanceof SelectColumn) || obj.equals(this)) continue;
                Vector colExpr = ((SelectColumn)obj).getColumnExpression();
                String currAliasName = ((SelectColumn)obj).getAliasName();
                if (colExpr == null || colExpr.size() != 1 || !((obj1 = colExpr.get(0)) instanceof TableColumn) || (colName = ((TableColumn)obj1).getColumnName()) == null || !colName.equals(this.aliasName) || currAliasName != null && (currAliasName == null || !currAliasName.equals(this.aliasName))) continue;
                this.aliasName = this.aliasName + "_ADV";
                break;
            }
        }
        sc.setAliasName(this.aliasName);
        return sc;
    }

    public SelectColumn toTimesTenSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectColumn sc = new SelectColumn();
        sc.setCommentClass(this.commentObj);
        if (this.commentObj != null) {
            this.commentObj.setSQLDialect(10);
        }
        int sql_dialect = 0;
        if (from_sqs != null) {
            sql_dialect = from_sqs.getSQLDialect();
        }
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        sc.setOpenBrace(this.OpenBrace);
        this.handleTableColumn(this.columnExpression, from_sqs, 10);
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            Object temp;
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                TableColumn tc = (TableColumn)this.columnExpression.elementAt(i);
                tc.setObjectContext(this.context);
                v_ce.addElement(tc.toTimesTenSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                ((FunctionCalls)this.columnExpression.elementAt(i)).setObjectContext(this.context);
                FunctionCalls fcs = (FunctionCalls)this.columnExpression.elementAt(i);
                if (fcs.toString().trim().toLowerCase().startsWith("user_name(")) {
                    v_ce.addElement("USER");
                    continue;
                }
                FunctionCalls temp2 = fcs.toTimesTenSelect(to_sqs, from_sqs);
                v_ce.addElement(temp2);
                this.columnExpression.setElementAt(temp2, i);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                temp = ((SelectColumn)this.columnExpression.elementAt(i)).toTimesTenSelect(to_sqs, from_sqs);
                v_ce.addElement(temp);
                this.columnExpression.setElementAt(temp, i);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                throw new ConvertException("\nCASE statements are not supported in TimesTen 5.1.21\n");
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                temp = ((SelectQueryStatement)this.columnExpression.elementAt(i)).toTimesTenSelect();
                v_ce.addElement(temp);
                this.columnExpression.setElementAt(temp, i);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                    v_ce.addElement("TO_CHAR(SYSDATE,'HH:MI:SS')");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                    v_ce.addElement("SYSDATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) continue;
                if (s_ce.equalsIgnoreCase("CURRENT")) {
                    v_ce.addElement("SYSDATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("%")) {
                    this.createModFunction(v_ce, this.columnExpression, i);
                    continue;
                }
                if (s_ce.trim().startsWith("$")) {
                    try {
                        String dollarString = s_ce.substring(1);
                        float numericValue = Float.parseFloat(dollarString);
                        v_ce.addElement(dollarString);
                    }
                    catch (NumberFormatException e) {
                        v_ce.addElement(s_ce);
                    }
                    continue;
                }
                if (s_ce.equalsIgnoreCase("::") || s_ce.equalsIgnoreCase("**") || s_ce.equalsIgnoreCase("IS")) continue;
                if (s_ce.equalsIgnoreCase("=")) {
                    if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.startsWith("@")) {
                    v_ce.addElement(":" + s_ce.substring(1));
                    continue;
                }
                if (s_ce.equalsIgnoreCase("+") || s_ce.equalsIgnoreCase("||")) {
                    String dtype;
                    String newStr = null;
                    if (i - 1 >= 0 && this.columnExpression.elementAt(i - 1).toString().trim().startsWith("'")) {
                        newStr = this.columnExpression.elementAt(i - 1).toString();
                        if (newStr.equalsIgnoreCase("''") && SwisSQLOptions.fromSybase) {
                            newStr = "' '";
                        }
                        if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                            v_ce.remove(v_ce.size() - 1);
                            v_ce.addElement(this.concatFunction(newStr, this.columnExpression.elementAt(i + 1), to_sqs, from_sqs));
                            this.columnExpression.remove(i + 1);
                            continue;
                        }
                        if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1) instanceof String && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                            if (this.columnExpression.elementAt(i + 1).toString().equalsIgnoreCase("''") && SwisSQLOptions.fromSybase) {
                                this.columnExpression.setElementAt("' '", i + 1);
                            }
                            v_ce.remove(v_ce.size() - 1);
                            v_ce.addElement(this.concatFunction(newStr, this.columnExpression.elementAt(i + 1), to_sqs, from_sqs));
                            this.columnExpression.remove(i + 1);
                            continue;
                        }
                        if (from_sqs != null) {
                            if (from_sqs.getFromClause() == null && i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                                if (this.columnExpression.elementAt(i + 1).toString().equalsIgnoreCase("''") && SwisSQLOptions.fromSybase) {
                                    this.columnExpression.setElementAt("' '", i + 1);
                                }
                                v_ce.remove(v_ce.size() - 1);
                                v_ce.addElement(this.concatFunction(newStr, this.columnExpression.elementAt(i + 1), to_sqs, from_sqs));
                                this.columnExpression.remove(i + 1);
                                continue;
                            }
                            v_ce.addElement(s_ce);
                            continue;
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                        newStr = this.columnExpression.elementAt(i + 1).toString();
                        if (newStr.equalsIgnoreCase("''") && SwisSQLOptions.fromSybase) {
                            newStr = "' '";
                        }
                        if (v_ce.size() > 0 && v_ce.lastElement() instanceof FunctionCalls && ((FunctionCalls)v_ce.get(v_ce.size() - 1)).getFunctionName().getColumnName().equalsIgnoreCase("CONCAT")) {
                            v_ce.addElement(this.concatFunction(v_ce.lastElement(), newStr, to_sqs, from_sqs));
                            v_ce.remove(v_ce.size() - 2);
                            this.columnExpression.remove(i + 1);
                            continue;
                        }
                        if (i - 1 >= 0 && this.columnExpression.elementAt(i - 1) instanceof TableColumn) {
                            v_ce.remove(v_ce.size() - 1);
                            v_ce.addElement(this.concatFunction(this.columnExpression.elementAt(i - 1), newStr, to_sqs, from_sqs));
                            this.columnExpression.remove(i + 1);
                            continue;
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (i - 1 >= 0 && this.columnExpression.elementAt(i - 1) instanceof TableColumn) {
                        dtype = MetadataInfoUtil.getDatatypeName(from_sqs, (TableColumn)this.columnExpression.elementAt(i - 1));
                        if (dtype != null && dtype.toLowerCase().indexOf("char") != -1) {
                            v_ce.remove(v_ce.size() - 1);
                            v_ce.addElement(this.concatFunction(this.columnExpression.elementAt(i - 1), this.columnExpression.elementAt(i + 1), to_sqs, from_sqs));
                            this.columnExpression.remove(i + 1);
                            continue;
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                        dtype = MetadataInfoUtil.getDatatypeName(from_sqs, (TableColumn)this.columnExpression.elementAt(i + 1));
                        if (v_ce.size() > 0 && v_ce.lastElement() instanceof FunctionCalls && ((FunctionCalls)v_ce.get(v_ce.size() - 1)).getFunctionName().getColumnName().equalsIgnoreCase("CONCAT")) {
                            v_ce.addElement(this.concatFunction(v_ce.lastElement(), this.columnExpression.elementAt(i + 1), to_sqs, from_sqs));
                            v_ce.remove(v_ce.size() - 2);
                            this.columnExpression.remove(i + 1);
                            continue;
                        }
                        if (dtype != null && dtype.toLowerCase().indexOf("char") != -1) {
                            v_ce.remove(v_ce.size() - 1);
                            v_ce.addElement(this.concatFunction(this.columnExpression.elementAt(i - 1), this.columnExpression.elementAt(i + 1), to_sqs, from_sqs));
                            this.columnExpression.remove(i + 1);
                            continue;
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        if (sc != null && sc.getAliasName() == null) {
            if (this.aliasName != null && this.aliasName.charAt(0) == '\'') {
                sc.setAliasName(this.aliasName.replace('\'', '\"'));
            } else if (this.aliasName != null && this.aliasName.startsWith("[")) {
                String tempAlias = this.aliasName.substring(1, this.aliasName.length() - 1);
                if (tempAlias.indexOf(" ") != -1) {
                    sc.setAliasName("\"" + tempAlias + "\"");
                } else {
                    tempAlias = CustomizeUtil.objectNamesToQuotedIdentifier(tempAlias, SwisSQLUtils.getKeywords(10), null, 10);
                    sc.setAliasName(tempAlias);
                }
            } else {
                this.aliasName = CustomizeUtil.objectNamesToQuotedIdentifier(this.aliasName, SwisSQLUtils.getKeywords(10), null, 10);
                sc.setAliasName(this.aliasName);
            }
        }
        return sc;
    }

    public SelectColumn toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectColumn sc = new SelectColumn();
        int sql_dialect = 0;
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        sc.setOpenBrace(this.OpenBrace);
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i)).toNetezzaSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toNetezzaSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toNetezzaSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toNetezzaSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toNetezzaSelect());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.charAt(0) == '\'') {
                    v_ce.addElement(s_ce.replace('\'', '\''));
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**")) {
                    this.createPowerFunction(v_ce, this.columnExpression, i, true);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                    throw new ConvertException();
                }
                if (s_ce.equalsIgnoreCase("=")) {
                    if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    FunctionCalls fc = (FunctionCalls)v_ce.get(v_ce.size() - 1);
                    v_ce.setElementAt(fc.toNetezzaSelect(to_sqs, from_sqs), v_ce.size() - 1);
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        if (sc != null && sc.getAliasName() == null) {
            if (this.aliasName != null && this.aliasName.charAt(0) == '\'') {
                sc.setAliasName(this.aliasName.replace('\'', '\"'));
            } else if (this.aliasName != null && this.aliasName.charAt(0) == '\"') {
                sc.setAliasName(this.aliasName);
            } else if (this.aliasName != null) {
                sc.setAliasName(this.aliasName);
            }
        }
        return sc;
    }

    private FunctionCalls concatFunction(Object firstArg, Object secondArg, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) {
        FunctionCalls concatFC = new FunctionCalls();
        Vector<Object> fnArgs = new Vector<Object>();
        TableColumn tc = new TableColumn();
        tc.setColumnName("CONCAT");
        if (firstArg instanceof TableColumn) {
            firstArg = ((TableColumn)firstArg).toTimesTenSelect(to_sqs, from_sqs);
        }
        if (secondArg instanceof TableColumn) {
            secondArg = ((TableColumn)secondArg).toTimesTenSelect(to_sqs, from_sqs);
        }
        fnArgs.add(firstArg);
        fnArgs.add(secondArg);
        concatFC.setFunctionName(tc);
        concatFC.setFunctionArguments(fnArgs);
        return concatFC;
    }

    public void createPowerFunction(Vector v_ce, Vector columnExpression, int i, boolean isPower) {
        SelectColumn sc_firstarg = new SelectColumn();
        SelectColumn sc_secondarg = new SelectColumn();
        Vector<SelectColumn> v_farg = new Vector<SelectColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        if (isPower) {
            tc.setColumnName("POWER");
        } else {
            tc.setColumnName("POW");
        }
        fc.setFunctionName(tc);
        vec_firstarg.addElement(columnExpression.elementAt(i - 1));
        v_ce.setElementAt(" ", i - 1);
        sc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(sc_firstarg);
        vec_secondarg.addElement(columnExpression.elementAt(i + 1));
        columnExpression.setElementAt(" ", i + 1);
        sc_secondarg.setColumnExpression(vec_secondarg);
        v_farg.addElement(sc_secondarg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
    }

    public void createXOREquivalentFunction(Vector v_ce, Vector columnExpression, int i, boolean isPower, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs, String str2) throws ConvertException {
        SelectColumn sc_firstarg = new SelectColumn();
        SelectColumn sc_secondarg = new SelectColumn();
        SelectColumn sc_thirdarg = new SelectColumn();
        Vector<Object> vec_secondarg = new Vector<Object>();
        v_ce.addElement("(");
        v_ce.addElement("(");
        if (columnExpression.elementAt(i - 1) instanceof TableColumn) {
            v_ce.addElement(((TableColumn)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i - 1) instanceof FunctionCalls) {
            v_ce.addElement(((FunctionCalls)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i - 1) instanceof SelectColumn) {
            v_ce.addElement(((SelectColumn)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i - 1) instanceof CaseStatement) {
            v_ce.addElement(((CaseStatement)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i - 1) instanceof SelectQueryStatement) {
            v_ce.addElement(((SelectQueryStatement)columnExpression.elementAt(i - 1)).toOracleSelect());
        } else {
            v_ce.addElement(columnExpression.elementAt(i - 1));
        }
        v_ce.addElement("+");
        if (columnExpression.elementAt(i + 1) instanceof TableColumn) {
            v_ce.addElement(((TableColumn)columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i + 1) instanceof FunctionCalls) {
            v_ce.addElement(((FunctionCalls)columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i + 1) instanceof SelectColumn) {
            v_ce.addElement(((SelectColumn)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i + 1) instanceof CaseStatement) {
            v_ce.addElement(((CaseStatement)columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i + 1) instanceof SelectQueryStatement) {
            v_ce.addElement(((SelectQueryStatement)columnExpression.elementAt(i + 1)).toOracleSelect());
        } else {
            v_ce.addElement(columnExpression.elementAt(i + 1));
        }
        v_ce.addElement(")");
        v_ce.addElement("-");
        Vector<SelectColumn> v_farg = new Vector<SelectColumn>();
        Vector<Object> vec_firstarg = new Vector<Object>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        tc.setColumnName("BITAND");
        fc.setFunctionName(tc);
        if (columnExpression.elementAt(i - 1) instanceof TableColumn) {
            vec_firstarg.addElement(((TableColumn)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i - 1) instanceof FunctionCalls) {
            vec_firstarg.addElement(((FunctionCalls)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i - 1) instanceof SelectColumn) {
            vec_firstarg.addElement(((SelectColumn)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i - 1) instanceof CaseStatement) {
            vec_firstarg.addElement(((CaseStatement)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i - 1) instanceof SelectQueryStatement) {
            vec_firstarg.addElement(((SelectQueryStatement)columnExpression.elementAt(i - 1)).toOracleSelect());
        } else {
            vec_firstarg.addElement(columnExpression.elementAt(i - 1));
        }
        v_ce.setElementAt(" ", i - 1);
        sc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(sc_firstarg);
        if (columnExpression.elementAt(i + 1) instanceof TableColumn) {
            vec_secondarg.addElement(((TableColumn)columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i + 1) instanceof FunctionCalls) {
            vec_secondarg.addElement(((FunctionCalls)columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i + 1) instanceof SelectColumn) {
            vec_secondarg.addElement(((SelectColumn)columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i + 1) instanceof CaseStatement) {
            vec_secondarg.addElement(((CaseStatement)columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs));
        } else if (columnExpression.elementAt(i + 1) instanceof SelectQueryStatement) {
            vec_secondarg.addElement(((SelectQueryStatement)columnExpression.elementAt(i + 1)).toOracleSelect());
        } else {
            vec_secondarg.addElement(columnExpression.elementAt(i + 1));
        }
        columnExpression.setElementAt(" ", i + 1);
        sc_secondarg.setColumnExpression(vec_secondarg);
        v_farg.addElement(sc_secondarg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
        if (str2.equals("^")) {
            v_ce.addElement("*");
            v_ce.addElement("2");
        }
        v_ce.addElement(")");
    }

    public SelectColumn toANSISelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectColumn sc = new SelectColumn();
        int sql_dialect = 0;
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        sc.setOpenBrace(this.OpenBrace);
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i)).toANSISelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                if (((FunctionCalls)this.columnExpression.elementAt(i)).getFunctionName() == null) {
                    v_ce.addElement((FunctionCalls)this.columnExpression.elementAt(i));
                    continue;
                }
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toANSISelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toANSISelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toANSISelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toANSISelect());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.charAt(0) == '\'' && SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects && FunctionCalls.functionArgsInSingleQuotesToDouble) {
                    v_ce.addElement(s_ce.replace('\'', '\"'));
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**")) {
                    this.createPowerFunction(v_ce, this.columnExpression, i, true);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                    throw new ConvertException();
                }
                if (s_ce.equalsIgnoreCase("=")) {
                    if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    FunctionCalls fc = (FunctionCalls)v_ce.get(v_ce.size() - 1);
                    v_ce.setElementAt(fc.toANSISelect(to_sqs, from_sqs), v_ce.size() - 1);
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        if (sc != null && sc.getAliasName() == null) {
            if (this.aliasName != null && this.aliasName.charAt(0) == '\'' && SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects) {
                sc.setAliasName(this.aliasName.replace('\'', '\"'));
            } else if (this.aliasName != null && this.aliasName.charAt(0) == '\"') {
                sc.setAliasName(this.aliasName);
            } else if (this.aliasName != null && SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects) {
                sc.setAliasName("\"" + this.aliasName + "\"");
            } else if (this.aliasName != null) {
                sc.setAliasName(this.aliasName);
            }
        }
        return sc;
    }

    public SelectColumn toTeradataSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String teradataComment;
        SelectColumn sc = new SelectColumn();
        String teradataComTkn = "/*%SSTD%";
        if (this.commentObj != null && (teradataComment = this.commentObj.toString().trim()).indexOf(teradataComTkn) != -1) {
            sc.setCommentClass(this.commentObj);
            this.commentObj.setComment(teradataComment.substring(teradataComTkn.length(), teradataComment.length() - 2));
            this.commentObj.setSQLDialect(12);
        }
        int sql_dialect = 0;
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        sc.setOpenBrace(this.OpenBrace);
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                TableColumn teradataTCN = ((TableColumn)this.columnExpression.elementAt(i)).toTeradataSelect(to_sqs, from_sqs);
                v_ce.addElement(teradataTCN);
                if (to_sqs == null) continue;
                to_sqs.addTableColumnToTableColumnList(teradataTCN);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                if (((FunctionCalls)this.columnExpression.elementAt(i)).getFunctionName() == null) {
                    v_ce.addElement((FunctionCalls)this.columnExpression.elementAt(i));
                    continue;
                }
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toTeradataSelect());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                String teradataCom = "/*%SSTD%";
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.equalsIgnoreCase("**")) {
                    v_ce.addElement(s_ce);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("+") || s_ce.equalsIgnoreCase("-")) {
                    Object nextObj;
                    FunctionCalls fc;
                    TableColumn tc;
                    v_ce.addElement(s_ce);
                    if (i <= 0 || i >= this.columnExpression.size() - 1) continue;
                    boolean isDateExpr = false;
                    Object obj = this.columnExpression.get(i - 1);
                    if (obj instanceof TableColumn) {
                        if (SwisSQLUtils.getFunctionReturnType(((TableColumn)obj).getColumnName(), null).equalsIgnoreCase("date")) {
                            isDateExpr = true;
                        } else if (CastingUtil.getValueIgnoreCase(SwisSQLAPI.columnDatatypes, ((TableColumn)obj).getColumnName()) != null && CastingUtil.getValueIgnoreCase(SwisSQLAPI.columnDatatypes, ((TableColumn)obj).getColumnName()).toString().equalsIgnoreCase("timestamp")) {
                            isDateExpr = true;
                        }
                    } else if (obj instanceof FunctionCalls && (tc = (fc = (FunctionCalls)obj).getFunctionName()) != null) {
                        Vector args = fc.getFunctionArguments();
                        if (tc != null && SwisSQLUtils.getFunctionReturnType(tc.getColumnName(), args).equalsIgnoreCase("date")) {
                            isDateExpr = true;
                        }
                    }
                    if (!isDateExpr || !((nextObj = this.columnExpression.get(i + 1)) instanceof String)) continue;
                    Vector intervalVector = new Vector();
                    int increaseLoopCount = this.convertNumeralsToInterval(intervalVector, this.columnExpression.subList(i + 1, this.columnExpression.size()));
                    if (intervalVector.size() <= 0) continue;
                    v_ce.addAll(intervalVector);
                    i += increaseLoopCount;
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                    throw new ConvertException();
                }
                if (s_ce.equalsIgnoreCase("=")) {
                    if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    FunctionCalls fc = (FunctionCalls)v_ce.get(v_ce.size() - 1);
                    v_ce.setElementAt(fc.toTeradataSelect(to_sqs, from_sqs), v_ce.size() - 1);
                    continue;
                }
                if (s_ce.indexOf(teradataCom) != -1) {
                    v_ce.addElement(s_ce.substring(teradataCom.length(), s_ce.length() - 2));
                    continue;
                }
                if (s_ce.startsWith("--")) {
                    v_ce.add("/*" + s_ce + "*/");
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            Object otherObj = this.columnExpression.elementAt(i);
            if (otherObj != null && (otherObj.toString().toLowerCase().startsWith("/*+") || otherObj.toString().toUpperCase().indexOf(teradataComTkn) != -1)) {
                if (otherObj.toString().toUpperCase().indexOf(teradataComTkn) != -1) {
                    v_ce.addElement(otherObj.toString().substring(teradataComTkn.length() + 1, otherObj.toString().length() - 2));
                    continue;
                }
                if (this.commentObj == null) {
                    this.commentObj = new CommentClass();
                }
                ArrayList<String> specTokenList = new ArrayList<String>();
                specTokenList.add(otherObj.toString());
                this.commentObj.setSpecialToken(specTokenList);
                sc.setCommentClass(this.commentObj);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        sc.setAliasForExpression(this.aliasForExpression);
        if (this.aliasName != null && this.aliasName.startsWith("[")) {
            String tempAlias = this.aliasName.substring(1, this.aliasName.length() - 1);
            if (tempAlias.indexOf(" ") != -1) {
                sc.setAliasName("\"" + tempAlias + "\"");
            } else {
                tempAlias = CustomizeUtil.objectNamesToQuotedIdentifier(tempAlias, SwisSQLUtils.getKeywords("teradata"), null, -1);
                sc.setAliasName(tempAlias);
            }
        } else if (this.aliasName != null) {
            this.aliasName = CustomizeUtil.objectNamesToQuotedIdentifier(this.aliasName, SwisSQLUtils.getKeywords("teradata"), null, -1);
            sc.setAliasName(this.aliasName);
        }
        return sc;
    }

    public SelectColumn toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        TableColumn tc;
        SelectColumn sc = new SelectColumn();
        int sql_dialect = 0;
        boolean isDate = false;
        boolean openBraceisSet = false;
        boolean concatExpr = false;
        boolean two_or_more_date_column = false;
        int i = 0;
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        sc.setOpenBrace(this.OpenBrace);
        ArrayList<TableColumn> dateColsWithArithExpr = new ArrayList<TableColumn>();
        boolean arithmeticExprAssignedToVar = false;
        boolean arithmeticExpr = false;
        if (this.columnExpression.contains("||")) {
            concatExpr = true;
        }
        block0: for (int j = 0; j < this.columnExpression.size(); ++j) {
            TableColumn tc2;
            String datatype;
            Object o1;
            String datatype2;
            if (!(this.columnExpression.get(j) instanceof String)) continue;
            String str2 = (String)this.columnExpression.get(j);
            if (!(str2 = str2.trim()).equals("*") && !str2.equals("/") && !str2.equals("+") && !str2.equals("-") || j == 0) continue;
            Object o = this.columnExpression.get(j - 1);
            if (o instanceof TableColumn && (datatype2 = MetadataInfoUtil.getDatatypeName(from_sqs, tc = (TableColumn)o)) != null && datatype2.toLowerCase().indexOf("char") != -1 || (o1 = this.columnExpression.get(j + 1)) instanceof TableColumn && (datatype = MetadataInfoUtil.getDatatypeName(from_sqs, tc2 = (TableColumn)o1)) != null && datatype.toLowerCase().indexOf("char") != -1) break;
            if (str2.equals("+")) {
                for (int k = 0; k < this.columnExpression.size(); ++k) {
                    Object obj = this.columnExpression.get(k);
                    if (obj instanceof String) {
                        String temp = obj.toString();
                        if (!temp.startsWith("'") || !temp.endsWith("'")) continue;
                        break block0;
                    }
                    if (!(obj instanceof FunctionCalls)) continue;
                    FunctionCalls fc = (FunctionCalls)obj;
                    TableColumn tc3 = fc.getFunctionName();
                    Vector args = fc.getFunctionArguments();
                    if (tc3 != null && SwisSQLUtils.getFunctionReturnType(tc3.getColumnName(), args).equalsIgnoreCase("string")) break block0;
                }
            }
            arithmeticExpr = true;
            break;
        }
        if (this.targetDataType != null) {
            if (this.targetDataType.toLowerCase().startsWith("varchar")) {
                arithmeticExprAssignedToVar = arithmeticExpr;
            }
            if (!concatExpr && arithmeticExprAssignedToVar && !this.inArithmeticExpr) {
                v_ce.addElement("VARCHAR(CHAR(");
            }
        }
        if (concatExpr && arithmeticExpr) {
            v_ce.addElement("CHAR(");
        }
        for (i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                String dataType;
                TableColumn tc4 = (TableColumn)this.columnExpression.elementAt(i);
                if (tc4.getColumnName() != null) {
                    String table_Name_Str;
                    String column_Name = tc4.getColumnName();
                    if (column_Name.equalsIgnoreCase("INCREMENT_BY")) {
                        column_Name = "INCREMENT";
                        tc4.setColumnName(column_Name);
                    } else if (column_Name.equalsIgnoreCase("NEXTVAL")) {
                        table_Name_Str = tc4.getTableName();
                        if (table_Name_Str != null && !table_Name_Str.equals("")) {
                            tc4.setTableName("NEXTVAL FOR ");
                            tc4.setColumnName(table_Name_Str);
                        } else {
                            tc4.setColumnName("NEXTVAL");
                        }
                    } else if (column_Name.equalsIgnoreCase("CURRVAL")) {
                        table_Name_Str = tc4.getTableName();
                        tc4.setTableName("PREVVAL FOR ");
                        tc4.setColumnName(table_Name_Str);
                    }
                }
                if ((dataType = MetadataInfoUtil.getDatatypeName(from_sqs, tc4)) == null && SwisSQLAPI.variableDatatypeMapping != null) {
                    dataType = (String)CastingUtil.getValueIgnoreCase(SwisSQLAPI.variableDatatypeMapping, tc4.getResultString());
                }
                if (dataType != null && (dataType.trim().toLowerCase().indexOf("date") != -1 || dataType.trim().toLowerCase().indexOf("timestamp") != -1 || dataType.toLowerCase().indexOf("time") != -1)) {
                    isDate = true;
                    dateColsWithArithExpr.add(tc4);
                    this.addInDateColsIfPrevFnCall(v_ce, dateColsWithArithExpr);
                }
                if (!isDate) {
                    if (arithmeticExpr || this.inArithmeticExpr) {
                        if (this.targetDataType == null) {
                            tc4.setTargetDataType("DOUBLE");
                        } else if (!(this.targetDataType == null || this.targetDataType.equalsIgnoreCase("varchar") && this.targetDataType.equalsIgnoreCase("char"))) {
                            tc4.setTargetDataType("DOUBLE");
                        } else {
                            tc4.setTargetDataType(this.targetDataType);
                        }
                    } else {
                        tc4.setTargetDataType(this.targetDataType);
                    }
                }
                v_ce.addElement(tc4.toDB2Select(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                String dType;
                FunctionCalls fc = (FunctionCalls)this.columnExpression.elementAt(i);
                fc.setTargetDataType(this.targetDataType);
                TableColumn tc5 = fc.getFunctionName();
                if (tc5 != null && (tc5.getColumnName().equalsIgnoreCase("TO_DATE") || tc5.getColumnName().equalsIgnoreCase("ORACLE_TO_DATE"))) {
                    isDate = true;
                }
                if (arithmeticExpr && !isDate || this.inArithmeticExpr && !isDate) {
                    fc.setInArithmeticExpression(true);
                }
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toDB2Select(to_sqs, from_sqs));
                if (tc5 == null || !tc5.getColumnName().equalsIgnoreCase("NVL") || (dType = this.getReturnDataTypeForCoalesce(fc, "NVL", to_sqs, from_sqs)) == null || !dType.equalsIgnoreCase("timestamp") && !dType.equalsIgnoreCase("date")) continue;
                isDate = true;
                dateColsWithArithExpr.add((TableColumn)v_ce.get(v_ce.size() - 1));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                if (arithmeticExpr) {
                    ((SelectColumn)this.columnExpression.elementAt(i)).setInArithmeticExpression(true);
                }
                ((SelectColumn)this.columnExpression.elementAt(i)).setCorrespondingTableColumn(this.corrTableColumn);
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toDB2Select(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toDB2Select(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toDB2Select());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                this.rightTableColProcessed = false;
                this.leftTableColProcessed = false;
                if (s_ce.equalsIgnoreCase("||")) {
                    if (!arithmeticExpr) {
                        String sourceDataType;
                        if (this.columnExpression.elementAt(i - 1) instanceof TableColumn) {
                            TableColumn tableCol = (TableColumn)this.columnExpression.elementAt(i - 1);
                            sourceDataType = null;
                            if (SwisSQLAPI.variableDatatypeMapping != null) {
                                sourceDataType = CastingUtil.getDataType((String)SwisSQLAPI.variableDatatypeMapping.get(tableCol.getColumnName()));
                            }
                            if (sourceDataType != null && (sourceDataType.equalsIgnoreCase("CHAR") || sourceDataType.equalsIgnoreCase("VARCHAR"))) {
                                this.leftTableColProcessed = true;
                            }
                        }
                        if (this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                            TableColumn tableCol = (TableColumn)this.columnExpression.elementAt(i + 1);
                            sourceDataType = null;
                            if (SwisSQLAPI.variableDatatypeMapping != null) {
                                sourceDataType = CastingUtil.getDataType((String)SwisSQLAPI.variableDatatypeMapping.get(tableCol.getColumnName()));
                            }
                            if (sourceDataType != null && (sourceDataType.equalsIgnoreCase("CHAR") || sourceDataType.equalsIgnoreCase("VARCHAR"))) {
                                this.rightTableColProcessed = true;
                            }
                        }
                        if (i > 0 && this.columnExpression.elementAt(i - 1) instanceof FunctionCalls) {
                            FunctionCalls fc = (FunctionCalls)this.columnExpression.get(i - 1);
                            if (fc.getFunctionName() != null && fc.getFunctionName().getColumnName().equalsIgnoreCase("CHAR")) {
                                FunctionCalls fc1;
                                if (this.columnExpression.size() > i + 1 && this.columnExpression.elementAt(i + 1) instanceof FunctionCalls) {
                                    fc1 = (FunctionCalls)this.columnExpression.get(i + 1);
                                    if (fc1.getFunctionName() == null || !fc1.getFunctionName().getColumnName().equalsIgnoreCase("CHAR") || fc1.getFunctionArguments() == null || fc1.getFunctionArguments().size() != 1) {
                                        FunctionCalls fc2 = new FunctionCalls();
                                        tc = new TableColumn();
                                        tc.setColumnName("CHAR");
                                        fc2.setFunctionName(tc);
                                        Vector<SelectColumn> v1 = new Vector<SelectColumn>();
                                        SelectColumn selCol = new SelectColumn();
                                        Vector selExp = new Vector();
                                        selExp.add(this.columnExpression.get(i + 1));
                                        selCol.setColumnExpression(selExp);
                                        v1.add(selCol);
                                        fc2.setFunctionArguments(v1);
                                        this.columnExpression.set(i + 1, fc2);
                                    }
                                } else if (!this.rightTableColProcessed) {
                                    fc1 = new FunctionCalls();
                                    TableColumn tc6 = new TableColumn();
                                    tc6.setColumnName("CHAR");
                                    fc1.setFunctionName(tc6);
                                    Vector<SelectColumn> v1 = new Vector<SelectColumn>();
                                    SelectColumn selCol = new SelectColumn();
                                    Vector selExp = new Vector();
                                    selExp.add(this.columnExpression.get(i + 1));
                                    selCol.setColumnExpression(selExp);
                                    v1.add(selCol);
                                    fc1.setFunctionArguments(v1);
                                    this.columnExpression.set(i + 1, fc1);
                                }
                            } else {
                                this.checkConcatenationString(v_ce, this.columnExpression, i, 3);
                            }
                        } else if (i == 1 && v_ce.elementAt(0).toString().trim().equals("CAST(NULL AS INT)")) {
                            v_ce.setElementAt("CAST(NULL AS CHAR)", 0);
                        } else {
                            this.checkConcatenationString(v_ce, this.columnExpression, i, 3);
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    v_ce.addElement(") || CHAR(");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT")) {
                    v_ce.addElement("CURRENT DATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                    this.createPowerFunction(v_ce, this.columnExpression, i, true);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("%")) {
                    this.createModFunction(v_ce, this.columnExpression, i);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("::")) {
                    this.createCastFunction(v_ce, this.columnExpression, i);
                    Object object = v_ce.get(v_ce.size() - 1);
                    if (!(object instanceof FunctionCalls)) continue;
                    v_ce.set(v_ce.size() - 1, ((FunctionCalls)object).toDB2Select(to_sqs, from_sqs));
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                    throw new ConvertException();
                }
                if (s_ce.equalsIgnoreCase("=")) {
                    if (!this.isSelectColFromUQS) {
                        if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                            sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                        }
                        v_ce.setElementAt(" ", i - 1);
                        continue;
                    }
                    v_ce.addElement("=");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    FunctionCalls fc = (FunctionCalls)v_ce.get(v_ce.size() - 1);
                    v_ce.setElementAt(fc.toDB2Select(to_sqs, from_sqs), v_ce.size() - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("NULL")) {
                    if (!this.insideDecodeFunction) {
                        if (this.targetDataTypeWithSize != null) {
                            v_ce.addElement("CAST(NULL AS " + this.targetDataTypeWithSize + ")");
                            continue;
                        }
                        if (this.targetDataType != null) {
                            v_ce.addElement("CAST(NULL AS " + this.targetDataType + ")");
                            continue;
                        }
                        v_ce.addElement("CAST(NULL AS INT)");
                        continue;
                    }
                    v_ce.addElement("NULL");
                    continue;
                }
                boolean flag = false;
                if (s_ce.trim().equals("+")) {
                    Object leftExpr = null;
                    if (i - 1 >= 0) {
                        leftExpr = this.columnExpression.elementAt(i - 1);
                    }
                    Object rightExpr = this.columnExpression.elementAt(i + 1);
                    if (leftExpr instanceof String || rightExpr instanceof String) {
                        if (leftExpr.toString().endsWith("'") || rightExpr.toString().startsWith("'")) {
                            flag = true;
                            v_ce.addElement(" CONCAT ");
                        }
                    } else if (leftExpr instanceof FunctionCalls) {
                        FunctionCalls fc = (FunctionCalls)leftExpr;
                        TableColumn tc7 = fc.getFunctionName();
                        Vector args = fc.getFunctionArguments();
                        Object o2 = null;
                        if (args.size() >= 2) {
                            o2 = args.elementAt(1);
                        }
                        if (o2 instanceof Datatype) {
                            if (o2 instanceof CharacterClass) {
                                flag = true;
                                v_ce.addElement(" CONCAT ");
                            }
                        } else if (tc7 != null && SwisSQLUtils.getFunctionReturnType(tc7.getColumnName(), args).equalsIgnoreCase("string")) {
                            flag = true;
                            v_ce.addElement(" CONCAT ");
                        }
                    } else if (leftExpr instanceof TableColumn) {
                        tc = (TableColumn)leftExpr;
                        String dataType = MetadataInfoUtil.getDatatypeName(from_sqs, tc);
                        if (dataType != null) {
                            dataType = dataType.toLowerCase();
                        }
                        if (dataType != null && dataType.indexOf("char") != -1) {
                            flag = true;
                            v_ce.addElement(" CONCAT ");
                        } else if (rightExpr instanceof FunctionCalls) {
                            FunctionCalls fc = (FunctionCalls)rightExpr;
                            TableColumn tc1 = fc.getFunctionName();
                            Vector args = fc.getFunctionArguments();
                            if (tc1 != null && SwisSQLUtils.getFunctionReturnType(tc1.getColumnName(), args).equalsIgnoreCase("string")) {
                                flag = true;
                                v_ce.addElement(" CONCAT ");
                            }
                        }
                    }
                }
                if (isDate && s_ce != null && (s_ce.trim().equals("+") || s_ce.trim().equals("-")) && !openBraceisSet) {
                    boolean dateColWithNumCol = false;
                    if (this.columnExpression.elementAt(i + 1) != null && this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                        String colDataType = MetadataInfoUtil.getDatatypeName(from_sqs, (TableColumn)this.columnExpression.elementAt(i + 1));
                        if (colDataType == null && SwisSQLAPI.variableDatatypeMapping != null) {
                            colDataType = (String)SwisSQLAPI.variableDatatypeMapping.get(((TableColumn)this.columnExpression.elementAt(i + 1)).getColumnName());
                        }
                        if (colDataType != null && (colDataType.toLowerCase().indexOf("num") != -1 || colDataType.toLowerCase().indexOf("int") != -1 || colDataType.toLowerCase().indexOf("decimal") != -1)) {
                            dateColWithNumCol = true;
                        }
                    }
                    if (!(this.columnExpression.elementAt(i + 1) instanceof TableColumn)) {
                        if (dateColsWithArithExpr.size() < 2) {
                            openBraceisSet = true;
                            v_ce.addElement(s_ce);
                            v_ce.addElement("(");
                            continue;
                        }
                        two_or_more_date_column = true;
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (dateColWithNumCol) {
                        openBraceisSet = true;
                        v_ce.addElement(s_ce);
                        v_ce.addElement("(");
                        continue;
                    }
                    two_or_more_date_column = true;
                    v_ce.addElement(s_ce);
                    continue;
                }
                if (s_ce.trim().equals("/")) {
                    Object obj = v_ce.lastElement();
                    FunctionCalls fn = new FunctionCalls();
                    tc = new TableColumn();
                    tc.setColumnName("DECIMAL");
                    fn.setFunctionName(tc);
                    Vector args = new Vector();
                    args.add(obj);
                    fn.setFunctionArguments(args);
                    v_ce.setElementAt(fn, v_ce.size() - 1);
                    v_ce.addElement(s_ce);
                    continue;
                }
                if (flag) continue;
                if (this.targetDataType != null && (this.targetDataType.equalsIgnoreCase("decimal") || this.targetDataType.toLowerCase().indexOf("num") != -1 || this.targetDataType.indexOf("int") != -1) && s_ce.trim().startsWith("'")) {
                    v_ce.addElement(CastingUtil.getDB2DataTypeCastedString(null, this.targetDataType, s_ce.substring(1, s_ce.length() - 1)));
                    continue;
                }
                if (!arithmeticExpr && !s_ce.trim().equalsIgnoreCase("-")) {
                    if (!this.inArithmeticExpr) {
                        v_ce.addElement(CastingUtil.getDB2DataTypeCastedString(null, this.targetDataType, s_ce));
                        continue;
                    }
                    v_ce.addElement(CastingUtil.getDB2DataTypeCastedString(null, "DOUBLE", s_ce));
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        if (!concatExpr && arithmeticExprAssignedToVar && !this.inArithmeticExpr) {
            v_ce.addElement("))");
        }
        if (concatExpr && arithmeticExpr) {
            v_ce.addElement(")");
        }
        if (!openBraceisSet && this.columnExpression.contains("-")) {
            block3: for (int m = 0; m < dateColsWithArithExpr.size(); ++m) {
                for (int l = 0; l < v_ce.size(); ++l) {
                    TableColumn newTC;
                    FunctionCalls newFn;
                    if (!v_ce.get(l).toString().equalsIgnoreCase(dateColsWithArithExpr.get(m).toString())) continue;
                    if (two_or_more_date_column) {
                        newFn = new FunctionCalls();
                        newTC = new TableColumn();
                        String dtCol = dateColsWithArithExpr.get(m).toString();
                        newTC.setColumnName("DAYS(DATE(" + dtCol + "))");
                        newFn.setFunctionName(newTC);
                        newFn.setOpenBracesForFunctionNameRequired(false);
                        v_ce.removeElementAt(l);
                        v_ce.insertElementAt(newFn, l);
                        continue block3;
                    }
                    newFn = new FunctionCalls();
                    newTC = new TableColumn();
                    String dtCol = dateColsWithArithExpr.get(m).toString();
                    newTC.setColumnName("(YEAR(" + dtCol + ")*365 + MONTH(" + dtCol + ")*31 + DAY(" + dtCol + ") + HOUR(" + dtCol + ")/24.0 + MINUTE(" + dtCol + ")/1440.0 + SECOND(" + dtCol + ")/86400.0)");
                    newFn.setFunctionName(newTC);
                    newFn.setOpenBracesForFunctionNameRequired(false);
                    v_ce.removeElementAt(l);
                    v_ce.insertElementAt(newFn, l);
                    continue block3;
                }
            }
        }
        if (openBraceisSet) {
            v_ce.add(") DAYS");
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        if (sc != null && sc.getAliasName() == null) {
            if (this.aliasName != null && this.aliasName.charAt(0) == '\'') {
                sc.setAliasName(this.aliasName.replace('\'', '\"'));
            } else {
                sc.setAliasName(this.aliasName);
            }
        }
        return sc;
    }

    private void addInDateColsIfPrevFnCall(Vector v_ce, ArrayList dateColsWithArithExpr) {
        Object exprObj;
        String operator;
        Object obj;
        int size = v_ce.size();
        if (size > 2 && (obj = v_ce.get(size - 2)) instanceof String && (operator = (String)obj).trim().equals("-") && (exprObj = v_ce.get(size - 3)) instanceof FunctionCalls) {
            dateColsWithArithExpr.add(exprObj);
        }
    }

    public void checkConcatenationString(Vector v_ce, Vector columnExpression, int i, int database) {
        SelectColumn leftSideCastFunction = new SelectColumn();
        SelectColumn rightSideCastFunction = new SelectColumn();
        Vector leftColExp = new Vector();
        Vector rightColExp = new Vector();
        Vector<Object> leftSideFunctionArguments = new Vector<Object>();
        Vector<Object> rightSideFunctionArguments = new Vector<Object>();
        TableColumn leftSideTC = new TableColumn();
        FunctionCalls leftSideFC = new FunctionCalls();
        TableColumn rightSideTC = new TableColumn();
        FunctionCalls rightSideFC = new FunctionCalls();
        SelectColumn parentLeftSideCastFunction = new SelectColumn();
        Vector<FunctionCalls> parentLeftColExp = new Vector<FunctionCalls>();
        Vector<SelectColumn> parentLeftSideFunctionArguments = new Vector<SelectColumn>();
        TableColumn parentLeftSideTC = new TableColumn();
        FunctionCalls parentLeftSideFC = new FunctionCalls();
        SelectColumn parentRightSideCastFunction = new SelectColumn();
        Vector<FunctionCalls> parentRightColExp = new Vector<FunctionCalls>();
        Vector<SelectColumn> parentRightSideFunctionArguments = new Vector<SelectColumn>();
        TableColumn parentRightSideTC = new TableColumn();
        FunctionCalls parentRightSideFC = new FunctionCalls();
        if (database == 3) {
            leftSideTC.setColumnName("CHAR");
            parentLeftSideTC.setColumnName("RTRIM");
        } else {
            leftSideTC.setColumnName("CAST");
        }
        if (i - 1 <= v_ce.size() - 1) {
            Object prevObject = v_ce.elementAt(i - 1);
            if (!(this.leftTableColProcessed && database == 3 || prevObject.toString().charAt(0) == '\'' || prevObject.toString().toLowerCase().startsWith("cast") || prevObject.toString().toLowerCase().startsWith("char(") || prevObject.toString().toLowerCase().startsWith("rtrim(char("))) {
                leftColExp.add(prevObject);
                leftSideCastFunction.setColumnExpression(leftColExp);
                leftSideFunctionArguments.add(leftSideCastFunction);
                if (database == 2) {
                    leftSideFunctionArguments.add("VARCHAR");
                }
                leftSideFC.setFunctionArguments(leftSideFunctionArguments);
                leftSideFC.setFunctionName(leftSideTC);
                if (database != 3) {
                    leftSideFC.setAsDatatype("AS");
                }
                if (database == 3) {
                    parentLeftColExp.add(leftSideFC);
                    parentLeftSideCastFunction.setColumnExpression(parentLeftColExp);
                    parentLeftSideFunctionArguments.add(parentLeftSideCastFunction);
                    parentLeftSideFC.setFunctionArguments(parentLeftSideFunctionArguments);
                    parentLeftSideFC.setFunctionName(parentLeftSideTC);
                    v_ce.setElementAt(parentLeftSideFC, i - 1);
                } else {
                    v_ce.setElementAt(leftSideFC, i - 1);
                }
            }
        }
        if (database == 3) {
            rightSideTC.setColumnName("CHAR");
            parentRightSideTC.setColumnName("RTRIM");
        } else {
            rightSideTC.setColumnName("CAST");
        }
        Object nextObject = columnExpression.elementAt(i + 1);
        if (!(this.rightTableColProcessed && database == 3 || nextObject.toString().charAt(0) == '\'' || nextObject.toString().toLowerCase().startsWith("cast") || nextObject.toString().toLowerCase().startsWith("char(") || nextObject.toString().toLowerCase().startsWith("rtrim(char("))) {
            rightColExp.add(nextObject);
            rightSideCastFunction.setColumnExpression(rightColExp);
            rightSideFunctionArguments.add(rightSideCastFunction);
            if (database == 2) {
                rightSideFunctionArguments.add("VARCHAR");
            }
            rightSideFC.setFunctionArguments(rightSideFunctionArguments);
            rightSideFC.setFunctionName(rightSideTC);
            if (database != 3) {
                rightSideFC.setAsDatatype("AS");
            }
            if (database == 3) {
                parentRightColExp.add(rightSideFC);
                parentRightSideCastFunction.setColumnExpression(parentRightColExp);
                parentRightSideFunctionArguments.add(parentRightSideCastFunction);
                parentRightSideFC.setFunctionArguments(parentRightSideFunctionArguments);
                parentRightSideFC.setFunctionName(parentRightSideTC);
                columnExpression.setElementAt(parentRightSideFC, i + 1);
            } else {
                columnExpression.setElementAt(rightSideFC, i + 1);
            }
        }
    }

    public void checkConcatenationString(Vector v_ce, Vector columnExpression, int i, boolean bool) {
        TableColumn tc;
        String s_fce;
        FunctionCalls fc;
        String s_fce2;
        if (v_ce.elementAt(i - 1) instanceof String) {
            s_fce2 = (String)v_ce.elementAt(i - 1);
            if (s_fce2.charAt(0) != '\'' && s_fce2.indexOf("cast") != 0) {
                s_fce2 = "CAST ( " + s_fce2 + " AS VARCHAR ) ";
                v_ce.setElementAt(s_fce2, i - 1);
            }
        } else if (v_ce.elementAt(i - 1) instanceof FunctionCalls) {
            fc = (FunctionCalls)v_ce.elementAt(i - 1);
            if (fc.toString().indexOf("cast") != 0) {
                s_fce = "CAST ( " + fc.toString() + " AS VARCHAR ) ";
                v_ce.setElementAt(s_fce, i - 1);
            }
        } else if (v_ce.elementAt(i - 1) instanceof TableColumn && (tc = (TableColumn)v_ce.elementAt(i - 1)).toString().indexOf("cast") != 0 && tc.toString().charAt(0) != '\'') {
            s_fce = "CAST ( " + tc.toString() + " AS VARCHAR ) ";
            v_ce.setElementAt(s_fce, i - 1);
        }
        if (columnExpression.elementAt(i + 1) instanceof String) {
            s_fce2 = (String)columnExpression.elementAt(i + 1);
            if (s_fce2.charAt(0) != '\'' && s_fce2.indexOf("cast") != 0) {
                s_fce2 = "CAST ( " + s_fce2 + " AS VARCHAR ) ";
                columnExpression.setElementAt(s_fce2, i + 1);
            }
        } else if (columnExpression.elementAt(i + 1) instanceof FunctionCalls) {
            fc = (FunctionCalls)columnExpression.elementAt(i + 1);
            if (fc.toString().indexOf("cast") != 0) {
                s_fce = "CAST ( " + fc.toString() + " AS VARCHAR ) ";
                columnExpression.setElementAt(s_fce, i + 1);
            }
        } else if (columnExpression.elementAt(i + 1) instanceof TableColumn && (tc = (TableColumn)columnExpression.elementAt(i + 1)).toString().indexOf("cast") != 0 && tc.toString().charAt(0) != '\'') {
            s_fce = "CAST ( " + tc.toString() + " AS VARCHAR ) ";
            columnExpression.setElementAt(s_fce, i + 1);
        }
    }

    public SelectColumn toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectColumn sc = new SelectColumn();
        sc.setCommentClass(this.commentObj);
        int sql_dialect = 0;
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        String[] keywords = null;
        if (SwisSQLUtils.getKeywords(1) != null) {
            keywords = SwisSQLUtils.getKeywords(1);
        }
        sc.setOpenBrace(this.OpenBrace);
        if (!this.isOrderItem) {
            this.handleTableColumn(this.columnExpression, from_sqs, 1);
        }
        int cESize = this.columnExpression.size();
        for (int i = 0; i < cESize; ++i) {
            Object temp;
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                TableColumn tc = (TableColumn)this.columnExpression.elementAt(i);
                if (this.fromUQS != null) {
                    tc.setFromUQS(this.fromUQS);
                }
                tc.setObjectContext(this.context);
                if (tc.getColumnName() != null) {
                    String column_Name = tc.getColumnName();
                    if (column_Name.equalsIgnoreCase("INCREMENT")) {
                        column_Name = "INCREMENT_BY";
                    }
                    tc.setColumnName(column_Name);
                }
                tc = tc.toOracleSelect(to_sqs, from_sqs);
                if (SwisSQLOptions.SetSybaseDoubleQuotedLiteralsToSingleQuotes && tc.getOwnerName() == null && tc.getTableName() == null) {
                    String colName = tc.getColumnName();
                    if ((i != 0 || cESize <= 1 || !(this.columnExpression.elementAt(i + 1) instanceof String)) && colName.startsWith("\"")) {
                        colName = colName.replaceAll("'", "\"");
                        colName = "'" + colName.substring(1, colName.length() - 1) + "'";
                        tc.setColumnName(colName);
                    }
                }
                v_ce.addElement(tc);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                CharacterClass characterclass;
                String datatypeName;
                ((FunctionCalls)this.columnExpression.elementAt(i)).setObjectContext(this.context);
                FunctionCalls fcs = (FunctionCalls)this.columnExpression.elementAt(i);
                TableColumn tcol = fcs.getFunctionName();
                if (tcol != null && tcol.getTableName() != null && tcol.getTableName().equalsIgnoreCase("DBO")) {
                    tcol.setTableName(null);
                }
                if (this.columnExpression.elementAt(i).toString().trim().toLowerCase().startsWith("user_name(")) {
                    SelectQueryStatement userSQS = new SelectQueryStatement();
                    SelectStatement userSS = new SelectStatement();
                    userSS.setSelectClause("SELECT");
                    Vector<SelectColumn> userSCV = new Vector<SelectColumn>();
                    SelectColumn userSC = new SelectColumn();
                    Vector<TableColumn> colExpr = new Vector<TableColumn>();
                    TableColumn userTC = new TableColumn();
                    userTC.setColumnName("USER");
                    colExpr.add(userTC);
                    userSC.setColumnExpression(colExpr);
                    userSCV.add(userSC);
                    userSS.setSelectItemList(userSCV);
                    userSQS.setSelectStatement(userSS);
                    FunctionCalls userFun = (FunctionCalls)this.columnExpression.elementAt(i);
                    Vector userFunArgs = userFun.getFunctionArguments();
                    if (userFunArgs != null && userFunArgs.size() == 1) {
                        WhereExpression userWe = new WhereExpression();
                        Vector<WhereItem> userWIV = new Vector<WhereItem>();
                        WhereItem userWI = new WhereItem();
                        WhereColumn userLWC = new WhereColumn();
                        Vector<String> userLWColExpr = new Vector<String>();
                        userLWColExpr.add("UID");
                        userLWC.setColumnExpression(userLWColExpr);
                        userWI.setLeftWhereExp(userLWC);
                        WhereColumn userRWC = new WhereColumn();
                        Vector userRWColExpr = new Vector();
                        userRWColExpr.add(userFunArgs.get(0));
                        userRWC.setColumnExpression(userRWColExpr);
                        userWI.setRightWhereExp(userRWC);
                        userWI.setOperator("=");
                        userWIV.add(userWI);
                        userWe.setWhereItem(userWIV);
                        userSQS.setWhereExpression(userWe);
                    }
                    String temp2 = userSQS.toOracleString();
                    v_ce.addElement("(");
                    v_ce.addElement(temp2);
                    v_ce.addElement(")");
                    this.columnExpression.setElementAt(temp2, i);
                    continue;
                }
                FunctionCalls fc = (FunctionCalls)this.columnExpression.elementAt(i);
                boolean isNtextFunction = false;
                if (fc.getFunctionName() != null && fc.getFunctionName().getColumnName().equalsIgnoreCase("CONVERT") && fc.getFunctionArguments().get(0) instanceof CharacterClass && (datatypeName = (characterclass = (CharacterClass)fc.getFunctionArguments().get(0)).getDatatypeName()).equalsIgnoreCase("NTEXT")) {
                    v_ce.addElement(fc.getFunctionArguments().get(1));
                    isNtextFunction = true;
                }
                if (isNtextFunction) continue;
                FunctionCalls temp3 = fc.toOracleSelect(to_sqs, from_sqs);
                v_ce.addElement(temp3);
                this.columnExpression.setElementAt(temp3, i);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                temp = ((SelectColumn)this.columnExpression.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                v_ce.addElement(temp);
                this.columnExpression.setElementAt(temp, i);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                temp = ((CaseStatement)this.columnExpression.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                v_ce.addElement(temp);
                this.columnExpression.setElementAt(temp, i);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                temp = ((SelectQueryStatement)this.columnExpression.elementAt(i)).toOracleSelect();
                ((SelectQueryStatement)temp).setObjectContext(this.context);
                v_ce.addElement(temp);
                this.columnExpression.setElementAt(temp, i);
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                String s;
                String first_arg;
                s_ce = (String)this.columnExpression.elementAt(i);
                if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).toString().equalsIgnoreCase(".*")) {
                    s_ce = CustomizeUtil.objectNamesToQuotedIdentifier(s_ce, keywords, null, 1);
                }
                if (s_ce != null && (s_ce.startsWith("[") && s_ce.endsWith("]") || s_ce.startsWith("`") && s_ce.endsWith("`"))) {
                    s_ce = s_ce.substring(1, s_ce.length() - 1).trim();
                    if (SwisSQLOptions.retainQuotedIdentifierForOracle || s_ce.indexOf(32) != -1) {
                        s_ce = "\"" + s_ce + "\"";
                    }
                }
                if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                    v_ce.addElement("TO_CHAR(SYSDATE,'HH:MI:SS')");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                    v_ce.addElement("SYSDATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                    v_ce.addElement("SYSTIMESTAMP");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT")) {
                    v_ce.addElement("SYSDATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("%")) {
                    this.createModFunction(v_ce, this.columnExpression, i);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("&")) {
                    first_arg = "";
                    if (i >= 1) {
                        if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                            first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                        } else if (this.columnExpression.elementAt(i - 1) instanceof FunctionCalls) {
                            first_arg = ((FunctionCalls)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        for (int h = i - 1; h >= 0; --h) {
                            s = null;
                            s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                            if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                continue;
                            }
                            break;
                        }
                    }
                    String bitand2 = this.createBitAnd(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                    v_ce.add(bitand2);
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.trim().startsWith("$")) {
                    try {
                        String dollarString = s_ce.substring(1);
                        float numericValue = Float.parseFloat(dollarString);
                        v_ce.addElement(dollarString);
                    }
                    catch (NumberFormatException e) {
                        v_ce.addElement(s_ce);
                    }
                    continue;
                }
                if (s_ce.equalsIgnoreCase("::")) {
                    this.createCastFunction(v_ce, this.columnExpression, i);
                    Object object = v_ce.get(v_ce.size() - 1);
                    if (!(object instanceof FunctionCalls)) continue;
                    v_ce.set(v_ce.size() - 1, ((FunctionCalls)object).toOracleSelect(to_sqs, from_sqs));
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**")) {
                    this.createPowerFunction(v_ce, this.columnExpression, i, true);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("|")) {
                    first_arg = "";
                    if (i >= 1) {
                        if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                            first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        for (int h = i - 1; h >= 0; --h) {
                            s = null;
                            s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                            if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                continue;
                            }
                            break;
                        }
                    }
                    String bitor = this.createBitOR(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                    v_ce.add(bitor);
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("~")) {
                    v_ce.setElementAt(" ", i);
                    Object vv = v_ce.get(i + 1);
                    if (vv instanceof TableColumn) {
                        String s2 = ((TableColumn)v_ce.get(i + 1)).toOracleSelect(to_sqs, from_sqs).toString();
                        v_ce.setElementAt("((0 - " + s2 + ") + 1)", i + 1);
                    }
                    if (!(vv instanceof SelectColumn)) continue;
                    String s3 = ((SelectColumn)v_ce.get(i + 1)).toOracleSelect(to_sqs, from_sqs).toString();
                    v_ce.setElementAt("((0 - " + s3 + ") + 1)", i + 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("^")) {
                    first_arg = "";
                    if (i >= 1) {
                        if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                            first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                        } else {
                            for (int h = i - 1; h >= 0; --h) {
                                s = null;
                                s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                                if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                    first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        for (int h = i - 1; h >= 0; --h) {
                            s = null;
                            s = this.columnExpression.elementAt(h) instanceof TableColumn ? ((TableColumn)this.columnExpression.elementAt(h)).toOracleSelect(to_sqs, from_sqs).toString() : this.columnExpression.elementAt(h).toString();
                            if (!(s.trim().equals("+") || s.trim().equals("-") || s.trim().equals("*") || s.trim().equals("/") || s.trim().equals("%") || s.trim().equals("**") || s.trim().equals("^") || s.trim().equals("|") || s.trim().equals("&") || s.trim().equals(" ") || this.columnExpression.elementAt(h) instanceof SelectColumn)) {
                                first_arg = first_arg + this.columnExpression.elementAt(h).toString();
                                continue;
                            }
                            break;
                        }
                    }
                    String bitxor = this.createBitXOR(first_arg, this.columnExpression, i + 1, to_sqs, from_sqs);
                    v_ce.add(bitxor);
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase(">") || s_ce.equalsIgnoreCase("<")) {
                    first_arg = "";
                    String second_arg = "";
                    if (this.columnExpression.elementAt(i - 1) instanceof SelectColumn) {
                        first_arg = ((SelectColumn)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                    } else if (this.columnExpression.elementAt(i - 1) instanceof FunctionCalls) {
                        first_arg = ((FunctionCalls)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                    } else if (this.columnExpression.elementAt(i - 1) instanceof TableColumn) {
                        first_arg = ((TableColumn)this.columnExpression.elementAt(i - 1)).toOracleSelect(to_sqs, from_sqs).toString();
                    }
                    if (this.columnExpression.elementAt(i + 1) instanceof SelectColumn) {
                        second_arg = ((SelectColumn)this.columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs).toString();
                    } else if (this.columnExpression.elementAt(i + 1) instanceof FunctionCalls) {
                        second_arg = ((FunctionCalls)this.columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs).toString();
                    } else if (this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                        first_arg = ((TableColumn)this.columnExpression.elementAt(i + 1)).toOracleSelect(to_sqs, from_sqs).toString();
                    }
                    String caseStmt = "CASE WHEN " + first_arg + " " + s_ce + " " + second_arg + " THEN 1 ELSE 0 END";
                    v_ce.add(caseStmt);
                    v_ce.setElementAt(" ", i - 1);
                    this.columnExpression.clear();
                    continue;
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=")) {
                    if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.startsWith("@")) {
                    v_ce.addElement(":" + s_ce.substring(1));
                    continue;
                }
                if (s_ce.startsWith("0x") || s_ce.startsWith("0X")) {
                    String str2 = s_ce.substring(2);
                    v_ce.addElement("HEX_TO_NUMBER('" + str2 + "')");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("+") && (i - 1 >= 0 && (this.columnExpression.elementAt(i - 1).toString().trim().startsWith("'-") || this.columnExpression.elementAt(i - 1).toString().trim().endsWith("-'")) || i + 1 < this.columnExpression.size() && (this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'-") || this.columnExpression.elementAt(i + 1).toString().trim().endsWith("-'")))) {
                    v_ce.addElement("||");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("+")) {
                    String newStr = null;
                    if (i - 1 >= 0 && this.columnExpression.elementAt(i - 1).toString().trim().startsWith("'")) {
                        newStr = this.columnExpression.elementAt(i - 1).toString();
                        if (newStr.equals("''") || StringFunctions.replaceAll("", " ", newStr.substring(1, newStr.length() - 1)).length() == 0) {
                            v_ce.addElement("||");
                            continue;
                        }
                        if (i + 1 < this.columnExpression.size() && (this.columnExpression.elementAt(i + 1) instanceof TableColumn || this.columnExpression.elementAt(i + 1) instanceof FunctionCalls || this.columnExpression.elementAt(i + 1) instanceof SelectColumn)) {
                            v_ce.addElement("||");
                            continue;
                        }
                        if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1) instanceof String && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                            v_ce.addElement("||");
                            continue;
                        }
                        if (from_sqs != null) {
                            if (from_sqs.getFromClause() == null && i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                                v_ce.addElement("||");
                                continue;
                            }
                            v_ce.addElement(s_ce);
                            continue;
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'")) {
                        newStr = this.columnExpression.elementAt(i + 1).toString();
                        if (newStr.equals("''") || StringFunctions.replaceAll("", " ", newStr.substring(1, newStr.length() - 1)).length() == 0) {
                            v_ce.addElement("||");
                            continue;
                        }
                        if (i - 1 >= 0 && (this.columnExpression.elementAt(i - 1) instanceof TableColumn || this.columnExpression.elementAt(i - 1) instanceof FunctionCalls || this.columnExpression.elementAt(i + 1) instanceof SelectColumn)) {
                            v_ce.addElement("||");
                            continue;
                        }
                        v_ce.addElement(s_ce);
                        continue;
                    }
                    if (i - 1 >= 0 && this.columnExpression.elementAt(i - 1) instanceof TableColumn) {
                        this.addConcatenationSymbol(from_sqs, v_ce, s_ce, (TableColumn)this.columnExpression.elementAt(i - 1));
                        continue;
                    }
                    if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1) instanceof TableColumn) {
                        this.addConcatenationSymbol(from_sqs, v_ce, s_ce, (TableColumn)this.columnExpression.elementAt(i + 1));
                        continue;
                    }
                    if (i - 1 >= 0 && this.columnExpression.elementAt(i - 1) instanceof FunctionCalls) {
                        this.addConcatenationSymbol(from_sqs, v_ce, s_ce, (FunctionCalls)this.columnExpression.elementAt(i - 1));
                        continue;
                    }
                    if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1) instanceof FunctionCalls) {
                        this.addConcatenationSymbol(from_sqs, v_ce, s_ce, (FunctionCalls)this.columnExpression.elementAt(i + 1));
                        continue;
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CONCAT")) {
                    v_ce.addElement("||");
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        if (sc != null && sc.getAliasName() == null) {
            this.aliasName = CustomizeUtil.objectNamesToQuotedIdentifier(this.aliasName, SwisSQLUtils.getKeywords(1), null, 1);
            if (this.aliasName != null && this.aliasName.charAt(0) == '\'') {
                sc.setAliasName(this.aliasName.replace('\'', '\"'));
            } else if (this.aliasName != null && this.aliasName.startsWith("[")) {
                String tempAlias = this.aliasName.substring(1, this.aliasName.length() - 1);
                if (SwisSQLOptions.retainQuotedIdentifierForOracle || tempAlias.indexOf(" ") != -1) {
                    sc.setAliasName("\"" + tempAlias + "\"");
                } else {
                    sc.setAliasName(tempAlias);
                }
            } else {
                sc.setAliasName(this.aliasName);
            }
        }
        return sc;
    }

    private boolean isDecimal(String input) {
        try {
            double a = Double.parseDouble(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void handleTableColumn(Vector colExpr, SelectQueryStatement from_sqs, int target) {
        for (int i = 0; i < colExpr.size(); ++i) {
            String columnName;
            TableColumn tc;
            if (!(colExpr.elementAt(i) instanceof TableColumn) || i + 1 < colExpr.size() && colExpr.elementAt(i + 1).toString().equalsIgnoreCase("=") && colExpr.elementAt(i).toString().startsWith("\"") || (tc = (TableColumn)colExpr.elementAt(i)).getColumnName() == null || tc.getTableName() != null || (columnName = tc.getColumnName()).trim().length() <= 0) continue;
            if (columnName.equalsIgnoreCase("\"\"")) {
                if (target == 10) {
                    if (SwisSQLOptions.fromSybase) {
                        tc.setColumnName("' '");
                        continue;
                    }
                    tc.setColumnName("''");
                    continue;
                }
                tc.setColumnName("''");
                continue;
            }
            if (!columnName.startsWith("\"")) continue;
            boolean modify = true;
            FromClause fc = null;
            if (from_sqs != null) {
                fc = from_sqs.getFromClause();
            } else if (this.fromUQS != null) {
                Vector fromItems;
                FromClause uqsFC;
                ArrayList tabClauseList;
                fc = new FromClause();
                Vector<FromTable> newFromItems = new Vector<FromTable>();
                fc.setFromItemList(newFromItems);
                TableExpression tExpr = this.fromUQS.getTableExpression();
                if (tExpr != null && (tabClauseList = tExpr.getTableClauseList()) != null) {
                    for (int j = 0; j < tabClauseList.size(); ++j) {
                        Object obj = tabClauseList.get(j);
                        if (!(obj instanceof TableClause)) continue;
                        TableObject tabObj = ((TableClause)obj).getTableObject();
                        String tableName = tabObj.getTableName();
                        FromTable fromTab = new FromTable();
                        fromTab.setTableName(tableName);
                        newFromItems.add(fromTab);
                    }
                }
                if ((uqsFC = this.fromUQS.getFromClause()) != null && (fromItems = uqsFC.getFromItemList()) != null) {
                    for (int j = 0; j < fromItems.size(); ++j) {
                        newFromItems.add((FromTable)fromItems.get(j));
                    }
                }
            } else {
                modify = false;
            }
            if (fc != null) {
                String tempCol = columnName.trim().substring(1, columnName.trim().length() - 1);
                Vector fromItems = fc.getFromItemList();
                if (fromItems != null) {
                    for (int j = 0; j < fromItems.size(); ++j) {
                        ArrayList colList;
                        Object obj = fromItems.get(j);
                        if (!(obj instanceof FromTable) || !((obj = ((FromTable)obj).getTableName()) instanceof String)) continue;
                        String tableName = (String)obj;
                        int index = tableName.lastIndexOf(".");
                        if (index != -1) {
                            tableName = tableName.substring(index + 1);
                        }
                        if (tableName.startsWith("\"") || tableName.startsWith("[") || tableName.startsWith("`")) {
                            tableName = tableName.substring(1, tableName.length() - 1);
                        }
                        if ((colList = (ArrayList)CastingUtil.getValueIgnoreCase(SwisSQLAPI.tableColumnListMetadata, tableName)) == null) break;
                        if (!CastingUtil.ContainsIgnoreCase(colList, tempCol)) continue;
                        modify = false;
                        break;
                    }
                }
            }
            if (!modify) continue;
            columnName = StringFunctions.replaceFirst("'", "\"", columnName);
            columnName = columnName.trim().substring(0, columnName.trim().length() - 1) + "'";
            tc.setColumnName(columnName);
        }
    }

    private void addConcatenationSymbol(SelectQueryStatement from_sqs, Vector v_ce, String s_ce, TableColumn tc) {
        String dtype = MetadataInfoUtil.getDatatypeName(from_sqs, tc);
        String newStr = tc.getColumnName();
        if (dtype != null && dtype.toLowerCase().indexOf("char") != -1) {
            v_ce.addElement("||");
        } else if (dtype == null && newStr.startsWith("\"") && newStr.endsWith("\"")) {
            String name_only = newStr.substring(1, newStr.length() - 1);
            if (name_only.trim().equals("")) {
                v_ce.addElement("||");
            } else {
                v_ce.addElement(s_ce);
            }
        } else {
            v_ce.addElement(s_ce);
        }
    }

    private void addConcatenationSymbol(SelectQueryStatement from_sqs, Vector v_ce, String s_ce, FunctionCalls fc) {
        String fnName = fc.getFunctionName().getColumnName().toLowerCase();
        if (fnName.equalsIgnoreCase("suser_sname") || fnName.equalsIgnoreCase("user_name") || fnName.equalsIgnoreCase("to_char") || fnName.equalsIgnoreCase("substr") || fnName.equalsIgnoreCase("app_name") || fnName.equalsIgnoreCase("sys_context")) {
            v_ce.addElement("||");
        } else {
            v_ce.addElement(s_ce);
        }
    }

    private String createBitAnd(String first_arg, Vector sec_arg, int startIndex, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String bitand2 = "";
        String sec_arg_str = "";
        Object val = sec_arg.elementAt(startIndex);
        for (int i = startIndex; i < sec_arg.size(); ++i) {
            Object col;
            Object data = sec_arg.elementAt(i);
            if (data instanceof String) {
                String f_arg;
                String str2 = data.toString();
                if (str2.equals("&")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg_str + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitAnd(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("|")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg_str + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("^")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg_str + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitXOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("~")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    Object ne = sec_arg.get(i + 1);
                    if (ne instanceof String) {
                        String ss = ne.toString();
                        return "BITAND(" + first_arg + ",((0-" + ne + ")+1))";
                    }
                    if (!(ne instanceof TableColumn)) continue;
                    TableColumn col2 = ((TableColumn)ne).toOracleSelect(to_sqs, from_sqs);
                    sec_arg_str = sec_arg_str + col2.toString();
                    return "BITAND(" + first_arg + ",((0-" + sec_arg_str + ")+1))";
                }
                if (str2.trim().equals("+") || str2.trim().equals("-") || str2.trim().equals("*") || str2.trim().equals("/") || str2.trim().equals("%") || str2.trim().equals("**") || str2.trim().equals("^") || str2.trim().equals("|") || str2.trim().equals("&")) break;
                sec_arg_str = sec_arg_str + str2;
                continue;
            }
            if (data instanceof TableColumn) {
                col = ((TableColumn)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((TableColumn)col).toString();
                continue;
            }
            if (data instanceof FunctionCalls) {
                col = ((FunctionCalls)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((FunctionCalls)col).toString();
                continue;
            }
            if (data instanceof SelectQueryStatement) {
                SelectQueryStatement sqs = ((SelectQueryStatement)data).toOracleSelect();
                sec_arg_str = sec_arg_str + sqs.toString();
                continue;
            }
            if (data instanceof CaseStatement) {
                CaseStatement cs = ((CaseStatement)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + cs.toString();
                continue;
            }
            if (!(data instanceof SelectColumn)) break;
            SelectColumn sel = ((SelectColumn)data).toOracleSelect(to_sqs, from_sqs);
            sec_arg_str = sec_arg_str + sel.toString();
        }
        sec_arg.setElementAt(" ", startIndex - 1);
        this.columnExpression.setElementAt(" ", startIndex);
        bitand2 = bitand2 + "BITAND(" + first_arg + "," + sec_arg_str + ")";
        return bitand2;
    }

    private String createBitXOR(String first_arg, Vector sec_arg, int startIndex, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String bitxor = "";
        String sec_arg_str = "";
        Object val = sec_arg.elementAt(startIndex);
        for (int i = startIndex; i < sec_arg.size(); ++i) {
            Object col;
            Object data = sec_arg.elementAt(i);
            if (data instanceof String) {
                String f_arg;
                String str2 = data.toString();
                if (str2.equals("^")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + ")*2)";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitXOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("|")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + ")*2)";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("&")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + ")*2)";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitAnd(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("~")) {
                    f_arg = "BITAND(" + first_arg + "," + sec_arg + ")";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    Object ne = sec_arg.get(i + 1);
                    if (ne instanceof String) {
                        String ss = ne.toString();
                        sec_arg_str = "((0 - " + ne + ") + 1)";
                        return first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))*2";
                    }
                    if (!(ne instanceof TableColumn)) continue;
                    TableColumn col2 = ((TableColumn)ne).toOracleSelect(to_sqs, from_sqs);
                    sec_arg_str = "((0 - " + sec_arg_str + col2.toString() + ") + 1";
                    return first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))*2";
                }
                if (str2.trim().equals("+") || str2.trim().equals("-") || str2.trim().equals("*") || str2.trim().equals("/") || str2.trim().equals("%") || str2.trim().equals("**") || str2.trim().equals("^") || str2.trim().equals("|") || str2.trim().equals("&")) break;
                sec_arg_str = sec_arg_str + str2;
                continue;
            }
            if (data instanceof TableColumn) {
                col = ((TableColumn)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((TableColumn)col).toString();
                continue;
            }
            if (data instanceof FunctionCalls) {
                col = ((FunctionCalls)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((FunctionCalls)col).toString();
                continue;
            }
            if (data instanceof SelectQueryStatement) {
                SelectQueryStatement sqs = ((SelectQueryStatement)data).toOracleSelect();
                sec_arg_str = sec_arg_str + sqs.toString();
                continue;
            }
            if (data instanceof CaseStatement) {
                CaseStatement cs = ((CaseStatement)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + cs.toString();
                continue;
            }
            if (!(data instanceof SelectColumn)) break;
            SelectColumn sel = ((SelectColumn)data).toOracleSelect(to_sqs, from_sqs);
            sec_arg_str = sec_arg_str + sel.toString();
        }
        sec_arg.setElementAt(" ", startIndex - 1);
        this.columnExpression.setElementAt(" ", startIndex);
        bitxor = bitxor + "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + ")*2)";
        return bitxor;
    }

    private String createBitOR(String first_arg, Vector sec_arg, int startIndex, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String bitor = "";
        String sec_arg_str = "";
        Object val = sec_arg.elementAt(startIndex);
        for (int i = startIndex; i < sec_arg.size(); ++i) {
            Object col;
            Object data = sec_arg.elementAt(i);
            if (data instanceof String) {
                String f_arg;
                String str2 = data.toString();
                if (str2.equals("|")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("^")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitXOR(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("&")) {
                    f_arg = "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    return this.createBitAnd(f_arg, sec_arg, i + 1, to_sqs, from_sqs);
                }
                if (str2.equals("~")) {
                    sec_arg.setElementAt(" ", i - 1);
                    sec_arg.setElementAt(" ", i);
                    Object ne = sec_arg.get(i + 1);
                    if (ne instanceof String) {
                        String ss = ne.toString();
                        sec_arg_str = "((0 - " + ne + ") + 1)";
                        return first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                    }
                    if (!(ne instanceof TableColumn)) continue;
                    TableColumn col2 = ((TableColumn)ne).toOracleSelect(to_sqs, from_sqs);
                    sec_arg_str = "((0 - " + sec_arg_str + col2.toString() + ") + 1";
                    return first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
                }
                if (str2.trim().equals("+") || str2.trim().equals("-") || str2.trim().equals("*") || str2.trim().equals("/") || str2.trim().equals("%") || str2.trim().equals("**") || str2.trim().equals("^") || str2.trim().equals("|") || str2.trim().equals("&")) break;
                sec_arg_str = sec_arg_str + str2;
                continue;
            }
            if (data instanceof TableColumn) {
                col = ((TableColumn)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((TableColumn)col).toString();
                continue;
            }
            if (data instanceof FunctionCalls) {
                col = ((FunctionCalls)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + ((FunctionCalls)col).toString();
                continue;
            }
            if (data instanceof SelectQueryStatement) {
                SelectQueryStatement sqs = ((SelectQueryStatement)data).toOracleSelect();
                sec_arg_str = sec_arg_str + sqs.toString();
                continue;
            }
            if (data instanceof CaseStatement) {
                CaseStatement cs = ((CaseStatement)data).toOracleSelect(to_sqs, from_sqs);
                sec_arg_str = sec_arg_str + cs.toString();
                continue;
            }
            if (!(data instanceof SelectColumn)) break;
            SelectColumn sel = ((SelectColumn)data).toOracleSelect(to_sqs, from_sqs);
            sec_arg_str = sec_arg_str + sel.toString();
        }
        sec_arg.setElementAt(" ", startIndex - 1);
        this.columnExpression.setElementAt(" ", startIndex);
        bitor = bitor + "((" + first_arg + "+" + sec_arg_str + ")" + " - BITAND(" + first_arg + "," + sec_arg_str + "))";
        return bitor;
    }

    public SelectColumn toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectColumn sc = new SelectColumn();
        int sql_dialect = 0;
        if (this.commentObj == null) {
            CommentClass cmc = new CommentClass();
            cmc.setSpecialToken(new ArrayList());
            sc.setCommentClass(cmc);
        } else {
            sc.setCommentClass(this.commentObj);
        }
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        sc.setOpenBrace(this.OpenBrace);
        boolean removeOperatorsWhenNullIsEncountered = false;
        int nullPosition = 0;
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i)).toInformixSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toInformixSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toInformixSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toInformixSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toInformixSelect());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.equalsIgnoreCase("||")) {
                    this.checkConcatenationString(v_ce, this.columnExpression, i, 6);
                    v_ce.addElement(s_ce);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("%")) {
                    this.createModFunction(v_ce, this.columnExpression, i);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                    this.createPowerFunction(v_ce, this.columnExpression, i, false);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 5) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=")) {
                    if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("NULL")) {
                    removeOperatorsWhenNullIsEncountered = true;
                    v_ce.addElement("CAST(NULL AS INT)");
                    nullPosition = v_ce.size();
                    continue;
                }
                if (s_ce.trim().startsWith("--") || s_ce.trim().startsWith("/*")) {
                    sc.getCommentClass().setComment(s_ce);
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            if (this.columnExpression.elementAt(i).toString().trim().startsWith("--") || this.columnExpression.elementAt(i).toString().trim().startsWith("/*")) {
                sc.getCommentClass().setComment(s_ce);
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        if (v_ce != null && removeOperatorsWhenNullIsEncountered) {
            while (nullPosition != 0 || nullPosition != v_ce.size()) {
                if (nullPosition > 1) {
                    if (!((String)v_ce.get(nullPosition - 2)).equalsIgnoreCase("+") && !((String)v_ce.get(nullPosition - 2)).equalsIgnoreCase("-") && !((String)v_ce.get(nullPosition - 2)).equalsIgnoreCase("*") && !((String)v_ce.get(nullPosition - 2)).equalsIgnoreCase("||") && !((String)v_ce.get(nullPosition - 2)).equalsIgnoreCase("/")) continue;
                    v_ce.removeElementAt(nullPosition - 2);
                    v_ce.removeElementAt(nullPosition - 3);
                    nullPosition -= 2;
                    continue;
                }
                if (nullPosition >= v_ce.size()) break;
                if (!((String)v_ce.get(nullPosition)).equalsIgnoreCase("+") && !((String)v_ce.get(nullPosition)).equalsIgnoreCase("-") && !((String)v_ce.get(nullPosition)).equalsIgnoreCase("*") && !((String)v_ce.get(nullPosition)).equalsIgnoreCase("||") && !((String)v_ce.get(nullPosition)).equalsIgnoreCase("/")) continue;
                v_ce.removeElementAt(nullPosition + 1);
                v_ce.removeElementAt(nullPosition);
            }
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        if (sc != null && sc.getAliasName() == null) {
            sc.setAliasName(this.aliasName);
        }
        return sc;
    }

    public void createModFunction(Vector v_ce, Vector columnExpression, int i) {
        SelectColumn sc_firstarg = new SelectColumn();
        SelectColumn sc_secondarg = new SelectColumn();
        Vector<SelectColumn> v_farg = new Vector<SelectColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        tc.setColumnName("MOD");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(v_ce.get(v_ce.size() - 1));
        if (i - 1 < v_ce.size()) {
            v_ce.setElementAt(" ", i - 1);
        } else {
            v_ce.setElementAt(" ", v_ce.size() - 1);
        }
        sc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(sc_firstarg);
        vec_secondarg.addElement(columnExpression.elementAt(i + 1));
        columnExpression.setElementAt(" ", i + 1);
        sc_secondarg.setColumnExpression(vec_secondarg);
        v_farg.addElement(sc_secondarg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
    }

    public void createBitAndFunction(Vector v_ce, Vector columnExpression, int i) {
        SelectColumn sc_firstarg = new SelectColumn();
        SelectColumn sc_secondarg = new SelectColumn();
        Vector<SelectColumn> v_farg = new Vector<SelectColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        tc.setColumnName("BITAND");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(columnExpression.elementAt(i - 1));
        v_ce.setElementAt(" ", i - 1);
        sc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(sc_firstarg);
        vec_secondarg.addElement(columnExpression.elementAt(i + 1));
        columnExpression.setElementAt(" ", i + 1);
        sc_secondarg.setColumnExpression(vec_secondarg);
        v_farg.addElement(sc_secondarg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
    }

    public void createCastFunction(Vector v_ce, Vector columnExpression, int i_count) {
        SelectColumn firstArgInCastFunction = new SelectColumn();
        SelectColumn secondArgInCastFunction = new SelectColumn();
        Vector<SelectColumn> functionArguments = new Vector<SelectColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        tc.setColumnName("CAST");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(columnExpression.elementAt(i_count - 1));
        vec_firstarg.addElement(" AS ");
        vec_firstarg.addElement(columnExpression.elementAt(i_count + 1));
        v_ce.setElementAt(" ", i_count - 1);
        columnExpression.setElementAt(" ", i_count + 1);
        firstArgInCastFunction.setColumnExpression(vec_firstarg);
        functionArguments.addElement(firstArgInCastFunction);
        fc.setFunctionArguments(functionArguments);
        v_ce.addElement(fc);
    }

    public void createDecodeFunction(Vector v_ce, Vector columnExpression, int i) {
        SelectColumn sc_firstarg = new SelectColumn();
        SelectColumn sc_secondarg = new SelectColumn();
        SelectColumn sc_thirdarg = new SelectColumn();
        SelectColumn sc_fourtharg = new SelectColumn();
        Vector<SelectColumn> v_farg = new Vector<SelectColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector vec_firstarg = new Vector();
        Vector vec_secondarg = new Vector();
        Vector<String> vec_thirdarg = new Vector<String>();
        Vector<String> vec_fourtharg = new Vector<String>();
        tc.setColumnName("DECODE");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(columnExpression.elementAt(i - 1));
        v_ce.setElementAt(" ", i - 1);
        sc_firstarg.setColumnExpression(vec_firstarg);
        v_farg.addElement(sc_firstarg);
        boolean isNotNull = false;
        Object obj = columnExpression.elementAt(i + 1);
        Object obj1 = columnExpression.elementAt(i);
        if (obj1.toString().trim().equalsIgnoreCase("is") && obj.toString().trim().equalsIgnoreCase("not null")) {
            obj = "NULL";
            isNotNull = true;
        }
        vec_secondarg.addElement(obj);
        columnExpression.setElementAt(" ", i + 1);
        sc_secondarg.setColumnExpression(vec_secondarg);
        v_farg.addElement(sc_secondarg);
        if (!isNotNull && obj1.toString().trim().equalsIgnoreCase("is")) {
            vec_thirdarg.addElement("1");
        } else {
            vec_thirdarg.addElement("0");
        }
        sc_thirdarg.setColumnExpression(vec_thirdarg);
        v_farg.addElement(sc_thirdarg);
        if (!isNotNull && obj1.toString().trim().equalsIgnoreCase("is")) {
            vec_fourtharg.addElement("0");
        } else {
            vec_fourtharg.addElement("1");
        }
        sc_fourtharg.setColumnExpression(vec_fourtharg);
        v_farg.addElement(sc_fourtharg);
        fc.setFunctionArguments(v_farg);
        v_ce.addElement(fc);
    }

    public SelectColumn toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectColumn sc = new SelectColumn();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        int sql_dialect = 0;
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        sc.setOpenBrace(this.OpenBrace);
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                TableColumn tcToBeChanged = (TableColumn)this.columnExpression.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        TableColumn tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        this.columnExpression.set(i, tcToBeChanged);
                    } else {
                        this.columnExpression.set(i, tcToBeChanged);
                    }
                }
                v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i)).toPostgreSQLSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                Vector funcArguments = ((FunctionCalls)this.columnExpression.get(i)).getFunctionArguments();
                if (funcArguments != null && this.originalTableNameList != null) {
                    for (int j = 0; j < funcArguments.size(); ++j) {
                        if (!(funcArguments.elementAt(j) instanceof SelectColumn)) continue;
                        SelectColumn sc1 = (SelectColumn)funcArguments.get(j);
                        sc1.setOriginalTableNamesForUpdateSetClause(this.originalTableNameList);
                    }
                }
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toPostgreSQLSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toPostgreSQLSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                ((SelectColumn)this.columnExpression.elementAt(i)).setOriginalTableNamesForUpdateSetClause(this.originalTableNameList);
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toPostgreSQLSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toPostgreSQLSelect());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                    v_ce.addElement("CURRENT_TIME");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                    v_ce.addElement("CURRENT_DATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                    v_ce.addElement("CURRENT_TIMESTAMP");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT")) {
                    v_ce.addElement("CURRENT_DATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**")) {
                    v_ce.addElement("^");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 2) {
                    if (v_ce.elementAt(i - 1) instanceof String) {
                        sc.setAliasName((String)v_ce.elementAt(i - 1));
                    } else if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    } else {
                        throw new ConvertException();
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=")) {
                    if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("NULL") && i > 1) {
                    if (this.columnExpression.elementAt(i - 1) instanceof String && this.columnExpression.elementAt(i - 1).equals("/")) {
                        throw new ConvertException("Conversion failure.. divided by NULL is not supported");
                    }
                    v_ce.addElement(s_ce);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("IS")) {
                    this.createDecodeFunction(v_ce, this.columnExpression, i);
                    FunctionCalls fc = (FunctionCalls)v_ce.get(v_ce.size() - 1);
                    v_ce.setElementAt(fc.toPostgreSQLSelect(to_sqs, from_sqs), v_ce.size() - 1);
                    continue;
                }
                if (s_ce.trim().equals("+")) {
                    if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).toString().trim().startsWith("'") && i - 1 >= 0 && this.columnExpression.elementAt(i - 1).toString().trim().startsWith("'")) {
                        v_ce.addElement("||");
                        continue;
                    }
                    v_ce.addElement("+");
                    continue;
                }
                if (s_ce.startsWith("0x") || s_ce.startsWith("0X")) {
                    String str2 = s_ce.substring(2);
                    v_ce.addElement("'" + str2 + "'");
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        if (this.aliasName != null && this.isAS == null) {
            sc.setIsAS("AS");
        } else {
            sc.setIsAS(this.isAS);
        }
        sc.setEndsWith(this.endsWith);
        if (sc != null && sc.getAliasName() == null) {
            if (this.aliasName != null && this.aliasName.charAt(0) == '\'') {
                sc.setAliasName(this.aliasName.replace('\'', '\"'));
            } else {
                sc.setAliasName(this.aliasName);
            }
        }
        return sc;
    }

    public SelectColumn toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i;
        SelectColumn sc = new SelectColumn();
        IntoStatement into = new IntoStatement();
        String s_ce = new String();
        Vector<Object> v_ce = new Vector<Object>();
        boolean intoClause = false;
        boolean concat2 = false;
        int sql_dialect = 0;
        if (from_sqs != null) {
            from_sqs.getSQLDialect();
        }
        sc.setOpenBrace(this.OpenBrace);
        if (this.columnExpression.contains("+") || this.columnExpression.contains("||")) {
            boolean isNumeric = this.isColumnTypeNumeric(from_sqs, this);
            if (!(this.columnExpression.contains("+") && isNumeric || this.isDateAddition)) {
                v_ce.add("concat(");
                concat2 = true;
            }
        }
        for (i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                v_ce.addElement(((TableColumn)this.columnExpression.elementAt(i)).toMySQLSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                v_ce.addElement(((FunctionCalls)this.columnExpression.elementAt(i)).toMySQLSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                v_ce.addElement(((CaseStatement)this.columnExpression.elementAt(i)).toMySQLSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                v_ce.addElement(((SelectColumn)this.columnExpression.elementAt(i)).toMySQLSelect(to_sqs, from_sqs));
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                v_ce.addElement(((SelectQueryStatement)this.columnExpression.elementAt(i)).toMySQLSelect());
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof String) {
                s_ce = (String)this.columnExpression.elementAt(i);
                if (s_ce.equalsIgnoreCase("CURRENT TIME")) {
                    v_ce.addElement("CURRENT_TIME");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT DATE")) {
                    v_ce.addElement("CURRENT_DATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                    v_ce.addElement("CURRENT_TIMESTAMP");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("CURRENT")) {
                    v_ce.addElement("CURRENT_DATE");
                    continue;
                }
                if (s_ce.equalsIgnoreCase("::")) {
                    this.createCastFunction(v_ce, this.columnExpression, i);
                    Object object = v_ce.get(v_ce.size() - 1);
                    if (!(object instanceof FunctionCalls)) continue;
                    v_ce.set(v_ce.size() - 1, ((FunctionCalls)object).toMySQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (s_ce.equalsIgnoreCase("**") | s_ce.equalsIgnoreCase("^")) {
                    this.createPowerFunction(v_ce, this.columnExpression, i, true);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=") && sql_dialect == 2) {
                    if (v_ce.elementAt(i - 1) instanceof String) {
                        sc.setAliasName((String)v_ce.elementAt(i - 1));
                    } else if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                    } else {
                        throw new ConvertException();
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.equalsIgnoreCase("=")) {
                    if (v_ce.elementAt(i - 1) instanceof TableColumn) {
                        String colName = ((TableColumn)v_ce.elementAt(i - 1)).getColumnName();
                        if (colName.startsWith("@")) {
                            into.setIntoClause("INTO");
                            into.setTableOrFileName(colName);
                            intoClause = true;
                        } else {
                            sc.setAliasName(((TableColumn)v_ce.elementAt(i - 1)).getColumnName());
                        }
                    }
                    v_ce.setElementAt(" ", i - 1);
                    continue;
                }
                if (s_ce.trim().equals("+") || s_ce.trim().equals("||")) {
                    if (s_ce.trim().equals("+") && !concat2) {
                        v_ce.addElement("+");
                        continue;
                    }
                    v_ce.addElement(",");
                    continue;
                }
                v_ce.addElement(s_ce);
                continue;
            }
            v_ce.addElement(this.columnExpression.elementAt(i));
        }
        if (intoClause) {
            v_ce.addElement(into);
        }
        if (concat2) {
            for (i = 1; i < v_ce.size(); ++i) {
                Object obj = v_ce.get(i);
                if (obj == null || obj instanceof String) continue;
                FunctionCalls fc = new FunctionCalls();
                TableColumn tc = new TableColumn();
                tc.setColumnName("CAST");
                CharacterClass charCluse = new CharacterClass();
                charCluse.setDatatypeName("CHAR");
                Vector<Object> newFunctionArgs = new Vector<Object>();
                if (obj instanceof SelectColumn) {
                    newFunctionArgs.add((SelectColumn)obj);
                } else {
                    SelectColumn sc1 = new SelectColumn();
                    Vector columnExpression = new Vector();
                    columnExpression.add(obj);
                    sc1.setColumnExpression(columnExpression);
                    newFunctionArgs.add(sc1);
                }
                newFunctionArgs.add(charCluse);
                fc.setFunctionName(tc);
                fc.setFunctionArguments(newFunctionArgs);
                fc.setAsDatatype("as");
                v_ce.set(i, fc);
            }
            v_ce.addElement(")");
        }
        sc.setColumnExpression(v_ce);
        sc.setCloseBrace(this.CloseBrace);
        sc.setIsAS(this.isAS);
        sc.setEndsWith(this.endsWith);
        if (sc != null && sc.getAliasName() == null) {
            if (this.aliasName != null && this.aliasName.startsWith("[")) {
                this.aliasName = this.aliasName.replace('[', '`');
                this.aliasName = this.aliasName.replace(']', '`');
            }
            sc.setAliasName(this.aliasName);
        }
        return sc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.commentObj != null) {
            sb.append(this.commentObj.toString().trim() + " ");
        }
        if (this.OpenBrace != null) {
            sb.append(this.OpenBrace);
        }
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            if (this.columnExpression.elementAt(i) instanceof SelectQueryStatement) {
                sb.append("(" + this.columnExpression.elementAt(i).toString() + ")");
                continue;
            }
            if (this.columnExpression.elementAt(i) instanceof TableColumn) {
                CommentClass co;
                TableColumn tc = (TableColumn)this.columnExpression.elementAt(i);
                if (this.commentObj == null && (co = tc.getCommentClass()) != null) {
                    sb.append(co.toString().trim() + " ");
                }
                tc.setObjectContext(this.context);
            } else if (this.columnExpression.elementAt(i) instanceof FunctionCalls) {
                ((FunctionCalls)this.columnExpression.elementAt(i)).setObjectContext(this.context);
            } else if (this.columnExpression.elementAt(i) instanceof SelectColumn) {
                ((SelectColumn)this.columnExpression.elementAt(i)).setObjectContext(this.context);
            } else if (this.columnExpression.elementAt(i) instanceof CaseStatement) {
                ((CaseStatement)this.columnExpression.elementAt(i)).setObjectContext(this.context);
            } else if (this.columnExpression.elementAt(i) instanceof String && i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).equals(".*") && this.context != null) {
                this.columnExpression.setElementAt(this.context.getEquivalent(this.columnExpression.get(i)), i);
            }
            if (i + 1 == this.columnExpression.size()) {
                sb.append(this.columnExpression.elementAt(i).toString());
                continue;
            }
            String colExprStr = this.columnExpression.elementAt(i).toString() + " ";
            if (this.columnExpression.elementAt(i).toString().equals("-")) {
                colExprStr = colExprStr.trim();
            }
            if (i + 1 < this.columnExpression.size() && this.columnExpression.elementAt(i + 1).equals(".*")) {
                colExprStr = colExprStr.trim();
            }
            if (colExprStr.startsWith("--")) {
                colExprStr = StringFunctions.replaceFirst("/*", "--", colExprStr);
                colExprStr = colExprStr + "*/";
            }
            sb.append(colExprStr);
        }
        if (this.CloseBrace != null) {
            sb.append(this.CloseBrace);
        }
        if (this.isAS != null) {
            sb.append(" " + this.isAS);
        }
        if (this.aliasName != null) {
            sb.append(" " + this.aliasName);
        }
        if (this.endsWith != null) {
            sb.append(this.endsWith);
        }
        return sb.toString();
    }

    public String getTheCoreSelectItem() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.columnExpression.size(); ++i) {
            sb.append(this.columnExpression.elementAt(i).toString() + " ");
        }
        return sb.toString();
    }

    public boolean isAggregateFunction() {
        boolean conta = this.containsAggregateFunction(this);
        return conta;
    }

    public boolean containsAggregateFunction(SelectColumn sCol) {
        Vector colExpr = sCol.getColumnExpression();
        for (int i = 0; i < colExpr.size(); ++i) {
            String functionName;
            if (!(colExpr.elementAt(i) instanceof FunctionCalls) || (functionName = ((FunctionCalls)colExpr.elementAt(i)).getFunctionNameAsAString()) == null) continue;
            if (functionName.equalsIgnoreCase("avg") || functionName.equalsIgnoreCase("count") || functionName.equalsIgnoreCase("max") || functionName.equalsIgnoreCase("min") || functionName.equalsIgnoreCase("sum")) {
                return true;
            }
            Vector funcArgs = ((FunctionCalls)colExpr.elementAt(i)).getFunctionArguments();
            if (funcArgs == null) continue;
            for (int j = 0; j < funcArgs.size(); ++j) {
                if (!(funcArgs.get(j) instanceof SelectColumn) || !this.containsAggregateFunction((SelectColumn)funcArgs.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean oj) {
        this.outerJoin = oj;
    }

    public String generateFunctionForSubQuery(SelectQueryStatement sqs, Vector parameters) {
        String functionString = "CREATE OR REPLACE FUNCTION ";
        String alias = "TUSER.HASCHILDREN";
        if (this.aliasName != null) {
            alias = "TUSER." + this.aliasName;
        }
        String parameterString = new String();
        String singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList;
        SelectQueryStatement.singleQueryConvertedToMultipleQueryList = null;
        String sqlStr = sqs.toString();
        SelectQueryStatement.singleQueryConvertedToMultipleQueryList = singleQueryConvertedToMultipleQueryList;
        sqlStr = StringFunctions.replaceAll("\n\t", "\n", sqlStr);
        if (parameters != null && parameters.size() > 0) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (!(parameters.get(i) instanceof String)) continue;
                parameterString = i > 0 ? parameterString + ",\n\t" + (String)parameters.get(i) + " INTEGER" : parameterString + (String)parameters.get(i) + " INTEGER";
            }
        }
        functionString = functionString + alias + "\n(\n\t" + parameterString + "\n)" + "\nRETURN INTEGER" + "\nAS\n\t" + "FUNCTION_VAR INTEGER" + ";\nBEGIN\n\t" + sqlStr.trim() + ";\n\tRETURN FUNCTION_VAR;\nEND;\n/";
        return functionString;
    }

    public Vector findTheParametersToBePassed(SelectQueryStatement sqs) {
        Vector fromTablesList;
        Vector parameters = new Vector();
        Vector<String> fromItemList = new Vector<String>();
        SelectStatement ss = sqs.getSelectStatement();
        Vector selectItemList = ss.getSelectItemList();
        FromClause fc = sqs.getFromClause();
        WhereExpression we = sqs.getWhereExpression();
        if (fc != null && (fromTablesList = fc.getFromItemList()) != null) {
            for (int i = 0; i < fromTablesList.size(); ++i) {
                if (!(fromTablesList.get(i) instanceof FromTable)) continue;
                FromTable ft = (FromTable)fromTablesList.get(i);
                if (ft.getAliasName() != null) {
                    SelectQueryStatement subSQS;
                    Vector parametersInsideSubquery;
                    if (ft.getTableName() instanceof SelectQueryStatement && (parametersInsideSubquery = this.findTheParametersToBePassed(subSQS = (SelectQueryStatement)ft.getTableName())) != null && parametersInsideSubquery.size() > 0) {
                        for (int j = 0; j < parametersInsideSubquery.size(); ++j) {
                            if (parameters.contains(parametersInsideSubquery.get(j))) continue;
                            parameters.add(parametersInsideSubquery.get(j));
                        }
                    }
                    fromItemList.add(ft.getAliasName().trim().toLowerCase());
                    continue;
                }
                Object tableName = ft.getTableName();
                fromItemList.add(tableName.toString().trim().toLowerCase());
            }
        }
        if (selectItemList != null) {
            for (int i = 0; i < selectItemList.size(); ++i) {
                if (!(selectItemList.get(i) instanceof SelectColumn)) continue;
                SelectColumn sc = (SelectColumn)selectItemList.get(i);
                Vector columnExpression = sc.getColumnExpression();
                this.addParametersForTheFunction(parameters, columnExpression, fromItemList);
            }
        }
        this.processWhereExpressionColumns(we, parameters, fromItemList);
        return parameters;
    }

    public void processWhereExpressionColumns(WhereExpression we, Vector parameters, Vector fromItemList) {
        Vector whereItemsList;
        if (we != null && (whereItemsList = we.getWhereItems()) != null) {
            for (int i = 0; i < whereItemsList.size(); ++i) {
                if (whereItemsList.get(i) instanceof WhereItem) {
                    WhereColumn rightWC;
                    WhereItem wi = (WhereItem)whereItemsList.get(i);
                    WhereColumn leftWC = wi.getLeftWhereExp();
                    if (leftWC != null) {
                        Vector leftColExp = leftWC.getColumnExpression();
                        this.addParametersForTheFunction(parameters, leftColExp, fromItemList);
                    }
                    if ((rightWC = wi.getRightWhereExp()) == null) continue;
                    Vector rightColExp = rightWC.getColumnExpression();
                    this.addParametersForTheFunction(parameters, rightColExp, fromItemList);
                    continue;
                }
                if (!(whereItemsList.get(i) instanceof WhereExpression)) continue;
                WhereExpression whereExp = (WhereExpression)whereItemsList.get(i);
                this.processWhereExpressionColumns(whereExp, parameters, fromItemList);
            }
        }
    }

    public void addParametersForTheFunction(Vector parameters, Vector colExp, Vector fromItemList) {
        if (colExp != null) {
            for (int i = 0; i < colExp.size(); ++i) {
                if (colExp.get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)colExp.get(i);
                    if (tc.getTableName() == null || fromItemList != null && fromItemList.contains(tc.getTableName().toLowerCase()) || parameters.contains(tc.toString().trim())) continue;
                    parameters.add(tc.toString().trim());
                    continue;
                }
                if (colExp.get(i) instanceof String) {
                    if (!((String)colExp.get(i)).trim().startsWith("@")) continue;
                    parameters.add(colExp.get(i));
                    continue;
                }
                if (colExp.get(i) instanceof FunctionCalls) {
                    Vector functionArgs = ((FunctionCalls)colExp.get(i)).getFunctionArguments();
                    this.addParametersForTheFunction(parameters, functionArgs, fromItemList);
                    continue;
                }
                if (!(colExp.get(i) instanceof SelectColumn)) continue;
                Vector selectColArgs = ((SelectColumn)colExp.get(i)).getColumnExpression();
                this.addParametersForTheFunction(parameters, selectColArgs, fromItemList);
            }
        }
    }

    public String getReturnDataTypeForCoalesce(FunctionCalls functionCalls, String builtInFunctionName, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) {
        Vector functionArguments = functionCalls.getFunctionArguments();
        if (functionArguments != null) {
            for (int i = 0; i < functionArguments.size(); ++i) {
                if (!(functionArguments.get(i) instanceof SelectColumn)) continue;
                SelectColumn selCol = (SelectColumn)functionArguments.get(i);
                try {
                    selCol.toDB2Select(to_sqs, from_sqs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String str2 = selCol.toString();
                TableColumn tableCol = new TableColumn();
                tableCol.setColumnName(str2);
                String dType = MetadataInfoUtil.getTargetDataTypeForColumn(tableCol);
                if (dType == null) {
                    if (this.corrTableColumn == null) continue;
                    tableCol.setTableName(this.corrTableColumn.getTableName());
                    return MetadataInfoUtil.getDatatypeName(from_sqs, tableCol);
                }
                return dType;
            }
        }
        return null;
    }

    private int convertNumeralsToInterval(Vector intervalVector, List subList) {
        int processedElements = 0;
        String previousOperator = "";
        for (int k = 0; k < subList.size(); ++k) {
            Object obj = subList.get(k);
            if (!(obj instanceof String)) continue;
            String objStr = obj.toString().trim();
            if (this.isDecimal(objStr) && (previousOperator.equalsIgnoreCase("") || previousOperator.equalsIgnoreCase("+") || previousOperator.equalsIgnoreCase("-"))) {
                String intervalStr = SwisSQLUtils.convertDayToInterval(objStr);
                ++processedElements;
                if (k != subList.size() - 1 && subList.get(k + 1).toString().equalsIgnoreCase("/") && subList.get(k + 2).toString().trim().equalsIgnoreCase("24")) {
                    intervalStr = intervalStr.replaceFirst("DAY", "HOUR");
                    k += 2;
                    processedElements += 2;
                }
                intervalVector.add(intervalStr);
                continue;
            }
            if (objStr.length() != 1) break;
            if (objStr.equalsIgnoreCase("(") || objStr.equalsIgnoreCase(")") || objStr.equalsIgnoreCase("+") || objStr.equalsIgnoreCase("-") || objStr.equalsIgnoreCase("*") || objStr.equalsIgnoreCase("%") || objStr.equalsIgnoreCase("^")) {
                intervalVector.add(objStr);
                previousOperator = objStr;
                ++processedElements;
                continue;
            }
            if (!this.isDecimal(objStr)) continue;
            intervalVector.add(objStr);
            ++processedElements;
        }
        return processedElements;
    }

    public void replaceRownumTableColumn(Object newColumn) throws ConvertException {
        Vector colExp = this.columnExpression;
        for (int k = 0; k < colExp.size(); ++k) {
            Object obj = colExp.get(k);
            if (obj instanceof TableColumn) {
                TableColumn tcnMod = (TableColumn)obj;
                if (!tcnMod.getColumnName().equalsIgnoreCase("rownum")) continue;
                colExp.setElementAt(newColumn, k);
                continue;
            }
            if (obj instanceof FunctionCalls) {
                Vector funcArgs = ((FunctionCalls)obj).getFunctionArguments();
                if (funcArgs == null) continue;
                for (int j = 0; j < funcArgs.size(); ++j) {
                    TableColumn tcnMod;
                    if (funcArgs.get(j) instanceof SelectColumn) {
                        ((SelectColumn)funcArgs.get(j)).replaceRownumTableColumn(newColumn);
                        continue;
                    }
                    if (!(funcArgs.get(j) instanceof TableColumn) || !(tcnMod = (TableColumn)funcArgs.get(j)).getColumnName().equalsIgnoreCase("rownum")) continue;
                    funcArgs.setElementAt(newColumn, j);
                }
                continue;
            }
            if (obj instanceof SelectColumn) {
                ((SelectColumn)obj).replaceRownumTableColumn(newColumn);
                continue;
            }
            if (obj instanceof CaseStatement) {
                CaseStatement csObj = (CaseStatement)obj;
                csObj.replaceRownumTableColumn(newColumn);
                continue;
            }
            if (!(obj instanceof SelectQueryStatement) && !(obj instanceof String)) continue;
        }
    }

    private boolean isColumnTypeNumeric(SelectQueryStatement from_sqs, SelectColumn sc) {
        boolean isNumeric = false;
        Vector columnExpression = sc.getColumnExpression();
        block4: for (int i = 0; i < columnExpression.size(); ++i) {
            if (columnExpression.elementAt(i) instanceof TableColumn) {
                TableColumn tc = (TableColumn)columnExpression.elementAt(i);
                String tabName = tc.getOrigTableName();
                if (tabName == null && from_sqs != null) {
                    if (tc != null && tc.getColumnName().trim().equalsIgnoreCase("INTERVAL") && columnExpression.contains("+")) {
                        this.isDateAddition = true;
                    }
                    try {
                        Object fromTableObj = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc).getTableName();
                        if (fromTableObj instanceof String) {
                            tabName = fromTableObj.toString();
                        }
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                }
                if (tabName == null) continue;
                String dtype = MetadataInfoUtil.getDatatypeName(from_sqs, tc);
                if (dtype != null) {
                    if ((dtype = dtype.trim().toUpperCase()).indexOf("INT") != -1 || dtype.indexOf("NUM") != -1) {
                        isNumeric = true;
                        break;
                    }
                    isNumeric = false;
                    continue;
                }
                isNumeric = true;
                continue;
            }
            if (columnExpression.elementAt(i) instanceof String) {
                String colExpStr = columnExpression.elementAt(i).toString();
                if (colExpStr.startsWith("'")) {
                    colExpStr = colExpStr.substring(1, colExpStr.length() - 1);
                }
                if (colExpStr.equalsIgnoreCase("+")) continue;
                try {
                    Double.parseDouble(colExpStr);
                    isNumeric = true;
                    break;
                }
                catch (NumberFormatException nfe) {
                    isNumeric = false;
                    continue;
                }
            }
            if (columnExpression.elementAt(i) instanceof FunctionCalls) {
                FunctionCalls fc;
                String functionName;
                if (!columnExpression.contains("+") || !(functionName = (fc = (FunctionCalls)columnExpression.elementAt(i)).getFunctionName().toString()).equalsIgnoreCase("max") && !functionName.equalsIgnoreCase("min") && !functionName.equalsIgnoreCase("count") && !functionName.equalsIgnoreCase("avg") && !functionName.equalsIgnoreCase("sum") && !functionName.equalsIgnoreCase("to_number")) continue;
                isNumeric = true;
                break;
            }
            if (columnExpression.elementAt(i) instanceof CaseStatement) {
                CaseStatement cs = (CaseStatement)columnExpression.elementAt(i);
                Vector v = cs.getWhenClauseList();
                for (int vi = 0; vi < v.size(); ++vi) {
                    WhenStatement ws = (WhenStatement)v.get(vi);
                    SelectColumn whenSC = ws.getThenStatement();
                    isNumeric = this.isColumnTypeNumeric(from_sqs, whenSC);
                    if (isNumeric) break block4;
                }
                continue;
            }
            if (columnExpression.elementAt(i) instanceof SelectColumn && (isNumeric = this.isColumnTypeNumeric(from_sqs, (SelectColumn)columnExpression.elementAt(i)))) break;
        }
        return isNumeric;
    }
}

