/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.statement.select.FetchClause;
import com.adventnet.swissqlapi.sql.statement.select.FromClause;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectStatement;
import com.adventnet.swissqlapi.sql.statement.select.SetOperatorClause;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import com.adventnet.swissqlapi.util.misc.CastingUtil;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class LimitClause {
    public String limitClause;
    public String limitValue;
    public String offsetClause;
    public String offsetStart;

    public void setLimitClause(String s_lc) {
        this.limitClause = s_lc;
    }

    public void setLimitValue(String s_lv) {
        this.limitValue = s_lv;
    }

    public void setOffSetClause(String s_osc) {
        this.offsetClause = s_osc;
    }

    public void setOffSetStart(String s_os) {
        this.offsetStart = s_os;
    }

    public String getLimitValue() {
        return this.limitValue;
    }

    public String getOffSetClause() {
        return this.offsetClause;
    }

    public String getOffSetStart() {
        return this.offsetStart;
    }

    public LimitClause toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        LimitClause lc = new LimitClause();
        if (this.limitValue != null && !this.limitValue.equalsIgnoreCase("ALL")) {
            if (this.offsetStart != null) {
                lc.setLimitClause(this.limitClause);
                lc.setLimitValue(this.offsetStart);
                lc.setOffSetStart(this.limitValue);
            } else {
                lc.setLimitValue(this.limitValue);
                lc.setOffSetStart(this.offsetStart);
                lc.setLimitClause(this.limitClause);
            }
        }
        return lc;
    }

    public LimitClause toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        LimitClause lc = new LimitClause();
        if (this.limitValue != null) {
            if (this.offsetStart != null) {
                lc.setLimitClause(this.limitClause);
                lc.setLimitValue(this.limitValue);
                lc.setOffSetClause(this.offsetClause);
                lc.setOffSetStart(this.offsetStart);
            } else {
                lc.setLimitValue(this.limitValue);
                lc.setOffSetStart(this.offsetStart);
                lc.setLimitClause(this.limitClause);
            }
        }
        return lc;
    }

    public LimitClause toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.limitClause != null && !this.limitValue.equalsIgnoreCase("ALL")) {
            to_sqs.getSelectStatement().setSelectRowSpecifier("TOP");
            to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(this.limitValue));
            if (this.offsetStart != null) {
                SelectQueryStatement sqs = new SelectQueryStatement();
                sqs.setDatatypeMapping(to_sqs.getDatatypeMapping());
                sqs.setFromClause(to_sqs.getFromClause());
                sqs.setGroupByStatement(to_sqs.getGroupByStatement());
                sqs.setHavingStatement(to_sqs.getHavingStatement());
                sqs.setIntoStatement(to_sqs.getIntoStatement());
                sqs.setOrderByStatement(to_sqs.getOrderByStatement());
                sqs.setSetOperatorClause(to_sqs.getSetOperatorClause());
                sqs.setForUpdateStatement(to_sqs.getForUpdateStatement());
                if (to_sqs.getWhereExpression() != null) {
                    sqs.setWhereExpression(this.getClonedWhereExpression(to_sqs.getWhereExpression()));
                }
                SelectStatement toSS = to_sqs.getSelectStatement();
                Vector toSelItems = toSS.getSelectItemList();
                SelectStatement ss = new SelectStatement();
                ss.setSelectClause("SELECT");
                ss.setSelectRowSpecifier("TOP");
                ss.setSelectRowCount(Integer.parseInt(this.offsetStart));
                sqs.setSelectStatement(ss);
                Vector<SelectColumn> subSelItems = new Vector<SelectColumn>();
                ss.setSelectItemList(subSelItems);
                SelectColumn subSC = new SelectColumn();
                WhereItem wi = new WhereItem();
                WhereColumn lwc = new WhereColumn();
                Object obj = toSelItems.get(0);
                boolean isStar = false;
                if (toSelItems.size() == 1 && obj instanceof SelectColumn) {
                    Object exprObj;
                    Vector colExpr = ((SelectColumn)obj).getColumnExpression();
                    if (colExpr.size() == 1) {
                        exprObj = colExpr.get(0);
                        if (exprObj instanceof String && exprObj.toString().equals("*")) {
                            isStar = true;
                        }
                    } else if (colExpr.size() == 2 && (exprObj = colExpr.get(1)) instanceof String && exprObj.toString().equals(".*")) {
                        isStar = true;
                    }
                }
                if (isStar) {
                    FromClause fc = sqs.getFromClause();
                    if (fc != null) {
                        Vector fromItems = fc.getFromItemList();
                        for (int i = 0; i < fromItems.size(); ++i) {
                            Hashtable colDatatypeTable;
                            int index;
                            Object fromItemObj = fromItems.get(i);
                            if (!(fromItemObj instanceof FromTable)) continue;
                            Object tblObj = ((FromTable)fromItemObj).getTableName();
                            String alias = ((FromTable)fromItemObj).getAliasName();
                            if (!(tblObj instanceof String)) continue;
                            String tableName = tblObj.toString();
                            if (alias == null) {
                                alias = tableName;
                            }
                            if ((index = tableName.indexOf(".")) != -1) {
                                tableName = tableName.substring(index + 1, tableName.length());
                            }
                            if ((colDatatypeTable = (Hashtable)CastingUtil.getValueIgnoreCase(SwisSQLAPI.dataTypesFromMetaDataHT, tableName)) == null) {
                                to_sqs.setGeneralComments("/* SwisSQL Message : Metadata of the source database required for accurate conversion */");
                            } else {
                                Set keys = colDatatypeTable.keySet();
                                Iterator it = keys.iterator();
                                Vector<String> lwcColExpr = new Vector<String>();
                                lwcColExpr.add(alias + "." + it.next().toString());
                                subSC.setColumnExpression(lwcColExpr);
                                subSelItems.add(subSC);
                                lwc.setColumnExpression(lwcColExpr);
                                wi.setLeftWhereExp(lwc);
                            }
                            break;
                        }
                    }
                } else if (obj instanceof SelectColumn) {
                    Vector lwcColExpr = ((SelectColumn)obj).getColumnExpression();
                    subSC.setColumnExpression(lwcColExpr);
                    subSelItems.add(subSC);
                    lwc.setColumnExpression(lwcColExpr);
                    wi.setLeftWhereExp(lwc);
                }
                wi.setOperator("NOT IN");
                wi.setRightWhereSubQuery(sqs);
                WhereExpression toWE = to_sqs.getWhereExpression();
                if (toWE != null) {
                    Vector<String> operators = toWE.getOperator();
                    if (operators != null && operators.size() > 0) {
                        operators.add("AND");
                    } else {
                        operators = new Vector<String>();
                        operators.add("AND");
                        toWE.setOperator(operators);
                    }
                    toWE.getWhereItems().add(wi);
                } else {
                    WhereExpression newWE = new WhereExpression();
                    Vector<WhereItem> wis = new Vector<WhereItem>();
                    wis.add(wi);
                    newWE.setWhereItem(wis);
                    to_sqs.setWhereExpression(newWE);
                }
            }
        }
        return null;
    }

    public LimitClause toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.limitClause != null && !this.limitValue.equalsIgnoreCase("ALL")) {
            to_sqs.getSelectStatement().setSelectRowSpecifier("TOP");
            to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(this.limitValue));
        }
        return null;
    }

    public LimitClause toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.limitClause != null && !this.limitValue.equalsIgnoreCase("ALL")) {
            to_sqs.getSelectStatement().setInformixRowSpecifier("FIRST");
            to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(this.limitValue));
        }
        return null;
    }

    public LimitClause toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        FetchClause fc = new FetchClause();
        if (to_sqs.getFetchClause() != null) {
            throw new ConvertException();
        }
        if (this.limitClause != null && !this.limitValue.equalsIgnoreCase("ALL")) {
            fc.setFetchFirstClause("FETCH FIRST");
            fc.setFetchCount(this.limitValue);
            fc.setRowOnlyClause("ROWS ONLY");
            to_sqs.setFetchClause(fc);
        }
        return null;
    }

    public LimitClause toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.offsetStart != null && this.offsetStart.equalsIgnoreCase("ALL")) {
            throw new ConvertException("Invalid 'OFFSET' value");
        }
        LimitClause lc = new LimitClause();
        if (this.limitClause != null && this.offsetStart == null && !this.limitValue.equalsIgnoreCase("ALL")) {
            WhereExpression f_we = from_sqs.getWhereExpression();
            WhereItem wi = new WhereItem();
            Vector<String> v_temp = new Vector<String>();
            WhereColumn wc_temp = new WhereColumn();
            v_temp.addElement("ROWNUM");
            wc_temp.setColumnExpression(v_temp);
            wi.setLeftWhereExp(wc_temp);
            wi.setOperator("<");
            v_temp = new Vector();
            wc_temp = new WhereColumn();
            v_temp.addElement(Integer.toString(Integer.parseInt(this.limitValue) + 1));
            wc_temp.setColumnExpression(v_temp);
            wi.setRightWhereExp(wc_temp);
            if (f_we != null && f_we.getCheckWhere()) {
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereItem(wi);
            } else if (f_we != null) {
                to_sqs.setWhereExpression(f_we.toOracleSelect(to_sqs, from_sqs));
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereItem(wi);
            } else {
                WhereExpression we = new WhereExpression();
                we.addWhereItem(wi);
                if (to_sqs != null && to_sqs.getWhereExpression() != null) {
                    to_sqs.getWhereExpression().addOperator("AND");
                    to_sqs.getWhereExpression().addWhereExpression(we);
                } else {
                    to_sqs.setWhereExpression(we);
                }
            }
        } else if (this.limitClause != null && this.offsetStart != null && this.limitValue.equalsIgnoreCase("ALL")) {
            WhereItem wi = new WhereItem();
            WhereColumn wc = new WhereColumn();
            Vector<String> v_sc = new Vector<String>();
            SelectQueryStatement sqs_i = new SelectQueryStatement();
            SelectStatement ss_i = new SelectStatement();
            FromClause fc = new FromClause();
            TableColumn tc = new TableColumn();
            WhereExpression we = new WhereExpression();
            FromClause t_fc = to_sqs.getFromClause();
            WhereExpression f_we = from_sqs.getWhereExpression();
            v_sc.addElement("ROWID");
            wc.setColumnExpression(v_sc);
            wi.setLeftWhereExp(wc);
            wi.setOperator("NOT IN");
            wi.setRightWhereSubQuery(sqs_i);
            ss_i.setSelectClause("select");
            Vector<String> v_tc = new Vector<String>();
            v_tc.addElement("ROWID");
            SelectColumn sc_new = new SelectColumn();
            sc_new.setColumnExpression(v_tc);
            Vector<SelectColumn> vec_tc = new Vector<SelectColumn>();
            vec_tc.addElement(sc_new);
            ss_i.setSelectItemList(vec_tc);
            fc.setFromClause(t_fc.getFromClause());
            fc.setFromItemList(t_fc.getFromItemList());
            WhereItem wi_sc = new WhereItem();
            Vector<String> v_temp = new Vector<String>();
            WhereColumn wc_temp = new WhereColumn();
            v_temp.addElement("ROWNUM");
            wc_temp.setColumnExpression(v_temp);
            wi_sc.setLeftWhereExp(wc_temp);
            wi_sc.setOperator("<");
            v_temp = new Vector();
            wc_temp = new WhereColumn();
            v_temp.addElement(Integer.toString(Integer.parseInt(this.offsetStart) + 1));
            wc_temp.setColumnExpression(v_temp);
            wi_sc.setRightWhereExp(wc_temp);
            sqs_i.setSelectStatement(ss_i);
            sqs_i.setFromClause(fc);
            we.addWhereItem(wi_sc);
            sqs_i.setWhereExpression(we);
            if (f_we != null && f_we.getCheckWhere()) {
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereItem(wi);
            } else if (f_we != null) {
                to_sqs.setWhereExpression(f_we.toOracleSelect(to_sqs, from_sqs));
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereItem(wi);
            } else {
                WhereExpression we_temp = new WhereExpression();
                we_temp.addWhereItem(wi);
                if (to_sqs != null && to_sqs.getWhereExpression() != null) {
                    to_sqs.getWhereExpression().addOperator("AND");
                    to_sqs.getWhereExpression().addWhereExpression(we_temp);
                } else {
                    to_sqs.setWhereExpression(we_temp);
                }
            }
        } else if (this.limitClause != null && this.offsetStart != null && !this.limitValue.equalsIgnoreCase("ALL")) {
            WhereItem wi = new WhereItem();
            WhereColumn wc = new WhereColumn();
            Vector<String> v_sc = new Vector<String>();
            SelectQueryStatement sqs_i = new SelectQueryStatement();
            SelectStatement ss_i = new SelectStatement();
            FromClause fc = new FromClause();
            TableColumn tc = new TableColumn();
            WhereExpression we = new WhereExpression();
            FromClause t_fc = to_sqs.getFromClause();
            v_sc.addElement("ROWID");
            wc.setColumnExpression(v_sc);
            wi.setLeftWhereExp(wc);
            wi.setOperator("IN");
            wi.setRightWhereSubQuery(sqs_i);
            ss_i.setSelectClause("select");
            Vector<String> v_tc = new Vector<String>();
            v_tc.addElement("ROWID");
            SelectColumn sc_new = new SelectColumn();
            sc_new.setColumnExpression(v_tc);
            Vector<SelectColumn> vec_tc = new Vector<SelectColumn>();
            vec_tc.addElement(sc_new);
            ss_i.setSelectItemList(vec_tc);
            fc.setFromClause(t_fc.getFromClause());
            fc.setFromItemList(t_fc.getFromItemList());
            WhereItem wi_sc = new WhereItem();
            Vector<String> v_temp = new Vector<String>();
            WhereColumn wc_temp = new WhereColumn();
            v_temp.addElement("ROWNUM");
            wc_temp.setColumnExpression(v_temp);
            wi_sc.setLeftWhereExp(wc_temp);
            wi_sc.setOperator("<");
            v_temp = new Vector();
            wc_temp = new WhereColumn();
            v_temp.addElement(Integer.toString(Integer.parseInt(this.limitValue) + Integer.parseInt(this.offsetStart) + 1));
            wc_temp.setColumnExpression(v_temp);
            wi_sc.setRightWhereExp(wc_temp);
            sqs_i.setSelectStatement(ss_i);
            sqs_i.setFromClause(fc);
            we.addWhereItem(wi_sc);
            sqs_i.setWhereExpression(we);
            WhereItem wi_new = new WhereItem();
            WhereExpression we_new = new WhereExpression();
            WhereExpression f_we = from_sqs.getWhereExpression();
            Vector<String> vec_temp = new Vector<String>();
            WhereColumn wc_tc = new WhereColumn();
            vec_temp.addElement("ROWNUM");
            wc_tc.setColumnExpression(vec_temp);
            wi_new.setLeftWhereExp(wc_tc);
            wi_new.setOperator("<");
            vec_temp = new Vector();
            wc_tc = new WhereColumn();
            vec_temp.addElement(Integer.toString(Integer.parseInt(this.offsetStart) + 1));
            wc_tc.setColumnExpression(vec_temp);
            wi_new.setRightWhereExp(wc_tc);
            SelectQueryStatement sqs_new = new SelectQueryStatement();
            sqs_new.setSelectStatement(ss_i);
            sqs_new.setFromClause(fc);
            we_new.addWhereItem(wi_new);
            sqs_new.setWhereExpression(we_new);
            SetOperatorClause soc = new SetOperatorClause();
            soc.setSetClause("minus");
            soc.setSelectQueryStatement(sqs_new);
            sqs_i.setSetOperatorClause(soc);
            if (f_we != null && f_we.getCheckWhere()) {
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereItem(wi);
            } else if (f_we != null) {
                to_sqs.setWhereExpression(f_we.toOracleSelect(to_sqs, from_sqs));
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereItem(wi);
            } else {
                WhereExpression we_temp = new WhereExpression();
                we_temp.addWhereItem(wi);
                if (to_sqs != null && to_sqs.getWhereExpression() != null) {
                    to_sqs.getWhereExpression().addOperator("AND");
                    to_sqs.getWhereExpression().addWhereExpression(we_temp);
                } else {
                    to_sqs.setWhereExpression(we_temp);
                }
            }
        }
        lc = null;
        return lc;
    }

    private WhereExpression getClonedWhereExpression(WhereExpression whereExpression) {
        WhereExpression clonedWhereExpression = new WhereExpression();
        Vector<Object> whereItemList = new Vector<Object>();
        Vector clonedWhereItems = new Vector();
        clonedWhereExpression.setOperator((Vector)whereExpression.getOperator().clone());
        Vector whereItems = whereExpression.getWhereItems();
        for (int i = 0; i < whereItems.size(); ++i) {
            if (whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem whereItem = (WhereItem)((WhereItem)whereItems.elementAt(i)).clone();
                whereItemList.addElement(whereItem);
                continue;
            }
            if (!(whereItems.elementAt(i) instanceof WhereExpression)) continue;
            whereItemList.addElement(this.getClonedWhereExpression((WhereExpression)whereItems.elementAt(i)));
        }
        clonedWhereExpression.setWhereItem(whereItemList);
        return clonedWhereExpression;
    }

    public LimitClause toTimesTenSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.limitClause != null && !this.limitValue.equalsIgnoreCase("ALL")) {
            to_sqs.getSelectStatement().setSelectRowSpecifier("FIRST");
            to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(this.limitValue));
        }
        return null;
    }

    public LimitClause toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        LimitClause lc = new LimitClause();
        if (this.limitValue != null) {
            if (this.offsetStart != null) {
                lc.setLimitClause(this.limitClause);
                lc.setLimitValue(this.offsetStart);
                lc.setOffSetStart(this.limitValue);
            } else {
                lc.setLimitValue(this.limitValue);
                lc.setOffSetStart(this.offsetStart);
                lc.setLimitClause(this.limitClause);
            }
        }
        return lc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.limitClause != null) {
            sb.append(this.limitClause.toUpperCase());
        }
        if (this.limitValue != null) {
            sb.append(" " + this.limitValue.toUpperCase());
        }
        if (this.offsetClause != null) {
            sb.append(" " + this.offsetClause.toUpperCase());
        }
        if (this.offsetStart != null) {
            if (this.offsetClause == null) {
                sb.append("," + this.offsetStart.toUpperCase());
            } else {
                sb.append(" " + this.offsetStart.toUpperCase());
            }
        }
        return sb.toString();
    }
}

