/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.insert;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.insert.InsertQueryStatement;
import com.adventnet.swissqlapi.sql.statement.insert.ValuesClause;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.update.OptionalSpecifier;
import com.adventnet.swissqlapi.sql.statement.update.TableClause;
import com.adventnet.swissqlapi.sql.statement.update.TableExpression;
import com.adventnet.swissqlapi.sql.statement.update.TableObject;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.misc.CastingUtil;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class InsertClause {
    private String insert = null;
    private OptionalSpecifier optionalSpecifier = null;
    private TableExpression tblExp = null;
    private ArrayList columnList = null;
    private String with;
    private String lock;
    private String lockStatement;
    public static boolean isOracleDEFColTruncated = false;
    private UserObjectContext context = null;
    private CommentClass commentObj;

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setInsert(String s) {
        this.insert = s;
    }

    public void setOptionalSpecifier(OptionalSpecifier ps) {
        this.optionalSpecifier = ps;
    }

    public void setTableExpression(TableExpression tec) {
        this.tblExp = tec;
    }

    public void setColumnList(ArrayList v) {
        this.columnList = v;
    }

    public void setWith(String with) {
        this.with = with;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    public void setLockStatement(String lockStatement) {
        this.lockStatement = lockStatement;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public ArrayList getColumnList() {
        return this.columnList;
    }

    public OptionalSpecifier getOptionalSpecifier() {
        return this.optionalSpecifier;
    }

    public TableExpression getTableExpression() {
        return this.tblExp;
    }

    public String getWith() {
        return this.with;
    }

    public String getLock() {
        return this.lock;
    }

    public String getLockStatement() {
        return this.lockStatement;
    }

    public void toOracle(InsertQueryStatement q) throws ConvertException {
        Object obj;
        int i;
        Object obj2;
        String[] keywords = null;
        if (SwisSQLUtils.getKeywords(1) != null) {
            keywords = SwisSQLUtils.getKeywords(1);
        }
        this.optionalSpecifier = new OptionalSpecifier();
        this.optionalSpecifier.setInto("INTO");
        this.tblExp.toOracle();
        ArrayList<Integer> oracleColTruncForDEFAULT = new ArrayList<Integer>();
        ArrayList vcList = new ArrayList();
        ValuesClause vc = q.getValuesClause();
        ArrayList tablesList = this.tblExp.getTableClauseList();
        String tableName = null;
        if (tablesList != null && tablesList.size() > 0 && (obj2 = tablesList.get(0)) instanceof TableClause) {
            TableClause tc = (TableClause)obj2;
            TableObject to = tc.getTableObject();
            tableName = to.getTableName();
            tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, keywords, null, 1);
            to.setTableName(tableName);
        }
        if (this.with != null && this.lock != null) {
            if (this.lock.equalsIgnoreCase("TABLOCK") || this.lock.equalsIgnoreCase("UPDLOCK")) {
                this.lock = "SHARE";
            }
            if (this.lock.equalsIgnoreCase("TABLOCKX")) {
                this.lock = "EXCLUSIVE";
            }
            if (!(this.lock.equalsIgnoreCase("NOLOCK") || this.lock.equalsIgnoreCase("ROWLOCK") || this.lock.equalsIgnoreCase("XLOCK"))) {
                String lockTableStatement = "LOCK TABLE " + tableName + " IN " + this.lock + " MODE;";
                if (SwisSQLOptions.handleLOCK_HINTSforOracle) {
                    this.setLockStatement(lockTableStatement);
                }
            }
        }
        if (vc != null) {
            vcList = vc.getValuesList();
        }
        if (vcList != null && vcList.size() > 3) {
            for (int j = 0; j < vcList.size(); ++j) {
                if (!vcList.get(j).toString().trim().toLowerCase().equals("default")) continue;
                oracleColTruncForDEFAULT.add(new Integer(j));
                if (j != vcList.size() - 2) {
                    oracleColTruncForDEFAULT.add(new Integer(j + 1));
                    continue;
                }
                oracleColTruncForDEFAULT.add(new Integer(j - 1));
            }
        }
        ArrayList<Integer> dateTypeColumnIndex = new ArrayList<Integer>();
        ArrayList<String> dateTypeColumnNames = new ArrayList<String>();
        if (tableName != null) {
            ArrayList colList = (ArrayList)CastingUtil.getValueIgnoreCase(SwisSQLAPI.tableColumnListMetadata, tableName);
            Hashtable colDatatypeTable = (Hashtable)CastingUtil.getValueIgnoreCase(SwisSQLAPI.dataTypesFromMetaDataHT, tableName);
            if (colList != null && colDatatypeTable != null) {
                for (i = 0; i < colList.size(); ++i) {
                    String columnName = (String)colList.get(i);
                    String dataType = (String)CastingUtil.getValueIgnoreCase(colDatatypeTable, columnName);
                    if (dataType == null || dataType.toLowerCase().indexOf("datetime") == -1 && dataType.toLowerCase().indexOf("date") == -1) continue;
                    if (this.columnList != null) {
                        dateTypeColumnNames.add(columnName.toLowerCase());
                        continue;
                    }
                    dateTypeColumnIndex.add(new Integer(i + 1));
                }
            }
        }
        if (vcList != null) {
            int valueCount = 0;
            for (int j = 0; j < vcList.size(); ++j) {
                Object selObj = vcList.get(j);
                if (!(selObj instanceof SelectColumn) || ((SelectColumn)selObj).getColumnExpression().size() != 1) continue;
                String value = selObj.toString().trim();
                if (!(value.equals(",") || value.equals("(") || value.equals(")"))) {
                    ++valueCount;
                }
                String insertColumnName = null;
                if (this.columnList != null && vcList.size() == this.columnList.size() && ((insertColumnName = this.columnList.get(j).toString().trim().toLowerCase()).startsWith("\"") || insertColumnName.startsWith("["))) {
                    insertColumnName = insertColumnName.substring(1, insertColumnName.length() - 1);
                }
                if (!value.startsWith("'") || !dateTypeColumnIndex.contains(new Integer(valueCount)) && (insertColumnName == null || !dateTypeColumnNames.contains(insertColumnName)) || !((obj = vcList.get(j)) instanceof SelectColumn)) continue;
                String format = SwisSQLUtils.getDateFormat(value, 1);
                FunctionCalls fc = new FunctionCalls();
                TableColumn tc = new TableColumn();
                tc.setColumnName("TO_DATE");
                Vector<String> fnArgs = new Vector<String>();
                if (format == null) continue;
                if (format.startsWith("'1900")) {
                    fnArgs.add(format);
                    fnArgs.add("'YYYY-MM-DD HH24:MI:SS'");
                } else {
                    fnArgs.add(value);
                    fnArgs.add(format);
                }
                fc.setFunctionName(tc);
                fc.setFunctionArguments(fnArgs);
                ((SelectColumn)obj).getColumnExpression().setElementAt(fc, 0);
            }
        }
        if (this.columnList != null) {
            int i2;
            int siz = this.columnList.size();
            for (i2 = 0; i2 < this.columnList.size(); ++i2) {
                if (!(this.columnList.get(i2) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i2);
                if (!(columnName.trim().equals(",") || columnName.trim().startsWith("/*") || columnName.trim().startsWith("--"))) {
                    columnName = CustomizeUtil.objectNamesToQuotedIdentifier(columnName, keywords, null, 1);
                }
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (!(columnName.startsWith("\"") || columnName.trim().startsWith("/*") || columnName.trim().startsWith("--") || !SwisSQLOptions.retainQuotedIdentifierForOracle && columnName.indexOf(32) == -1)) {
                    columnName = "\"" + columnName + "\"";
                }
                boolean addQuotes = false;
                if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                    addQuotes = true;
                }
                if (columnName.length() > 30 && !columnName.trim().startsWith("/*") && !columnName.trim().startsWith("--")) {
                    columnName = columnName.substring(0, 30);
                }
                if (addQuotes) {
                    columnName = "\"" + columnName + "\"";
                }
                if (!oracleColTruncForDEFAULT.contains(new Integer(i2))) {
                    this.columnList.set(i2, columnName);
                    continue;
                }
                isOracleDEFColTruncated = true;
                this.columnList.set(i2, null);
            }
            if (isOracleDEFColTruncated) {
                for (i2 = 0; i2 < this.columnList.size(); ++i2) {
                    String str2;
                    this.columnList.remove(null);
                    if (i2 != this.columnList.size() - 2 || this.columnList.get(i2) == null || !(str2 = (String)this.columnList.get(i2)).equals(",")) continue;
                    this.columnList.remove(i2);
                }
            }
        }
        if (q.getSubQuery() != null) {
            int valueCount = 0;
            ArrayList<Integer> dateColumnIndexList = new ArrayList<Integer>();
            if (this.columnList != null) {
                for (i = 0; i < this.columnList.size(); ++i) {
                    if (!(this.columnList.get(i) instanceof String)) continue;
                    String columnName = this.columnList.get(i).toString();
                    if (!(columnName.equals(",") || columnName.equals("(") || columnName.equals(")"))) {
                        ++valueCount;
                    }
                    if (!dateTypeColumnNames.contains(columnName.toLowerCase())) continue;
                    dateColumnIndexList.add(new Integer(valueCount));
                }
            }
            SelectQueryStatement local_Stmt = q.getSubQuery();
            Vector selectQueryColumns = local_Stmt.getSelectStatement().getSelectItemList();
            for (int i3 = 0; i3 < selectQueryColumns.size(); ++i3) {
                String value;
                if (!dateColumnIndexList.contains(new Integer(i3 + 1)) || !((obj = selectQueryColumns.get(i3)) instanceof SelectColumn) || !(value = obj.toString()).startsWith("'")) continue;
                if (value.indexOf(",") == value.length() - 1) {
                    value = value.substring(0, value.length() - 1);
                }
                String format = SwisSQLUtils.getDateFormat(value, 1);
                FunctionCalls fc = new FunctionCalls();
                TableColumn tc = new TableColumn();
                tc.setColumnName("TO_DATE");
                Vector<String> fnArgs = new Vector<String>();
                if (format == null) continue;
                if (format.startsWith("'1900")) {
                    fnArgs.add(format);
                    fnArgs.add("'YYYY-MM-DD HH24:MI:SS'");
                } else {
                    fnArgs.add(value);
                    fnArgs.add(format);
                }
                fc.setFunctionName(tc);
                fc.setFunctionArguments(fnArgs);
                ((SelectColumn)obj).getColumnExpression().setElementAt(fc, 0);
            }
        }
    }

    public void toSQLServer(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        if (this.optionalSpecifier.toString().indexOf("INTO") != -1) {
            this.optionalSpecifier = new OptionalSpecifier();
            this.optionalSpecifier.setInto("INTO");
        } else {
            this.optionalSpecifier = null;
        }
        this.tblExp.toMSSQLServer();
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (!(this.columnList.get(i) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i);
                if (!(columnName.trim().equals(",") || columnName.trim().startsWith("/*") || columnName.trim().startsWith("--"))) {
                    columnName = CustomizeUtil.objectNamesToBracedIdentifier(columnName, SwisSQLUtils.getKeywords(2), null);
                }
                if (columnName.startsWith("`") && columnName.endsWith("`") && (columnName = columnName.substring(1, columnName.length() - 1)).indexOf(32) != -1) {
                    columnName = "\"" + columnName + "\"";
                }
                this.columnList.set(i, columnName);
            }
        }
    }

    public void toSybase(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        if (this.optionalSpecifier.toString().indexOf("INTO") != -1) {
            this.optionalSpecifier = new OptionalSpecifier();
            this.optionalSpecifier.setInto("INTO");
        } else {
            this.optionalSpecifier = null;
        }
        this.tblExp.toSybase();
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (!(this.columnList.get(i) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i);
                if (columnName.startsWith("`") && columnName.endsWith("`") && (columnName = columnName.substring(1, columnName.length() - 1)).indexOf(32) != -1) {
                    columnName = "\"" + columnName + "\"";
                }
                this.columnList.set(i, columnName);
            }
        }
    }

    public void toDB2(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        this.optionalSpecifier = new OptionalSpecifier();
        this.optionalSpecifier.setInto("INTO");
        this.tblExp.setTableNameforAliasNameInDB2Insert(true);
        this.tblExp.toDB2();
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (!(this.columnList.get(i) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i);
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (columnName.indexOf(32) != -1 && !columnName.trim().startsWith("/*") && !columnName.trim().startsWith("--")) {
                    columnName = "\"" + columnName + "\"";
                }
                this.columnList.set(i, columnName);
            }
        }
    }

    public void toPostgres(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        this.optionalSpecifier = new OptionalSpecifier();
        this.optionalSpecifier.setInto("INTO");
        this.tblExp.toPostgreSQL();
    }

    public void toANSISQL(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        this.optionalSpecifier = new OptionalSpecifier();
        this.optionalSpecifier.setInto("INTO");
        this.tblExp.toANSISQL();
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (!(this.columnList.get(i) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i);
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (columnName.indexOf(32) != -1 && !columnName.trim().startsWith("/*") && !columnName.trim().startsWith("--")) {
                    columnName = "\"" + columnName + "\"";
                }
                this.columnList.set(i, columnName);
            }
        }
    }

    public void toTeradata(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        this.optionalSpecifier = new OptionalSpecifier();
        this.optionalSpecifier.setInto("INTO");
        this.tblExp.toTeradata();
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (!(this.columnList.get(i) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i);
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (columnName.indexOf(32) != -1 && !columnName.trim().startsWith("/*") && !columnName.trim().startsWith("--")) {
                    columnName = "\"" + columnName + "\"";
                }
                if (!(columnName.equalsIgnoreCase("(") || columnName.equalsIgnoreCase(")") || columnName.equalsIgnoreCase(",") || columnName.trim().startsWith("/*") || columnName.trim().startsWith("--"))) {
                    columnName = CustomizeUtil.objectNamesToQuotedIdentifier(columnName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                }
                this.columnList.set(i, columnName);
            }
        }
    }

    public void toMySQL(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        this.tblExp.toMySQL();
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (!(this.columnList.get(i) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i);
                if (columnName.startsWith("[") && columnName.endsWith("]") && (columnName = columnName.substring(1, columnName.length() - 1)).indexOf(32) != -1) {
                    columnName = "\"" + columnName + "\"";
                }
                this.columnList.set(i, columnName);
            }
        }
    }

    public void toInformix(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        this.optionalSpecifier = new OptionalSpecifier();
        this.optionalSpecifier.setInto("INTO");
        this.tblExp.toInformix();
    }

    public void toTimesTen(InsertQueryStatement q) throws ConvertException {
        Object obj;
        this.setCommentClass(null);
        this.optionalSpecifier = new OptionalSpecifier();
        this.optionalSpecifier.setInto("INTO");
        this.tblExp.toTimesTen();
        ArrayList vcList = new ArrayList();
        ValuesClause vc = q.getValuesClause();
        ArrayList tblList = this.tblExp.getTableClauseList();
        String tableName = null;
        if (tblList != null && (obj = tblList.get(0)) instanceof TableClause) {
            tableName = ((TableClause)obj).getTableObject().getTableName();
        }
        ArrayList<Integer> dateTypeColumnIndex = new ArrayList<Integer>();
        ArrayList<String> dateTypeColumnNames = new ArrayList<String>();
        ArrayList<Integer> dateTimeColumnIndex = new ArrayList<Integer>();
        ArrayList<String> dateTimeColumnNames = new ArrayList<String>();
        ArrayList<Integer> unicodeColumnIndex = new ArrayList<Integer>();
        ArrayList<String> unicodeColumnNames = new ArrayList<String>();
        if (tableName != null) {
            ArrayList colList = (ArrayList)CastingUtil.getValueIgnoreCase(SwisSQLAPI.tableColumnListMetadata, tableName);
            Hashtable colDatatypeTable = (Hashtable)CastingUtil.getValueIgnoreCase(SwisSQLAPI.dataTypesFromMetaDataHT, tableName);
            if (colList != null && colDatatypeTable != null) {
                for (int i = 0; i < colList.size(); ++i) {
                    String columnName = (String)colList.get(i);
                    String dataType = (String)CastingUtil.getValueIgnoreCase(colDatatypeTable, columnName);
                    if (dataType == null) continue;
                    if (dataType.toLowerCase().indexOf("date") != -1 || dataType.toLowerCase().indexOf("time") != -1) {
                        if (this.columnList != null) {
                            dateTypeColumnNames.add(columnName.toLowerCase());
                        } else {
                            dateTypeColumnIndex.add(new Integer(i + 1));
                        }
                        if (dataType.toLowerCase().indexOf("datetime") == -1) continue;
                        if (this.columnList != null) {
                            dateTimeColumnNames.add(columnName.toLowerCase());
                            continue;
                        }
                        dateTimeColumnIndex.add(new Integer(i + 1));
                        continue;
                    }
                    if (dataType.indexOf("unichar") == -1 && dataType.indexOf("univarchar") == -1 && dataType.indexOf("nchar") == -1 && dataType.indexOf("nvarchar") == -1) continue;
                    if (this.columnList != null) {
                        unicodeColumnNames.add(columnName.toLowerCase());
                        continue;
                    }
                    unicodeColumnIndex.add(new Integer(i + 1));
                }
            }
        }
        if (this.columnList != null) {
            int siz = this.columnList.size();
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (!(this.columnList.get(i) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i);
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                    this.columnList.set(i, columnName);
                }
                if (columnName.startsWith("\"") || columnName.indexOf(32) == -1) continue;
                columnName = "\"" + columnName + "\"";
                this.columnList.set(i, columnName);
            }
        }
        if (vc != null) {
            vcList = vc.getValuesList();
        }
        if (vcList != null) {
            int valueCount = 0;
            for (int j = 0; j < vcList.size(); ++j) {
                Vector colExpr;
                Object obj2;
                if (vcList.get(j).toString().trim().toLowerCase().equals("default")) {
                    throw new ConvertException("\n DEFAULT values are not supported in TimesTen 5.1.21\n");
                }
                String value = vcList.get(j).toString().trim();
                if (!(value.equals(",") || value.equals("(") || value.equals(")"))) {
                    ++valueCount;
                }
                if (value.startsWith("'") && (dateTypeColumnIndex.contains(new Integer(valueCount)) || this.columnList != null && dateTypeColumnNames.contains(this.columnList.get(j).toString().trim().toLowerCase()))) {
                    obj2 = vcList.get(j);
                    if (!(obj2 instanceof SelectColumn)) continue;
                    String format = SwisSQLUtils.getDateFormat(value, 10);
                    if (format != null && (format.equals("YYYY-MM-DD") || format.equals("HH24:MI:SS"))) {
                        if (dateTimeColumnIndex.contains(new Integer(valueCount)) || this.columnList != null && dateTypeColumnNames.contains(this.columnList.get(j).toString().trim().toLowerCase())) {
                            value = format.equals("YYYY-MM-DD") ? value.substring(0, value.length() - 1) + " 00:00:00'" : "'1900-01-01 " + value.substring(1);
                            ((SelectColumn)obj2).getColumnExpression().setElementAt(value, 0);
                        }
                        format = null;
                    }
                    if (format == null) continue;
                    if (format.startsWith("'1900")) {
                        ((SelectColumn)obj2).getColumnExpression().setElementAt(format, 0);
                        continue;
                    }
                    if (format.equals(value)) {
                        int len;
                        value = value.substring(1, value.length() - 1);
                        String time = "";
                        int index = 0;
                        index = value.indexOf(" ");
                        if (index != -1) {
                            time = value.substring(index + 1);
                            value = value.substring(0, index);
                        }
                        if ((len = value.length()) == 8) {
                            value = value.substring(0, 4) + "-" + value.substring(4, 6) + "-" + value.substring(6);
                        } else if (len == 6) {
                            String yearStr = value.substring(0, 2);
                            int year2 = Integer.parseInt(yearStr);
                            yearStr = year2 < 50 ? "20" + yearStr : "19" + yearStr;
                            value = yearStr + "-" + value.substring(2, 4) + "-" + value.substring(4);
                        }
                        if ((dateTimeColumnIndex.contains(new Integer(valueCount)) || this.columnList != null && dateTypeColumnNames.contains(this.columnList.get(j).toString().trim().toLowerCase())) && time == "") {
                            value = value + " 00:00:00";
                        } else if (time != "") {
                            value = value + " " + time;
                        }
                        ((SelectColumn)obj2).getColumnExpression().setElementAt("'" + value + "'", 0);
                        continue;
                    }
                    FunctionCalls fc = new FunctionCalls();
                    TableColumn tc = new TableColumn();
                    tc.setColumnName("TO_DATE");
                    Vector<String> fnArgs = new Vector<String>();
                    fnArgs.add(value);
                    fnArgs.add(format);
                    fc.setFunctionName(tc);
                    fc.setFunctionArguments(fnArgs);
                    ((SelectColumn)obj2).getColumnExpression().setElementAt(fc, 0);
                    continue;
                }
                if (!value.startsWith("'") || !unicodeColumnIndex.contains(new Integer(valueCount)) && (this.columnList == null || !unicodeColumnNames.contains(this.columnList.get(j).toString().trim().toLowerCase())) || !((obj2 = vcList.get(j)) instanceof SelectColumn) || (colExpr = ((SelectColumn)obj2).getColumnExpression()).size() != 1) continue;
                colExpr.setElementAt("N" + value, 0);
            }
        }
    }

    public void toNetezza(InsertQueryStatement q) throws ConvertException {
        this.setCommentClass(null);
        this.optionalSpecifier = new OptionalSpecifier();
        this.optionalSpecifier.setInto("INTO");
        SelectQueryStatement tempSubQuery = this.tblExp.getSubQuery();
        if (this.columnList == null && tempSubQuery != null) {
            ArrayList<Object> newColumnList = new ArrayList<Object>();
            SelectQueryStatement tblExpSubQuery = tempSubQuery;
            Vector tblExpSubQuerySelectItems = tblExpSubQuery.getSelectStatement().getSelectItemList();
            newColumnList.add("(");
            for (int i = 0; i < tblExpSubQuerySelectItems.size(); ++i) {
                if (tblExpSubQuerySelectItems.elementAt(i) instanceof SelectColumn) {
                    newColumnList.add(((SelectColumn)tblExpSubQuerySelectItems.elementAt(i)).toNetezzaSelect(tblExpSubQuery, tblExpSubQuery));
                    continue;
                }
                newColumnList.add((String)tblExpSubQuerySelectItems.elementAt(i));
            }
            newColumnList.add(")");
            this.setColumnList(newColumnList);
        }
        this.tblExp.toNetezza();
        if (this.columnList != null) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (!(this.columnList.get(i) instanceof String)) continue;
                String columnName = (String)this.columnList.get(i);
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (columnName.indexOf(32) != -1 && !columnName.trim().startsWith("/*") && !columnName.trim().startsWith("--")) {
                    columnName = "\"" + columnName + "\"";
                }
                if (!(columnName.equalsIgnoreCase("(") || columnName.equalsIgnoreCase(")") || columnName.equalsIgnoreCase(",") || columnName.trim().startsWith("/*") || columnName.trim().startsWith("--"))) {
                    columnName = CustomizeUtil.objectNamesToQuotedIdentifier(columnName, SwisSQLUtils.getKeywords(11), null, 11);
                }
                this.columnList.set(i, columnName);
            }
        }
        if (this.columnList == null && tempSubQuery != null && this.tblExp.getSubQuery() == null) {
            SelectQueryStatement tblExpSubQuery = tempSubQuery;
            Vector tblExpSubQuerySelectItems = tblExpSubQuery.getSelectStatement().getSelectItemList();
            for (int i = 0; i < tblExpSubQuerySelectItems.size(); ++i) {
                if (tblExpSubQuerySelectItems.elementAt(i) instanceof SelectColumn) {
                    this.columnList.add(((SelectColumn)tblExpSubQuerySelectItems.elementAt(i)).toNetezzaSelect(tblExpSubQuery, tblExpSubQuery));
                    continue;
                }
                this.columnList.add((String)tblExpSubQuerySelectItems.elementAt(i));
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.insert.toUpperCase());
        sb.append(" ");
        if (this.commentObj != null) {
            sb.append(this.commentObj.toString().trim() + " ");
        }
        if (this.optionalSpecifier != null) {
            sb.append(this.optionalSpecifier.toString());
            sb.append(" ");
        }
        if (this.tblExp != null) {
            if (this.context != null) {
                this.tblExp.setObjectContext(this.context);
            }
            sb.append(this.tblExp.toString());
            sb.append(" ");
        }
        if (this.columnList != null) {
            int size = this.columnList.size();
            SelectQueryStatement.beautyTabCount += 2;
            for (int i = 0; i < size; ++i) {
                String isCommaOrOpenBrace = "";
                if (this.columnList.get(i) instanceof String) {
                    isCommaOrOpenBrace = (String)this.columnList.get(i);
                }
                if (isCommaOrOpenBrace.trim().equals("(")) {
                    sb.append("\n");
                    for (int j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                        sb.append("\t");
                    }
                }
                if (this.context != null) {
                    String temp = this.context.getEquivalent(this.columnList.get(i)).toString();
                    sb.append(temp + " ");
                } else {
                    sb.append(this.columnList.get(i) + " ");
                }
                if (!isCommaOrOpenBrace.equals(",")) continue;
                sb.append("\n");
                for (int j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                    sb.append("\t");
                }
            }
            SelectQueryStatement.beautyTabCount -= 2;
        }
        return sb.toString();
    }
}

