/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.create;

import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.statement.create.ConstraintType;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import java.util.Vector;

public class CheckConstraintClause
implements ConstraintType {
    private Vector constraintColumnNames;
    private String constraintName;
    private String openBrace;
    private String closedBrace;
    private UserObjectContext context = null;
    private String objectName = null;
    private String stmtTableName;
    WhereExpression whereExpression;

    public void setObjectName(String name) {
        this.objectName = name;
    }

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setConstraintColumnNames(Vector constraintColumnNames) {
        this.constraintColumnNames = constraintColumnNames;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setWhereExpression(WhereExpression whereExpression) {
        this.whereExpression = whereExpression;
    }

    public void setOpenBrace(String openBrace) {
        this.openBrace = openBrace;
    }

    public void setClosedBrace(String closedBrace) {
        this.closedBrace = closedBrace;
    }

    public void setStmtTableName(String stmtTableName) {
        this.stmtTableName = stmtTableName;
    }

    public Vector getConstraintColumnNames() {
        return this.constraintColumnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public WhereExpression getWhereExpression() {
        return this.whereExpression;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.constraintName != null) {
            sb.append(this.constraintName.toUpperCase() + " ");
        }
        if (this.openBrace != null) {
            sb.append(this.openBrace);
        }
        if (this.constraintColumnNames != null) {
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                String temp;
                String sss;
                String s;
                String col = this.constraintColumnNames.get(i).toString();
                if (this.objectName != null && this.context != null && !(s = this.objectName + "." + col).equals(sss = this.context.getEquivalent(s).toString())) {
                    col = sss;
                }
                if (i == 0) {
                    if (this.context != null) {
                        temp = this.context.getEquivalent(col).toString();
                        sb.append(temp);
                        continue;
                    }
                    sb.append(col);
                    continue;
                }
                if (this.context != null) {
                    temp = this.context.getEquivalent(col).toString();
                    sb.append(", " + temp);
                    continue;
                }
                sb.append(", " + col);
            }
        }
        if (this.whereExpression != null) {
            this.whereExpression.setObjectContext(this.context);
            sb.append(this.whereExpression.toString());
        }
        if (this.closedBrace != null) {
            sb.append(this.closedBrace + " ");
        }
        return sb.toString();
    }

    @Override
    public void toDB2String() throws ConvertException {
        this.getWhereExpression().setStmtTableName(this.stmtTableName);
        WhereExpression newWhereExpression = this.getWhereExpression().toDB2Select(null, null);
        this.setWhereExpression(newWhereExpression);
    }

    @Override
    public void toMSSQLServerString() throws ConvertException {
        WhereExpression newWhereExpression = this.getWhereExpression().toMSSQLServerSelect(null, null);
        this.setWhereExpression(newWhereExpression);
    }

    @Override
    public void toSybaseString() throws ConvertException {
        WhereExpression newWhereExpression = this.getWhereExpression().toSybaseSelect(null, null);
        this.setWhereExpression(newWhereExpression);
    }

    @Override
    public void toOracleString() throws ConvertException {
        WhereExpression newWhereExpression = this.getWhereExpression().toOracleSelect(null, null);
        Vector whereItems = newWhereExpression.getWhereItems();
        for (int i = 0; i < whereItems.size(); ++i) {
            WhereColumn wc;
            WhereItem wi1;
            if (!(whereItems.elementAt(i) instanceof WhereItem) || (wi1 = (WhereItem)whereItems.elementAt(i)) == null || !wi1.getOperator().equalsIgnoreCase("IN") || (wc = wi1.getRightWhereExp()) == null) continue;
            Vector v = wc.getColumnExpression();
            Vector<String> newVec = new Vector<String>();
            if (v.contains(",")) {
                for (int k = 0; k < v.size(); ++k) {
                    String str2 = v.get(k).toString();
                    if ((str2 = str2.trim()).startsWith("\"") && str2.endsWith("\"")) {
                        str2 = str2.substring(1, str2.length() - 1);
                        str2 = "'" + str2 + "'";
                    }
                    newVec.insertElementAt(str2, k);
                }
            }
            wc.setColumnExpression(newVec);
        }
        this.setWhereExpression(newWhereExpression);
    }

    @Override
    public void toPostgreSQLString() throws ConvertException {
        WhereExpression newWhereExpression = this.getWhereExpression().toPostgreSQLSelect(null, null);
        this.setWhereExpression(newWhereExpression);
    }

    @Override
    public void toANSIString() throws ConvertException {
        WhereExpression newWhereExpression = this.getWhereExpression().toANSISelect(null, null);
        this.setWhereExpression(newWhereExpression);
    }

    @Override
    public void toMySQLString() throws ConvertException {
        WhereExpression newWhereExpression = this.getWhereExpression().toMySQLSelect(null, null);
        this.setWhereExpression(newWhereExpression);
    }

    @Override
    public void toInformixString() throws ConvertException {
        WhereExpression newWhereExpression = this.getWhereExpression().toInformixSelect(null, null);
        this.setWhereExpression(newWhereExpression);
    }

    @Override
    public void toTimesTenString() throws ConvertException {
    }

    @Override
    public void toNetezzaString() throws ConvertException {
    }

    @Override
    public void toTeradataString() throws ConvertException {
        WhereExpression newWhereExpression = this.getWhereExpression().toTeradataSelect(null, null);
        this.setWhereExpression(newWhereExpression);
    }

    public ConstraintType copyObjectValues() {
        CheckConstraintClause dupCheckConstraintClause = new CheckConstraintClause();
        dupCheckConstraintClause.setClosedBrace(this.closedBrace);
        dupCheckConstraintClause.setConstraintColumnNames(this.getConstraintColumnNames());
        dupCheckConstraintClause.setConstraintName(this.getConstraintName());
        dupCheckConstraintClause.setOpenBrace(this.openBrace);
        dupCheckConstraintClause.setWhereExpression(this.getWhereExpression());
        dupCheckConstraintClause.setObjectContext(this.context);
        dupCheckConstraintClause.setObjectName(this.objectName);
        return dupCheckConstraintClause;
    }
}

