/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.functions.math;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.create.NumericClass;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.misc.CastingUtil;
import java.util.Vector;

public class round
extends FunctionCalls {
    @Override
    public void toOracle(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toOracleSelect(to_sqs, from_sqs));
            } else {
                arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
            }
            if (i_count != 2) continue;
            String value = arguments.get(2).toString().trim();
            if (!value.equals("0")) {
                this.functionName.setColumnName("TRUNC");
            }
            arguments.removeElementAt(2);
        }
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toMSSQLServer(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
        if (this.functionArguments.size() == 1) {
            this.functionName.setColumnName("CAST");
            Vector<String> newArg = new Vector<String>();
            StringBuffer argBuffer = new StringBuffer();
            argBuffer.append("ROUND(");
            argBuffer.append(this.functionArguments.get(0).toString());
            argBuffer.append(",0) AS INTEGER");
            newArg.add(argBuffer.toString());
            this.setFunctionArguments(newArg);
        }
    }

    @Override
    public void toSybase(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toSybaseSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
        if (this.functionArguments.size() == 1) {
            this.functionName.setColumnName("CONVERT");
            Vector<String> newArg = new Vector<String>();
            StringBuffer argBuffer = new StringBuffer();
            argBuffer.append("INTEGER,ROUND(");
            argBuffer.append(this.functionArguments.get(0).toString());
            argBuffer.append(",0)");
            newArg.add(argBuffer.toString());
            this.setFunctionArguments(newArg);
        }
    }

    @Override
    public void toDB2(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toDB2Select(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
        if (this.functionArguments.size() == 1) {
            this.functionName.setColumnName("CAST");
            Vector<String> newArg = new Vector<String>();
            StringBuffer argBuffer = new StringBuffer();
            argBuffer.append("ROUND(");
            argBuffer.append(this.functionArguments.get(0).toString());
            argBuffer.append(",0) AS INTEGER");
            newArg.add(argBuffer.toString());
            this.setFunctionArguments(newArg);
        }
    }

    @Override
    public void toPostgreSQL(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toPostgreSQLSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toMySQL(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toMySQLSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toANSISQL(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toANSISelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toTeradata(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<Object> arguments = new Vector<Object>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement(this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
        if (arguments.size() == 1) {
            boolean isDateArg = false;
            Object obj = arguments.firstElement();
            if (obj instanceof SelectColumn) {
                SelectColumn sc = (SelectColumn)obj;
                for (int k = 0; k < sc.getColumnExpression().size(); ++k) {
                    String returnType;
                    FunctionCalls dateFunc;
                    Object scObj = sc.getColumnExpression().get(k);
                    if (scObj instanceof TableColumn) {
                        TableColumn tc = (TableColumn)scObj;
                        if (CastingUtil.getValueIgnoreCase(SwisSQLAPI.columnDatatypes, tc.getColumnName()) != null && CastingUtil.getValueIgnoreCase(SwisSQLAPI.columnDatatypes, tc.getColumnName()).toString().equalsIgnoreCase("timestamp")) {
                            isDateArg = true;
                        }
                        if (!tc.getColumnName().toLowerCase().startsWith("current_date") && !tc.getColumnName().toLowerCase().startsWith("current_time")) continue;
                        isDateArg = true;
                        continue;
                    }
                    if (!(scObj instanceof FunctionCalls) || (dateFunc = (FunctionCalls)scObj).getFunctionName() == null || !(returnType = SwisSQLUtils.getFunctionReturnType(dateFunc.getFunctionName().getColumnName(), dateFunc.getFunctionArguments())).equalsIgnoreCase("date") && !returnType.equalsIgnoreCase("timestamp")) continue;
                    isDateArg = true;
                }
                if (isDateArg && sc.getColumnExpression().size() > 1) {
                    sc.getColumnExpression().add("DAY(4)");
                    this.functionName.setColumnName("");
                } else if (!isDateArg) {
                    this.functionName.setColumnName("CAST");
                    NumericClass nc = new NumericClass();
                    this.setAsDatatype("AS");
                    nc.setDatatypeName("DECIMAL");
                    nc.setOpenBrace("(");
                    nc.setPrecision("38");
                    nc.setScale("0");
                    nc.setClosedBrace(")");
                    arguments.add(nc);
                    this.setFunctionArguments(arguments);
                }
            }
        } else if (arguments.size() == 2) {
            boolean isInteger = false;
            try {
                Integer.parseInt(arguments.get(1).toString());
                isInteger = true;
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
            if (isInteger) {
                this.functionName.setColumnName("CAST");
                NumericClass nc = new NumericClass();
                this.setAsDatatype("AS");
                nc.setDatatypeName("DECIMAL");
                nc.setOpenBrace("(");
                nc.setPrecision("38");
                String prec = arguments.get(1).toString();
                nc.setScale(this.getModifiedPrecision(prec));
                nc.setClosedBrace(")");
                arguments.setElementAt(nc, 1);
                this.setFunctionArguments(arguments);
            }
        }
    }

    public String getModifiedPrecision(String num) {
        try {
            int number = Integer.parseInt(num);
            if (number > 22) {
                number = 22;
            }
            return "" + number;
        }
        catch (NumberFormatException numberFormatException) {
            return num;
        }
    }

    @Override
    public void toInformix(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toInformixSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
        if (this.functionArguments.size() == 1) {
            this.functionName.setColumnName("CAST");
            Vector<String> newArg = new Vector<String>();
            StringBuffer argBuffer = new StringBuffer();
            argBuffer.append("ROUND(");
            argBuffer.append(this.functionArguments.get(0).toString());
            argBuffer.append(",0) AS INTEGER");
            newArg.add(argBuffer.toString());
            this.setFunctionArguments(newArg);
        }
    }

    @Override
    public void toTimesTen(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        throw new ConvertException("\nThe function ROUND is not supported in TimesTen 5.1.21\n");
    }

    @Override
    public void toNetezza(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("ROUND");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < this.functionArguments.size(); ++i_count) {
            if (this.functionArguments.elementAt(i_count) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i_count)).toNetezzaSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i_count));
        }
        this.setFunctionArguments(arguments);
    }
}

