/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.functions.date;

import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import java.util.StringTokenizer;
import java.util.Vector;

public class date
extends FunctionCalls {
    @Override
    public void toOracle(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String fnName = this.functionName.getColumnName();
        this.functionName.setColumnName("TO_DATE");
        Vector arguments = new Vector();
        int argsCnt = this.functionArguments.size();
        if (fnName.equalsIgnoreCase("SYSDATE") && argsCnt == 1) {
            Object arg = this.functionArguments.elementAt(0);
            if (arg instanceof SelectColumn) {
                Object argData = ((SelectColumn)arg).getColumnExpression().get(0);
                String format = null;
                if (argData instanceof String && (format = this.getDB2DateFormat((String)argData)) != null) {
                    arguments.addElement(arg);
                    SelectColumn sc = new SelectColumn();
                    Vector<String> colExpr = new Vector<String>(1);
                    colExpr.add(format);
                    sc.setColumnExpression(colExpr);
                    arguments.addElement(sc);
                } else {
                    arguments.addElement(((SelectColumn)arg).toOracleSelect(to_sqs, from_sqs));
                }
            } else {
                arguments.addElement(arg);
            }
        } else {
            for (int i = 0; i < argsCnt; ++i) {
                Object arg = this.functionArguments.elementAt(i);
                if (arg instanceof SelectColumn) {
                    arguments.addElement(((SelectColumn)arg).toOracleSelect(to_sqs, from_sqs));
                    continue;
                }
                arguments.addElement(arg);
            }
        }
        this.setFunctionArguments(arguments);
    }

    private String getDB2DateFormat(String date2) {
        if (date2.indexOf(".") != -1) {
            StringTokenizer st = new StringTokenizer(date2, ".");
            if (st.countTokens() == 3) {
                st.nextToken();
                st.nextToken();
                String token3 = st.nextToken();
                if (token3.length() == 5) {
                    return "'DD.MM.YYYY'";
                }
            }
        } else if (date2.indexOf("/") != -1) {
            StringTokenizer st = new StringTokenizer(date2, "/");
            if (st.countTokens() == 3) {
                st.nextToken();
                st.nextToken();
                String token3 = st.nextToken();
                if (token3.length() == 5) {
                    return "'MM/DD/YYYY'";
                }
            }
        } else if (date2.indexOf("-") != -1) {
            return this.getDB2DateFormatForHyphenatedDate(date2);
        }
        return null;
    }

    private String getDB2DateFormatForHyphenatedDate(String date2) {
        StringTokenizer st = new StringTokenizer(date2, "-");
        if (st.countTokens() == 3) {
            String token1 = st.nextToken();
            st.nextToken();
            String token3 = st.nextToken();
            if (token3.length() == 5) {
                return "'MM-DD-YYYY'";
            }
            if (token1.length() == 5) {
                return "'YYYY-MM-DD'";
            }
        }
        return null;
    }

    @Override
    public void toMSSQLServer(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("CONVERT");
        Vector<Object> arguments = new Vector<Object>();
        for (int i = 0; i < this.functionArguments.size(); ++i) {
            if (this.functionArguments.elementAt(i) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement(this.functionArguments.elementAt(i));
        }
        arguments.add(0, "DATETIME");
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toSybase(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("CONVERT");
        Vector<Object> arguments = new Vector<Object>();
        for (int i = 0; i < this.functionArguments.size(); ++i) {
            if (this.functionArguments.elementAt(i) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement(this.functionArguments.elementAt(i));
        }
        arguments.add(0, "DATETIME");
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toDB2(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("DATE");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i = 0; i < this.functionArguments.size(); ++i) {
            if (this.functionArguments.elementAt(i) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i)).toDB2Select(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i));
        }
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toPostgreSQL(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i = 0; i < this.functionArguments.size(); ++i) {
            if (this.functionArguments.elementAt(i) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i)).toPostgreSQLSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i));
        }
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toMySQL(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("DATE");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i = 0; i < this.functionArguments.size(); ++i) {
            if (this.functionArguments.elementAt(i) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i)).toMySQLSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i));
        }
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toANSISQL(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("DATE");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i = 0; i < this.functionArguments.size(); ++i) {
            if (this.functionArguments.elementAt(i) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i)).toANSISelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i));
        }
        this.setFunctionArguments(arguments);
    }

    @Override
    public void toNetezza(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        String[] dateArith;
        this.functionName.setColumnName("DATE");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i = 0; i < this.functionArguments.size(); ++i) {
            if (this.functionArguments.elementAt(i) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i)).toNetezzaSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i));
        }
        this.setFunctionArguments(arguments);
        if (this.getDateArithmetic() != null && (dateArith = this.getDateArithmetic().trim().split(" ")).length > 0 && (dateArith[0].equalsIgnoreCase("+") || dateArith[0].equalsIgnoreCase("-"))) {
            String newDateArith = " " + dateArith[0] + " " + dateArith[1] + " * " + " interval '1 " + dateArith[2] + "'";
            this.setDateArithmetic(newDateArith);
        }
    }

    @Override
    public void toTeradata(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.functionName.setColumnName("DATE");
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        for (int i = 0; i < this.functionArguments.size(); ++i) {
            if (this.functionArguments.elementAt(i) instanceof SelectColumn) {
                arguments.addElement(((SelectColumn)this.functionArguments.elementAt(i)).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            arguments.addElement((SelectColumn)this.functionArguments.elementAt(i));
        }
        this.setFunctionArguments(arguments);
    }
}

